/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.netbeans.modules.editor.lib.BeforeSaveTasks;

public final class TrailingWhitespaceRemove
implements BeforeSaveTasks.Task,
DocumentListener {
    static final Logger LOG = Logger.getLogger(TrailingWhitespaceRemove.class.getName());
    static final int GET_ELEMENT_INDEX_THRESHOLD = 100;
    Document doc;
    CharSequence docText;
    GapList<MutablePositionRegion> modRegions;
    private int lastRegionIndex;
    private boolean inWhitespaceRemove;

    public static synchronized TrailingWhitespaceRemove install(BaseDocument doc) {
        TrailingWhitespaceRemove twr = (TrailingWhitespaceRemove)doc.getProperty(TrailingWhitespaceRemove.class);
        if (twr == null) {
            twr = new TrailingWhitespaceRemove(doc);
            BeforeSaveTasks beforeSaveTasks = BeforeSaveTasks.get(doc);
            beforeSaveTasks.addTask(twr);
            doc.putProperty(TrailingWhitespaceRemove.class, twr);
        }
        return twr;
    }

    private TrailingWhitespaceRemove(BaseDocument doc) {
        this.doc = doc;
        this.docText = DocumentUtilities.getText((Document)doc);
        this.modRegions = this.emptyModRegions();
        doc.addUpdateDocumentListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run(UndoableEdit compoundEdit) {
        Preferences prefs = (Preferences)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((Document)this.doc)).lookup(Preferences.class);
        String policy = prefs.get("on-save-remove-trailing-whitespace", "never");
        if (!"never".equals(policy)) {
            this.inWhitespaceRemove = true;
            try {
                new ModsProcessor("modified-lines".equals(policy)).removeWhitespace();
                NewModRegionsEdit edit = new NewModRegionsEdit();
                compoundEdit.addEdit(edit);
                edit.run();
            }
            finally {
                this.inWhitespaceRemove = false;
            }
        }
    }

    public void resetModRegions() {
        this.modRegions = this.emptyModRegions();
    }

    GapList<MutablePositionRegion> emptyModRegions() {
        return new GapList(3);
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        UndoableEdit compoundEdit = (UndoableEdit)((Object)evt);
        int offset = evt.getOffset();
        int length = evt.getLength();
        boolean covered = false;
        if (this.lastRegionIndex >= 0 && this.lastRegionIndex < this.modRegions.size()) {
            covered = this.isCovered(offset, length);
        }
        if (!covered) {
            this.lastRegionIndex = this.findRegionIndex(offset, false);
            if (this.lastRegionIndex >= 0) {
                covered = this.isCovered(offset, length);
            }
        }
        if (!covered) {
            this.addRegion(compoundEdit, offset, offset + length);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        if (this.inWhitespaceRemove) {
            DocumentUtilities.putEventProperty((DocumentEvent)evt, (Object)"caretIgnore", (Object)Boolean.TRUE);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
    }

    private boolean isCovered(int offset, int length) {
        PositionRegion region = (PositionRegion)this.modRegions.get(this.lastRegionIndex);
        return region.getStartOffset() <= offset && offset + length <= region.getEndOffset();
    }

    private MutablePositionRegion addRegion(UndoableEdit compoundEdit, int startOffset, int endOffset) {
        try {
            MutablePositionRegion region = new MutablePositionRegion(this.doc, startOffset, endOffset);
            this.lastRegionIndex = this.findRegionIndex(startOffset, true);
            AddRegionEdit edit = new AddRegionEdit(this.lastRegionIndex, region);
            edit.run();
            compoundEdit.addEdit(edit);
            return region;
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
    }

    void addRegion(int index, MutablePositionRegion region) {
        this.modRegions.add(index, (Object)region);
    }

    private int findRegionIndex(int offset, boolean forInsert) {
        int low = 0;
        int high = this.modRegions.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midStartOffset = ((MutablePositionRegion)this.modRegions.get(mid)).getStartOffset();
            if (midStartOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (midStartOffset > offset) {
                high = mid - 1;
                continue;
            }
            while (++mid < this.modRegions.size() && ((MutablePositionRegion)this.modRegions.get(mid)).getStartOffset() == offset) {
            }
            --mid;
            if (forInsert) {
                low = mid + 1;
                break;
            }
            high = mid;
            break;
        }
        return forInsert ? low : high;
    }

    public void checkConsistency() {
        int lastOffset = 0;
        for (int i = 0; i < this.modRegions.size(); ++i) {
            PositionRegion region = (PositionRegion)this.modRegions.get(i);
            int offset = region.getStartOffset();
            if (offset < lastOffset) {
                throw new IllegalStateException("region[" + i + "].getStartOffset()=" + offset + " < lastOffset=" + lastOffset);
            }
            lastOffset = offset;
            offset = region.getEndOffset();
            if (offset < lastOffset) {
                throw new IllegalStateException("region[" + i + "].getEndOffset()=" + offset + " < region.getStartOffset()=" + lastOffset);
            }
            lastOffset = offset;
        }
    }

    public String toString() {
        int size = this.modRegions.size();
        int digitCount = String.valueOf(size).length();
        StringBuilder sb = new StringBuilder(100);
        for (int i = 0; i < size; ++i) {
            PositionRegion region = (PositionRegion)this.modRegions.get(i);
            ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)digitCount);
            sb.append(region.toString(this.doc));
            sb.append('\n');
        }
        return sb.toString();
    }

    private static void removeWhitespaceOnLine(int lineStartOffset, int lineLastOffset, int caretRelativeOffset, int lineIndex, int caretLineIndex, Document doc, CharSequence docText) {
        char c;
        int offset;
        int startOffset = lineStartOffset;
        if (lineIndex == caretLineIndex) {
            startOffset += caretRelativeOffset;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Line index " + lineIndex + " contains caret at relative offset " + caretRelativeOffset + ".\n");
            }
        }
        for (offset = lineLastOffset - 1; offset >= startOffset && ((c = docText.charAt(offset)) == ' ' || c == '\t'); --offset) {
        }
        if (++offset < lineLastOffset) {
            BadLocationException ble = null;
            try {
                doc.remove(offset, lineLastOffset - offset);
            }
            catch (BadLocationException e) {
                ble = e;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Remove between " + DocumentUtilities.debugOffset((Document)doc, (int)offset) + " and " + DocumentUtilities.debugOffset((Document)doc, (int)lineLastOffset) + (ble == null ? " succeeded." : " failed.") + '\n');
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.INFO, "Exception thrown during removal:", ble);
                }
            }
        }
    }

    private final class AddRegionEdit
    extends AbstractUndoableEdit {
        private int index;
        private MutablePositionRegion region;

        public AddRegionEdit(int index, MutablePositionRegion region) {
            this.index = index;
            this.region = region;
        }

        public void run() {
            TrailingWhitespaceRemove.this.addRegion(this.index, this.region);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Added region " + this.region + " at index=" + this.index + '\n');
                LOG.fine("Regions:\n" + TrailingWhitespaceRemove.this.modRegions + '\n');
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (this.index >= TrailingWhitespaceRemove.this.modRegions.size() || TrailingWhitespaceRemove.this.modRegions.get(this.index) != this.region) {
                this.index = TrailingWhitespaceRemove.this.findRegionIndex(this.region.getStartOffset(), false);
            }
            if (this.index >= 0 && TrailingWhitespaceRemove.this.modRegions.get(this.index) == this.region) {
                TrailingWhitespaceRemove.this.modRegions.remove(this.index);
            } else {
                TrailingWhitespaceRemove.this.modRegions.remove((Object)this.region);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Removed region " + this.region + " at index=" + this.index + '\n');
                LOG.fine("Regions:\n" + TrailingWhitespaceRemove.this.modRegions + '\n');
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.index = TrailingWhitespaceRemove.this.findRegionIndex(this.region.getStartOffset(), true);
            this.run();
        }
    }

    private final class ModsProcessor {
        private final boolean removeFromModifiedLinesOnly;
        private final Element lineElementRoot;
        private int regionIndex;
        private int regionStartOffset;
        private int regionEndOffset;
        private int lineIndex;
        private int lineStartOffset;
        private int lineLastOffset;
        private final int caretLineIndex;
        private final int caretRelativeOffset;

        ModsProcessor(boolean removeFromModifiedLinesOnly) {
            this.removeFromModifiedLinesOnly = removeFromModifiedLinesOnly;
            this.lineElementRoot = DocumentUtilities.getParagraphRootElement((Document)TrailingWhitespaceRemove.this.doc);
            JTextComponent lastFocusedComponent = EditorRegistry.lastFocusedComponent();
            if (lastFocusedComponent != null && lastFocusedComponent.getDocument() == TrailingWhitespaceRemove.this.doc) {
                int caretOffset = lastFocusedComponent.getCaretPosition();
                this.caretLineIndex = this.lineElementRoot.getElementIndex(caretOffset);
                this.caretRelativeOffset = caretOffset - this.lineElementRoot.getElement(this.caretLineIndex).getStartOffset();
            } else {
                this.caretLineIndex = -1;
                this.caretRelativeOffset = 0;
            }
        }

        void removeWhitespace() {
            if (this.removeFromModifiedLinesOnly) {
                this.regionIndex = TrailingWhitespaceRemove.this.modRegions.size();
                this.lineStartOffset = Integer.MAX_VALUE;
                while (this.fetchPreviousNonEmptyRegion()) {
                    int regionLastOffset = this.regionEndOffset - 1;
                    int lastLineIndex = this.lineIndex;
                    if (regionLastOffset + 100 < this.lineStartOffset) {
                        this.lineIndex = this.lineElementRoot.getElementIndex(this.regionEndOffset - 1);
                        this.fetchLineElement();
                    } else {
                        while (this.lineStartOffset > regionLastOffset) {
                            --this.lineIndex;
                            this.fetchLineElement();
                        }
                    }
                    if (lastLineIndex == this.lineIndex) continue;
                    TrailingWhitespaceRemove.removeWhitespaceOnLine(this.lineStartOffset, this.lineLastOffset, this.caretRelativeOffset, this.lineIndex, this.caretLineIndex, TrailingWhitespaceRemove.this.doc, TrailingWhitespaceRemove.this.docText);
                    while (this.regionStartOffset < this.lineStartOffset) {
                        --this.lineIndex;
                        this.fetchLineElement();
                        TrailingWhitespaceRemove.removeWhitespaceOnLine(this.lineStartOffset, this.lineLastOffset, this.caretRelativeOffset, this.lineIndex, this.caretLineIndex, TrailingWhitespaceRemove.this.doc, TrailingWhitespaceRemove.this.docText);
                    }
                }
            } else {
                this.lineIndex = this.lineElementRoot.getElementCount() - 1;
                while (this.lineIndex >= 0) {
                    this.fetchLineElement();
                    TrailingWhitespaceRemove.removeWhitespaceOnLine(this.lineStartOffset, this.lineLastOffset, this.caretRelativeOffset, this.lineIndex, this.caretLineIndex, TrailingWhitespaceRemove.this.doc, TrailingWhitespaceRemove.this.docText);
                    --this.lineIndex;
                }
            }
        }

        private boolean fetchPreviousNonEmptyRegion() {
            while (--this.regionIndex >= 0) {
                PositionRegion region = (PositionRegion)TrailingWhitespaceRemove.this.modRegions.get(this.regionIndex);
                this.regionStartOffset = region.getStartOffset();
                this.regionEndOffset = region.getEndOffset();
                if (this.regionStartOffset == this.regionEndOffset) continue;
                return true;
            }
            return false;
        }

        private void fetchLineElement() {
            Element lineElement = this.lineElementRoot.getElement(this.lineIndex);
            this.lineStartOffset = lineElement.getStartOffset();
            this.lineLastOffset = lineElement.getEndOffset() - 1;
        }
    }

    private final class NewModRegionsEdit
    extends AbstractUndoableEdit {
        private GapList<MutablePositionRegion> oldModRegions;
        private GapList<MutablePositionRegion> newModRegions;

        public NewModRegionsEdit() {
            this.oldModRegions = TrailingWhitespaceRemove.this.modRegions;
            this.newModRegions = TrailingWhitespaceRemove.this.emptyModRegions();
        }

        public void run() {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Abandoning old regions\n" + TrailingWhitespaceRemove.this.modRegions);
            }
            TrailingWhitespaceRemove.this.modRegions = this.newModRegions;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            TrailingWhitespaceRemove.this.modRegions = this.oldModRegions;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Restored old regions\n" + TrailingWhitespaceRemove.this.modRegions);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.run();
        }
    }
}

