/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.logdisplayer.lexer;

import de.proveo.idm.logdisplayer.lexer.LogTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class LogLexer
implements Lexer<LogTokenId> {
    public static final int EOF = -1;
    private LexerInput input;
    private TokenFactory<LogTokenId> factory;
    private LogTokenId nextId = LogTokenId.TEXT;
    private boolean isInMessageType;
    private boolean assignNext;
    private boolean isIdentified;

    public LogLexer(LexerRestartInfo<LogTokenId> info) {
        this.input = info.input();
        this.factory = info.tokenFactory();
    }

    public Token<LogTokenId> nextToken() {
        int ch = this.input.read();
        switch (ch) {
            case 10: {
                this.isIdentified = false;
            }
            case 91: {
                if (!this.isIdentified) {
                    this.isInMessageType = true;
                    this.assignNext = true;
                }
                return this.getToken(LogTokenId.TEXT);
            }
            case 93: {
                this.isInMessageType = false;
                this.nextId = LogTokenId.TEXT;
                return this.getToken(LogTokenId.TEXT);
            }
            case -1: {
                return null;
            }
        }
        if (this.assignNext && this.isInMessageType) {
            this.assignNext = false;
            switch (ch) {
                case 84: {
                    this.nextId = LogTokenId.TRACE;
                    break;
                }
                case 68: {
                    this.nextId = LogTokenId.DEBUG;
                    break;
                }
                case 87: {
                    this.nextId = LogTokenId.WARN;
                    break;
                }
                case 69: {
                    this.nextId = LogTokenId.ERROR;
                    break;
                }
                case 70: {
                    this.nextId = LogTokenId.FATAL;
                    break;
                }
                default: {
                    this.nextId = LogTokenId.TEXT;
                }
            }
        }
        return this.getToken(this.nextId);
    }

    private Token<LogTokenId> getToken(LogTokenId id) {
        return this.factory.createToken((TokenId)id);
    }

    public Object state() {
        return null;
    }

    public void release() {
    }
}

