/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.general.status;

import de.proveo.wwt.logic.ejb.general.status.Status;
import de.proveo.wwt.logic.ejb.general.status.StatusUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatusServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(StatusServlet.class);
    private Status status;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            out.println("<html>");
            out.println("<head>");
            out.println("<title>RTS Status</title>");
            out.println("</head>");
            out.println("<body>");
            out.print("<p>EJBAccess: ");
            out.print(this.isEJBAccess());
            out.println("</p>");
            out.print("<p>EJBEntityRead: ");
            out.print(this.isEjbReadTest());
            out.println("</p>");
            out.print("<p>EJBEntityWrite: ");
            out.print(this.isEjbWriteTest());
            out.println("</p>");
            out.print("<p>EventServletPing: ");
            out.print(this.isEventServletPing());
            out.println("</p>");
            out.print("<p>EventEJBPing: ");
            out.print(this.isEventEJBPing());
            out.println("</p>");
            out.println("</body>");
            out.println("</html>");
        }
        finally {
            out.close();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            this.status = StatusUtil.getHome().create();
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected boolean isEventServletPing() {
        try {
            URL url = new URL("http://localhost:8080/datain/e?p=servlet");
            return this.eventServletSuccessful(url);
        }
        catch (Exception ex) {
            log.error((Object)"runs during ejbAccessTest into", (Throwable)ex);
            return false;
        }
    }

    protected boolean eventServletSuccessful(URL url) throws Exception {
        URLConnection connection = url.openConnection();
        if (connection.getContentLength() != 1) {
            throw new Exception("unexpected content length");
        }
        InputStream is = connection.getInputStream();
        if (is.read() != 1) {
            throw new Exception("unexpected ping response");
        }
        return true;
    }

    protected boolean isEventEJBPing() {
        try {
            URL url = new URL("http://localhost:8080/datain/e?p=ejb");
            return this.eventServletSuccessful(url);
        }
        catch (Exception ex) {
            log.error((Object)"runs during ejbAccessTest into", (Throwable)ex);
            return false;
        }
    }

    protected boolean isEJBAccess() {
        try {
            this.status.ping();
            return true;
        }
        catch (Exception ex) {
            log.error((Object)"runs during ejbAccessTest into", (Throwable)ex);
            return false;
        }
    }

    protected boolean isEjbReadTest() {
        try {
            this.status.ejbReadTest();
            return true;
        }
        catch (Exception ex) {
            log.error((Object)"runs during ejbAccessTest into", (Throwable)ex);
            return false;
        }
    }

    protected boolean isEjbWriteTest() {
        try {
            this.status.ejbWriteTest();
            return true;
        }
        catch (Exception ex) {
            log.error((Object)"runs during ejbAccessTest into", (Throwable)ex);
            return false;
        }
    }
}

