/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.general.infoman;

import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacade;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateResourceServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(UpdateResourceServlet.class);
    private InfomanSetupFacade infomanSetupFacade;
    private boolean compressionEnabled;

    public String getServletInfo() {
        return "Resource Servlet for planned infoman updates";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.infomanSetupFacade = InfomanSetupFacadeUtil.getHome().create();
        }
        catch (Exception ex) {
            throw new ServletException("Cannot connect to InfomanSetupFacade", (Throwable)ex);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected Properties getPropertiesFromRequest(HttpServletRequest request) {
        Properties event = new Properties();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            event.setProperty(key, request.getParameter(key));
        }
        return event;
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object out;
        Properties properties = this.getPropertiesFromRequest(request);
        byte[] resource = null;
        try {
            resource = this.infomanSetupFacade.getUpdateResource(properties);
        }
        catch (RemoteException ex) {
            log.error((Object)"runs into", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
        if (resource == null) {
            log.trace((Object)"update cancel");
            return;
        }
        boolean compressionMakeSense = false;
        if (properties.getProperty("type", "none").equals("software")) {
            response.setContentType("application/x-tar");
        } else if (properties.getProperty("type", "none").equals("config")) {
            response.setContentType("text/plain");
            compressionMakeSense = true;
        }
        if (this.isCompressionSupported(request) && compressionMakeSense) {
            response.addHeader("Content-Encoding", "gzip");
            out = new GZIPOutputStream((OutputStream)response.getOutputStream());
        } else {
            out = response.getOutputStream();
        }
        out.write(resource);
        out.close();
    }

    protected boolean isCompressionSupported(HttpServletRequest request) {
        if (!this.isCompressionEnabled()) {
            return false;
        }
        Enumeration e = request.getHeaders("Accept-Encoding");
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!"gzip".equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }
}

