/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.rpc.infoman;

import de.proveo.wwt.logic.app.security.LoginCallbackHandler;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.exception.AccessDeniedException;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacade;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountDataWithPermissions;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleRPCHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import de.proveo.wwt.logic.servlet.general.login.LoginResponse;
import java.security.Principal;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;

public class LoginHandler
implements SimpleRPCHandler {
    protected static final String INIT_PARAM_USERADMIN_JNDI_NAME = "UserAdminJNDI";
    protected static final String PARAM_USERNAME = "username";
    protected static final String PARAM_PASSWORD = "password";
    private UserAdminFacade userAdminFacade;

    public Object execute(SimpleXMLRPCCall call) throws Exception {
        String username = (String)call.getParameter(PARAM_USERNAME);
        char[] password = (char[])call.getParameter(PARAM_PASSWORD);
        if (username == null || username.length() == 0) {
            throw new ServletException("parameter 'username' missing or empty");
        }
        if (password == null || password.length == 0) {
            throw new ServletException("parameter 'password' missing or empty");
        }
        LoginResponse loginResponse = new LoginResponse(false);
        LoginCallbackHandler cbh = new LoginCallbackHandler(username, new String(password));
        try {
            LoginContext lc = new LoginContext("rts", (CallbackHandler)cbh);
            lc.login();
            loginResponse = new LoginResponse(true);
            Set<Principal> principals = lc.getSubject().getPrincipals();
            TreeSet<String> permissions = new TreeSet<String>();
            for (Principal principal : principals) {
                permissions.add(((Object)principal).toString());
            }
            loginResponse.setPortalPermissions(permissions);
        }
        catch (LoginException e1) {
            loginResponse = new LoginResponse(false);
            if (this.userAdminFacade == null) {
                throw new ServletException("ejb remote interface missing. init problem");
            }
            try {
                AccountDataWithPermissions accountData = this.userAdminFacade.checkUser(username, password);
                loginResponse = new LoginResponse(true);
            }
            catch (AccessDeniedException ex) {
                loginResponse = new LoginResponse(false);
            }
        }
        for (int i = 0; i < password.length; ++i) {
            password[i] = '\u0000';
        }
        password = null;
        return loginResponse;
    }

    public String getMethodName() {
        return "Login";
    }

    public void init() throws Exception {
        this.userAdminFacade = UserAdminFacadeUtil.getHome().create();
    }
}

