/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.rpc.airportmap;

import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleRPCHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import de.proveo.wwt.logic.web.common.dto.UnitDTOListBase;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacade;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeUtil;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeDTO;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GetAPVisibleUnitTreeHandler
implements SimpleRPCHandler {
    public static final String PARAM_IS_SUPERADMIN = "isSuperadmin";
    private UnitTreeFacade unitTreeFacade;
    private Map unitTreeMap;
    private boolean isSuperadmin = false;

    public Object execute(SimpleXMLRPCCall call) throws Exception {
        Object isSuperAdminObj = call.getParameter(PARAM_IS_SUPERADMIN);
        if (isSuperAdminObj != null) {
            this.isSuperadmin = Boolean.valueOf(isSuperAdminObj.toString());
        }
        this.unitTreeMap = new HashMap();
        UnitTreeDTO unitTree = this.unitTreeFacade.getAirportMapTreeModel();
        UnitTreeNode rootUnitNode = unitTree.getRoot();
        return this.builUnitTreeMap(rootUnitNode);
    }

    public String getMethodName() {
        return "GetAPVisibleUnitTree";
    }

    public void init() throws Exception {
        this.unitTreeFacade = UnitTreeFacadeUtil.getHome().create();
    }

    private Map builUnitTreeMap(UnitTreeNode unitNode) {
        HashMap treeNodeMap = new HashMap();
        UnitModelValue unitModelValue = unitNode.getUnitModelValue();
        UnitIdentityValue unitIdentityValue = unitNode.getUnitIdentityValue();
        String name = unitIdentityValue.getName();
        long unitId = unitModelValue.getUnitId();
        if (!unitModelValue.getBasic()) {
            UnitDTOListBase children = unitNode.getChildNodes();
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put("name", name);
            value.put("imageName", "");
            value.put("allowsChildren", true);
            if (children != null) {
                ArrayList<Map> childsList = new ArrayList<Map>();
                for (UnitTreeNode childUnitNode : children) {
                    Map childTreeNode = this.builUnitTreeMap(childUnitNode);
                    childsList.add(childTreeNode);
                }
                value.put("children", childsList);
            }
            treeNodeMap = new HashMap();
            treeNodeMap.put(unitId, value);
        } else {
            HashMap<String, Object> value = new HashMap<String, Object>();
            if (this.isSuperadmin) {
                value.put("name", name + " (" + unitId + ")");
            } else {
                value.put("name", name);
            }
            value.put("imageName", unitIdentityValue.getImageName());
            value.put("allowsChildren", false);
            treeNodeMap = new HashMap();
            treeNodeMap.put(unitId, value);
        }
        return treeNodeMap;
    }
}

