/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.rpc;

import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class SimpleXMLRPCClient {
    private HttpClient httpClient = new HttpClient();
    private String uri;
    private boolean requestCompression;
    private boolean acceptCompression;

    public SimpleXMLRPCClient() {
    }

    public SimpleXMLRPCClient(String uri) {
        this.setURI(uri);
    }

    public Object execute(SimpleXMLRPCCall call) throws Exception {
        int statusCode;
        PostMethod method = new PostMethod(this.getURI());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLEncoder encoder = new XMLEncoder(out);
        encoder.writeObject(call);
        encoder.close();
        if (this.isRequestCompression()) {
            method.setRequestHeader(new Header("Content-Encoding", "gzip"));
            ByteArrayOutputStream gzipOut = new ByteArrayOutputStream();
            GZIPOutputStream gz = new GZIPOutputStream(gzipOut);
            gz.write(out.toByteArray());
            gz.finish();
            gz.close();
            out = gzipOut;
        }
        method.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(out.toByteArray()));
        if (this.isAcceptCompression()) {
            method.setRequestHeader(new Header("Accept-Encoding", "gzip"));
        }
        if ((statusCode = this.httpClient.executeMethod((HttpMethod)method)) != 200) {
            throw new IOException("unexpected return code: " + statusCode);
        }
        Header gzResponseHeader = method.getResponseHeader("Content-Encoding");
        InputStream response = gzResponseHeader != null && gzResponseHeader.getValue() != null && gzResponseHeader.getValue().equals("gzip") ? new GZIPInputStream(method.getResponseBodyAsStream()) : method.getResponseBodyAsStream();
        XMLDecoder decoder = new XMLDecoder(response);
        Object result = decoder.readObject();
        decoder.close();
        if (result instanceof Exception) {
            throw (Exception)result;
        }
        return result;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getURI() {
        return this.uri;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public boolean isRequestCompression() {
        return this.requestCompression;
    }

    public void setRequestCompression(boolean requestCompression) {
        this.requestCompression = requestCompression;
    }

    public boolean isAcceptCompression() {
        return this.acceptCompression;
    }

    public void setAcceptCompression(boolean acceptCompression) {
        this.acceptCompression = acceptCompression;
    }
}

