/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.units.threads;

import de.proveo.util.observable.interfaces.AllDataListener;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import java.rmi.RemoteException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AllDataThread
extends Thread {
    private static final Log log = LogFactory.getLog(AllDataThread.class);
    private AllDataListener allDataListener = null;
    private ConfigurationClient configurationClient;
    private InformantClient informantClient = null;
    private boolean isRunning = true;
    private int timeToSendAllData = 1800000;

    public AllDataThread() {
        log.debug((Object)"AllDataThread started!");
        this.informantClient = new InformantClient();
        try {
            this.configurationClient = new ConfigurationClient();
            this.timeToSendAllData = Integer.parseInt(this.configurationClient.getParameter("observable.alldatathread.latency"));
        }
        catch (RemoteException e) {
            log.error((Object)("AllDataThread() runs into RemoteException: " + e));
            this.informantClient.notify("AllDataThread() runs into RemoteException: " + e, "UnitErrorEvent");
        }
        catch (NumberFormatException e) {
            log.error((Object)("AllDataThread() runs into NumberFormatException: " + e));
            this.informantClient.notify("AllDataThread() runs into NumberFormatException: " + e, "UnitErrorEvent");
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)("AllDataThread() runs into ConfigurationParameterNotFoundException: " + (Object)((Object)e)));
            this.informantClient.notify("AllDataThread() runs into CreateConfigurationParameterNotFoundExceptionException: " + (Object)((Object)e), "UnitErrorEvent");
        }
    }

    public void removeListener() {
        this.allDataListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning) {
            try {
                AllDataThread allDataThread = this;
                synchronized (allDataThread) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("AllDataThread sleeping for " + this.timeToSendAllData / 60000 + " minutes" + this.toString()));
                    }
                    AllDataThread.sleep(this.timeToSendAllData);
                }
                if (this.isRunning) {
                    log.debug((Object)"run() - Starting send AllStamps to the client!");
                    this.allDataListener.sendAllStampsToClient();
                    log.debug((Object)("run() - Thread sends AllStamps to the client!" + this.toString()));
                    continue;
                }
                log.debug((Object)"Thread closed. leaving run-Method()");
            }
            catch (InterruptedException e) {
                log.warn((Object)("AllDataThread --> sleep interrupted  | Keep on running: " + this.isRunning));
            }
            catch (JMSException e) {
                log.error((Object)"run() runs into JMSException: ", (Throwable)e);
                this.informantClient.notify("run() runs into JMSException: " + (Object)((Object)e), "UnitErrorEvent");
            }
            catch (Exception e) {
                log.error((Object)"run() runs into Exception: ", (Throwable)e);
            }
        }
        log.debug((Object)"Leaving AllDataThread run()-method. Thread closed");
    }

    public void setListener(AllDataListener allDataListener) {
        this.allDataListener = allDataListener;
    }

    public void stopRunning() {
        log.debug((Object)("Set StopRunning: " + this.toString()));
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

