/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.stands.util;

import de.proveo.util.observable.stands.StandsDataFactory;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.servlet.dataIn.stands.connector.AbstractStandsConnector;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateGenerator {
    private static final Log log = LogFactory.getLog(StateGenerator.class);
    private AbstractStandsConnector connector = null;
    private InformantClient informantClient = null;
    private Map timeTasks = null;
    private Timer timer = null;

    public StateGenerator(AbstractStandsConnector connector) {
        this.connector = connector;
        this.timer = new Timer();
        this.timeTasks = new HashMap();
        this.informantClient = new InformantClient();
    }

    public void addNewEvent(StandsDataFactory flightsData) {
        Iterator standEvents = flightsData.getAllFlightEvents();
        while (standEvents.hasNext()) {
            Map flightEvent;
            Map eventPart = (Map)standEvents.next();
            String standKey = (String)eventPart.get("oid");
            if (standKey == null) {
                standKey = "";
            }
            if ((flightEvent = AbstractStandsConnector._standsDataFactory.getSpecificFlightEvent(standKey)) == null) continue;
            this.deleteTimerTasksForFlightEvent((String)flightEvent.get("oid"));
            this.addTimerTask(flightEvent);
        }
    }

    public void generateEventsForAllData() {
        try {
            this.timer.cancel();
            this.timer.purge();
            this.timer = new Timer();
        }
        catch (Exception e) {
            log.debug((Object)"Timer already canceled and purged!");
        }
        Iterator flightEvents = AbstractStandsConnector._standsDataFactory.getAllFlightEvents();
        while (flightEvents.hasNext()) {
            Map flightEvent = (Map)flightEvents.next();
            this.addTimerTask(flightEvent);
        }
    }

    protected void deleteTimerTasksForFlightEvent(String flightID) {
        Object startTask = this.timeTasks.get(flightID + "S");
        Object endTask = this.timeTasks.get(flightID + "E");
        if (startTask != null) {
            ((TimerTask)startTask).cancel();
        }
        if (endTask != null) {
            ((TimerTask)endTask).cancel();
        }
    }

    private void addTimerTask(final Map flightEvent) {
        try {
            if ((Long)flightEvent.get("et") > new Date().getTime()) {
                TimerTask timerTask;
                if ((Long)flightEvent.get("st") > new Date().getTime()) {
                    timerTask = new TimerTask(){

                        public void run() {
                            log.debug((Object)"Executing timer task (updateStandWithTakenStatus)...");
                            StateGenerator.this.connector.updateStandWithTakenStatus(flightEvent);
                        }
                    };
                    this.timeTasks.put((String)flightEvent.get("oid") + "S", timerTask);
                    this.timer.schedule(timerTask, (Long)flightEvent.get("st") - new Date().getTime());
                }
                timerTask = new TimerTask(){

                    public void run() {
                        log.debug((Object)"Executing timer task (updateStandWithEmptyStatus)...");
                        StateGenerator.this.connector.updateStandWithEmptyStatus(flightEvent);
                    }
                };
                this.timeTasks.put((String)flightEvent.get("oid") + "E", timerTask);
                this.timer.schedule(timerTask, (Long)flightEvent.get("et") - new Date().getTime());
            }
        }
        catch (ClassCastException e) {
            log.error((Object)"addTimerTask() runs into ClassCastException: ", (Throwable)e);
            this.informantClient.notify("addTimerTask() runs into ClassCastException: " + e, "StandErrorEvent");
        }
    }
}

