/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.stands.connector;

import de.proveo.util.observable.stands.StandsDataFactory;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.FisFlightFacade;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.FisFlightFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.FisGSEFacade;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.FisGSEFacadeHome;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.cache.FisGseCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.fisStaff.FisStaffFacade;
import de.proveo.wwt.logic.ejb.dataIn.fisStaff.FisStaffFacadeHome;
import de.proveo.wwt.logic.ejb.dataIn.fisStaff.cache.FisStaffCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.stands.parser.GSEAndStaffConverterFacade;
import de.proveo.wwt.logic.ejb.dataIn.stands.parser.GSEAndStaffConverterFacadeHome;
import de.proveo.wwt.logic.servlet.dataIn.stands.connector.AbstractStandsConnector;
import java.io.IOException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeneralFISConnector
extends AbstractStandsConnector
implements MessageListener {
    private static final Log log = LogFactory.getLog(GeneralFISConnector.class);
    private TopicConnectionFactory connectionFactory = null;
    private TopicConnection connect = null;
    private TopicSession session = null;
    private FisFlightFacade fisFlightFacade = null;
    private FisGSEFacade fisGseFacade;
    private FisStaffFacade fisStaffFacade;
    private GSEAndStaffConverterFacade gseAndStaffConverterFacade;

    public GeneralFISConnector() {
        try {
            this.init();
        }
        catch (JMSException e) {
            log.error((Object)"GeneralFISConnector runs into JMSException: ", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"GeneralFISConnector runs into NamingException: ", (Throwable)e);
        }
        catch (RemoteException e) {
            log.error((Object)"GeneralFISConnector runs into RemoteException: ", (Throwable)e);
        }
        catch (CreateException e) {
            log.error((Object)"GeneralFISConnector runs into CreateException: ", (Throwable)e);
        }
    }

    protected StandsDataFactory readAllNewFlightData() {
        log.debug((Object)"readAllNewFlightData() started...");
        StandsDataFactory standsDataFactory = new StandsDataFactory();
        try {
            Collection flightColl = this.fisFlightFacade.getAllCacheFlights();
            log.debug((Object)"flightColl created!");
            for (FisFlightCacheValue flightValue : flightColl) {
                this.convertFISFlightValueObjectToStandsData(standsDataFactory, flightValue);
            }
            Collection gseColl = this.fisGseFacade.getAllCacheGseAssignments();
            log.debug((Object)"gseColl created!");
            for (FisGseCacheValue gseValue : gseColl) {
                this.convertFISGseValueObjectToStandsData(standsDataFactory, gseValue);
            }
            Collection staffColl = this.fisStaffFacade.getAllCacheStaffAssignments();
            log.debug((Object)"staffColl created!");
            for (FisStaffCacheValue staffValue : staffColl) {
                this.convertFISStaffValueObjectToStandsData(standsDataFactory, staffValue);
            }
        }
        catch (RemoteException e) {
            log.error((Object)"readAllNewFlightData runs into RemoteException: ", (Throwable)e);
        }
        catch (FinderException e) {
            log.error((Object)"readAllNewFlightData runs into FinderException: ", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"readAllNewFlightData runs into Exception: ", (Throwable)e);
        }
        log.debug((Object)"readAllNewFlightData() finished!");
        return standsDataFactory;
    }

    private void convertFISFlightValueObjectToStandsData(StandsDataFactory standsDataFactory, FisFlightCacheValue cacheValue) {
        HashMap<String, Object> flightValues = new HashMap<String, Object>();
        if (cacheValue.getUniqueFlightNumber() != null) {
            if (cacheValue.getArrivalDeparture().equals("A")) {
                flightValues.put("afid", cacheValue.getFlightNumberSemantics());
                flightValues.put("arrivalUAFT", cacheValue.getUniqueFlightNumber());
            } else if (cacheValue.getArrivalDeparture().equals("D")) {
                flightValues.put("dfid", cacheValue.getFlightNumberSemantics());
                flightValues.put("departureUAFT", cacheValue.getUniqueFlightNumber());
                flightValues.put("departureRKEY", cacheValue.getRotationKey());
            }
        }
        if ("A".equals(cacheValue.getArrivalDeparture())) {
            if (cacheValue.getOnBlockTime() != 0L) {
                flightValues.put("st", cacheValue.getOnBlockTime());
            } else if (cacheValue.getEstimatedTimeOfArrival() != 0L) {
                flightValues.put("st", cacheValue.getEstimatedTimeOfArrival());
            } else if (cacheValue.getScheduledTimeOfArrival() != 0L) {
                flightValues.put("st", cacheValue.getScheduledTimeOfArrival());
            }
        }
        if ("D".equals(cacheValue.getArrivalDeparture())) {
            if (cacheValue.getOffBlockTime() != 0L) {
                flightValues.put("et", cacheValue.getOffBlockTime());
            } else if (cacheValue.getEstimatedTimeOfDeparture() != 0L) {
                flightValues.put("et", cacheValue.getEstimatedTimeOfDeparture());
            } else if (cacheValue.getScheduledTimeOfDeparture() != 0L) {
                flightValues.put("et", cacheValue.getScheduledTimeOfDeparture());
            }
        }
        if (cacheValue.getParkingStand() != null) {
            if (cacheValue.getParkingStand().trim().length() != 0) {
                flightValues.put("fstd", "Stand_" + cacheValue.getParkingStand());
            } else {
                flightValues.put("fstd", "");
            }
        }
        if ("A".equals(cacheValue.getArrivalDeparture())) {
            flightValues.put("sta", cacheValue.getScheduledTimeOfArrival());
        }
        if ("A".equals(cacheValue.getArrivalDeparture())) {
            flightValues.put("eta", cacheValue.getEstimatedTimeOfArrival());
        }
        if ("A".equals(cacheValue.getArrivalDeparture())) {
            flightValues.put("onbl", cacheValue.getOnBlockTime());
        }
        if ("D".equals(cacheValue.getArrivalDeparture())) {
            flightValues.put("std", cacheValue.getScheduledTimeOfDeparture());
        }
        if ("D".equals(cacheValue.getArrivalDeparture())) {
            flightValues.put("etd", cacheValue.getEstimatedTimeOfDeparture());
        }
        if ("D".equals(cacheValue.getArrivalDeparture())) {
            flightValues.put("ofbl", cacheValue.getOffBlockTime());
        }
        if (cacheValue.getAircraftType5LetterCode() != null) {
            flightValues.put("AircraftType", cacheValue.getAircraftType5LetterCode());
        }
        if (cacheValue.getFlightNature() != null) {
            flightValues.put("category", cacheValue.getFlightNature());
        }
        if (cacheValue.getOrigin3LetterCode() != null && cacheValue.getArrivalDeparture().equals("A")) {
            flightValues.put("origin", cacheValue.getOrigin3LetterCode());
        }
        if (cacheValue.getDestination3LetterCode() != null && cacheValue.getArrivalDeparture().equals("D")) {
            flightValues.put("destination", cacheValue.getDestination3LetterCode());
        }
        if (cacheValue.getFlightStatus() != null && cacheValue.getArrivalDeparture().equals("A")) {
            flightValues.put("FlightTypeArrival", cacheValue.getFlightStatus());
        }
        if (cacheValue.getFlightStatus() != null && cacheValue.getArrivalDeparture().equals("D")) {
            flightValues.put("FlightTypeDeparture", cacheValue.getFlightStatus());
        }
        if (cacheValue.getArrivalDeparture() != null) {
            flightValues.put("adflag", cacheValue.getArrivalDeparture());
        }
        if (cacheValue.getRegistration() != null) {
            flightValues.put("reg", cacheValue.getRegistration());
        }
        flightValues.put("FlightEventType", "FlightUpdate");
        standsDataFactory.addADFlight(cacheValue.getUniqueFlightNumber(), flightValues);
    }

    private Map convertFISGseValueObjectToStandsData(StandsDataFactory standsDataFactory, FisGseCacheValue cacheValue) {
        Map gseAllocationMap = new HashMap();
        try {
            gseAllocationMap = this.gseAndStaffConverterFacade.convertFISGSEValueObjectToStandsData(cacheValue);
            standsDataFactory.addGSEAllocationEvent(cacheValue.getUniqueFlightNumber(), gseAllocationMap);
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return gseAllocationMap;
    }

    private Map convertFISStaffValueObjectToStandsData(StandsDataFactory standsDataFactory, FisStaffCacheValue cacheValue) {
        Map staffAllocationMap = new HashMap();
        try {
            staffAllocationMap = this.gseAndStaffConverterFacade.convertFISStaffValueObjectToValueMap(cacheValue);
            standsDataFactory.addStaffAllocationEvent(cacheValue.getUniqueFlightNumber(), staffAllocationMap);
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return staffAllocationMap;
    }

    public void run() {
        super.initializeObjects();
        this.updateAllDataThread.startUpdateAllDataProcess();
    }

    private void init() throws JMSException, NamingException, RemoteException, CreateException {
        log.debug((Object)"init() started...");
        this.fisFlightFacade = FisFlightFacadeUtil.getHome().create();
        InitialContext initialContext = new InitialContext();
        Object ejbHome = initialContext.lookup("FisGSEFacade");
        FisGSEFacadeHome fisGseFacadeHome = (FisGSEFacadeHome)PortableRemoteObject.narrow((Object)ejbHome, FisGSEFacadeHome.class);
        this.fisGseFacade = fisGseFacadeHome.create();
        ejbHome = initialContext.lookup("FisStaffFacade");
        FisStaffFacadeHome fisStaffFacadeHome = (FisStaffFacadeHome)PortableRemoteObject.narrow((Object)ejbHome, FisStaffFacadeHome.class);
        this.fisStaffFacade = fisStaffFacadeHome.create();
        ejbHome = initialContext.lookup("GSEAndStaffConverterFacade");
        GSEAndStaffConverterFacadeHome gseAndStaffConverterFacadeHome = (GSEAndStaffConverterFacadeHome)PortableRemoteObject.narrow((Object)ejbHome, GSEAndStaffConverterFacadeHome.class);
        this.gseAndStaffConverterFacade = gseAndStaffConverterFacadeHome.create();
        this.initJMS();
        log.debug((Object)"init() finished!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initJMS() {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            this.connectionFactory = (TopicConnectionFactory)ctx.lookup("ConnectionFactory");
            this.connect = this.connectionFactory.createTopicConnection();
            try {
                Topic topic;
                this.connect.setExceptionListener((ExceptionListener)new ExceptionListenerImpl());
                this.session = this.connect.createTopicSession(false, 2);
                try {
                    topic = (Topic)ctx.lookup("topic/proveoDataProviderTopic");
                }
                catch (NameNotFoundException ex) {
                    log.debug((Object)"topic not found, create new");
                    topic = this.session.createTopic("topic/proveoDataProviderTopic");
                    ctx.bind("topic/proveoDataProviderTopic", (Object)topic);
                }
                String selector = this.getSelectorString("FlightEvent") + " OR " + this.getSelectorString("GSEAllocationEvent") + " OR " + this.getSelectorString("StaffAllocationEvent");
                TopicSubscriber subscriber = this.session.createSubscriber(topic, selector, true);
                subscriber.setMessageListener((MessageListener)this);
                this.connect.start();
                return true;
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                try {
                    this.connect.close();
                }
                catch (JMSException jMSException) {
                }
                finally {
                    ctx.close();
                }
            }
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return false;
    }

    private String getSelectorString(String selectionItem) {
        return "TypeOfInterest='" + selectionItem + "'";
    }

    protected void sendTestDataToJMS() throws UnknownHostException, IOException {
        log.info((Object)"sendTestDataToJMS() currently not implemented and needed for GeneralFISConnector");
    }

    public void onMessage(Message message) {
        try {
            SerializableEventWrapper wrapper = (SerializableEventWrapper)((ObjectMessage)message).getObject();
            log.debug((Object)"Message received!");
            if (wrapper.get_typeOfEvent().equals("FlightDelete")) {
                String uaft = (String)wrapper.get_cacheValue();
                super.deleteFlightEvent(uaft);
            } else if (wrapper.get_typeOfEvent().equals("FlightUpdate")) {
                FisFlightCacheValue fisFlightCacheValue = (FisFlightCacheValue)wrapper.get_cacheValue();
                StandsDataFactory standsDataFactory = new StandsDataFactory();
                this.convertFISFlightValueObjectToStandsData(standsDataFactory, fisFlightCacheValue);
                super.proceedWithSingleFlightEvents(standsDataFactory);
            } else if (wrapper.get_typeOfEvent().equals("GSEAllocationEventDelete")) {
                Object tmp;
                FisGseCacheValue fisGSECacheValue = (FisGseCacheValue)wrapper.get_cacheValue();
                String flightNumber = fisGSECacheValue.getUniqueFlightNumber();
                String gseId = fisGSECacheValue.getCustomerGseCode();
                Map flightEvent = (Map)AbstractStandsConnector._standsDataFactory.getAllADFlights().get(flightNumber);
                String standId = null;
                if (flightEvent != null && (tmp = flightEvent.get("fstd")) != null) {
                    standId = (String)tmp;
                }
                HashMap<String, String> flightTmp = new HashMap<String, String>();
                flightTmp.put("oid", flightNumber);
                flightTmp.put("GSEAllocationGSEID", gseId);
                flightTmp.put("GSEAllocationEventType", "GSEAllocationEventDelete");
                flightTmp.put("fstd", standId);
                AbstractStandsConnector._standsDataFactory.deleteGSEAllocationEvent(flightNumber, gseId);
                super.sendGSEEventToJMS(flightTmp);
            } else if (wrapper.get_typeOfEvent().equals("GSEAllocationEventUpdate")) {
                Object tmp;
                FisGseCacheValue fisGSECacheValue = (FisGseCacheValue)wrapper.get_cacheValue();
                String flightNumber = fisGSECacheValue.getUniqueFlightNumber();
                Map flightEvent = (Map)AbstractStandsConnector._standsDataFactory.getAllADFlights().get(flightNumber);
                String standId = null;
                if (flightEvent != null && (tmp = flightEvent.get("fstd")) != null) {
                    standId = (String)tmp;
                }
                Map flightTmp = this.convertFISGseValueObjectToStandsData(AbstractStandsConnector._standsDataFactory, fisGSECacheValue);
                flightTmp.put("oid", flightNumber);
                flightTmp.put("GSEAllocationEventType", "GSEAllocationEventUpdate");
                flightTmp.put("fstd", standId);
                super.sendGSEEventToJMS(flightTmp);
            } else if (wrapper.get_typeOfEvent().equals("StaffAllocationEventDelete")) {
                Object tmp;
                FisStaffCacheValue fisStaffCacheValue = (FisStaffCacheValue)wrapper.get_cacheValue();
                String flightNumber = fisStaffCacheValue.getUniqueFlightNumber();
                String personalNumber = fisStaffCacheValue.getPersonalNumber();
                Map flightEvent = (Map)AbstractStandsConnector._standsDataFactory.getAllADFlights().get(flightNumber);
                String standId = null;
                if (flightEvent != null && (tmp = flightEvent.get("fstd")) != null) {
                    standId = (String)tmp;
                }
                HashMap<String, String> flightTmp = new HashMap<String, String>();
                flightTmp.put("oid", flightNumber);
                flightTmp.put("StaffAllocationPersonalNumber", personalNumber);
                flightTmp.put("StaffAllocationEventType", "StaffAllocationEventDelete");
                flightTmp.put("fstd", standId);
                AbstractStandsConnector._standsDataFactory.deleteStaffAllocationEvent(flightNumber, personalNumber);
                super.sendStaffEventToJMS(flightTmp);
            } else if (wrapper.get_typeOfEvent().equals("StaffAllocationEventUpdate")) {
                Object tmp;
                FisStaffCacheValue fisStaffCacheValue = (FisStaffCacheValue)wrapper.get_cacheValue();
                String flightNumber = fisStaffCacheValue.getUniqueFlightNumber();
                Map flightEvent = (Map)AbstractStandsConnector._standsDataFactory.getAllADFlights().get(flightNumber);
                String standId = null;
                if (flightEvent != null && (tmp = flightEvent.get("fstd")) != null) {
                    standId = (String)tmp;
                }
                Map flightTmp = this.convertFISStaffValueObjectToStandsData(AbstractStandsConnector._standsDataFactory, fisStaffCacheValue);
                flightTmp.put("oid", flightNumber);
                flightTmp.put("StaffAllocationEventType", "StaffAllocationEventUpdate");
                flightTmp.put("fstd", standId);
                super.sendStaffEventToJMS(flightTmp);
            } else {
                log.error((Object)("Flight event is neither an update event nor a delete event, it is a " + wrapper.get_typeOfEvent()));
            }
            message.acknowledge();
            log.debug((Object)"Message acknowleged and process finished!");
        }
        catch (JMSException e) {
            log.error((Object)"onMessage runs into JMSException: ", (Throwable)e);
        }
    }

    private class ExceptionListenerImpl
    implements ExceptionListener {
        public static final int NUM_RETRIES = 3;

        private ExceptionListenerImpl() {
        }

        public void onException(JMSException e) {
            for (int i = 0; i < 3; ++i) {
                log.warn((Object)("Connection has problems, trying to re-create it, attempt " + (i + 1) + " ..."));
                try {
                    GeneralFISConnector.this.connect.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                boolean setupOK = GeneralFISConnector.this.initJMS();
                if (setupOK) {
                    log.info((Object)"Connection re-established");
                    return;
                }
                log.warn((Object)"Re-creating connection failed, retrying ...");
            }
            log.error((Object)"Cannot re-establish connection, giving up ...");
        }
    }
}

