/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.stands.connector;

import de.proveo.util.observable.stands.StandsDataFactory;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacade;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeUtil;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.servlet.dataIn.stands.threads.UpdateAllDataThread;
import de.proveo.wwt.logic.servlet.dataIn.stands.util.DebugClass;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractStandsConnector
extends Thread {
    private static final Log log = LogFactory.getLog(AbstractStandsConnector.class);
    public static StandsDataFactory _standsDataFactory = null;
    protected InformantClient informantClient = null;
    private InformantFacade informantFacade = null;
    protected UpdateAllDataThread updateAllDataThread = null;
    private ConfigurationClient configurationClient = null;
    private boolean _firstRun = true;

    public AbstractStandsConnector() {
        log.debug((Object)"JMSConnectorFacadeBean()");
        this.informantClient = new InformantClient();
        this.configurationClient = new ConfigurationClient();
        this.updateAllDataThread = new UpdateAllDataThread(this);
        this.updateAllDataThread.start();
    }

    public abstract void run();

    public void updateData(boolean fullData) throws UnknownHostException, IOException {
        StandsDataFactory newIncomingData;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating data with parameter: " + fullData));
        }
        if ((newIncomingData = this.readAllNewFlightData()) != null) {
            if (fullData) {
                log.debug((Object)"Updating all data...");
                _standsDataFactory = newIncomingData;
                log.debug((Object)"updateData(): Data updated and will be sent to jms topic!");
                this.sendAllDataToJMS(_standsDataFactory);
                log.debug((Object)"All data updated!");
            } else {
                log.debug((Object)"Starting update procedure of all data...");
                this.checkForDifferences(newIncomingData);
                log.debug((Object)"All flight event updated!");
            }
        }
    }

    public void updateStandWithEmptyStatus(Map flightEvent) {
        String standId = "";
        Object tmp = flightEvent.get("fstd");
        if (tmp != null) {
            standId = tmp.toString().trim();
        }
        if (standId.equals("")) {
            log.debug((Object)("Flight event (" + flightEvent.get("oid") + ") has no stand ID, will not send it to the client!"));
            return;
        }
        _standsDataFactory.updateState(standId, "StandAllocationStatus", "Empty");
        flightEvent.put("StandAllocationStatus", "Empty");
        this.sendFlightEventToJMS(flightEvent);
        log.debug((Object)"Flight event with EMPTY status was sent to JMS");
    }

    public void updateStandWithTakenStatus(Map flightEvent) {
        String standId = "";
        Object tmp = flightEvent.get("fstd");
        if (tmp != null) {
            standId = tmp.toString().trim();
        }
        if (standId.equals("")) {
            log.debug((Object)("Flight event (" + flightEvent.get("oid") + ") has no stand ID, will not send it to the client!"));
            return;
        }
        _standsDataFactory.updateState(standId, "StandAllocationStatus", "Taken");
        flightEvent.put("StandAllocationStatus", "Taken");
        this.sendFlightEventToJMS(flightEvent);
        log.debug((Object)"Flight event with TAKEN status was sent to JMS");
    }

    public void updateStandWithTMOStatus(Map flightEvent) {
        String standId = "";
        Object tmp = flightEvent.get("fstd");
        if (tmp != null) {
            standId = tmp.toString().trim();
        }
        if (standId.equals("")) {
            log.debug((Object)("Flight event (" + flightEvent.get("oid") + ") has no stand ID, will not send it to the client!"));
            return;
        }
        _standsDataFactory.updateState(standId, "StandAllocationStatus", "TMO");
        flightEvent.put("StandAllocationStatus", "TMO");
        this.sendFlightEventToJMS(flightEvent);
        log.debug((Object)"Flight event with TMO status was sent to JMS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeObjects() {
        log.debug((Object)"Initializing all objects...");
        try {
            this.informantFacade = InformantFacadeUtil.getHome().create();
            AbstractStandsConnector abstractStandsConnector = this;
            synchronized (abstractStandsConnector) {
                int waitTime = 10000;
                try {
                    waitTime = this.configurationClient.getInteger("observable.stands.initialAllDataWaitTime");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("all FIS data update stopped for " + waitTime));
                    }
                }
                catch (ConfigurationParameterNotFoundException e) {
                    log.error((Object)"initializeObjects runs into ConfigurationParameterNotFoundException: ", (Throwable)e);
                }
                try {
                    this.wait(waitTime);
                }
                catch (InterruptedException e) {
                    log.error((Object)"initializeObjects runs into InterruptedException: ", (Throwable)e);
                }
            }
            this.updateData(true);
        }
        catch (CreateException e) {
            log.error((Object)"ejbCreate() runs into CreateException: ", (Throwable)e);
            this.informantClient.notify("ejbCreate() runs into CreateException: " + (Object)((Object)e), "StandErrorEvent");
        }
        catch (NamingException e) {
            log.error((Object)"ejbCreate() runs into NamingException: ", (Throwable)e);
            this.informantClient.notify("ejbCreate() runs into NamingException: " + e, "StandErrorEvent");
        }
        catch (RemoteException e) {
            log.error((Object)"ejbCreate() runs into RemoteException: ", (Throwable)e);
            this.informantClient.notify("ejbCreate() runs into RemoteException: " + e, "StandErrorEvent");
        }
        catch (UnknownHostException e) {
            log.error((Object)"ejbCreate() runs into UnknownHostException: ", (Throwable)e);
            this.informantClient.notify("ejbCreate() runs into UnknownHostException: " + e, "StandErrorEvent");
        }
        catch (IOException e) {
            log.error((Object)"ejbCreate() runs into IOException: ", (Throwable)e);
            this.informantClient.notify("ejbCreate() runs into IOException: " + e, "StandErrorEvent");
        }
    }

    protected void deleteFlightEvent(String uaft) {
        if (_standsDataFactory.getArrivalFlightEventsMap().containsKey(uaft)) {
            Map arrivalFlight;
            _standsDataFactory.getArrivalFlightEventsMap().remove(uaft);
            if (_standsDataFactory.isFlightIncludedInConcatenatedFlightList(uaft) && (arrivalFlight = _standsDataFactory.getSpecificFlightEvent(uaft)) != null) {
                _standsDataFactory.deleteFlightEvent(uaft);
                arrivalFlight.put("adflag", "A");
                this.checkDeleteEventAndUpdatesStandStatus(uaft, arrivalFlight);
            }
        } else if (_standsDataFactory.getDepartureFlightEventsMap().containsKey(uaft)) {
            Map departureFlight = (Map)_standsDataFactory.getDepartureFlightEventsMap().get(uaft);
            String rKey = (String)departureFlight.get("departureRKEY");
            _standsDataFactory.getDepartureFlightEventsMap().remove(uaft);
            if (rKey != null && _standsDataFactory.isFlightIncludedInConcatenatedFlightList(rKey)) {
                _standsDataFactory.deleteFlightEvent(rKey);
                departureFlight.put("adflag", "D");
                this.checkDeleteEventAndUpdatesStandStatus(rKey, departureFlight);
            }
        } else {
            log.warn((Object)"Incoming delete flight event is not known and cannot be deleted!");
        }
    }

    private void deleteFlightEventFromStand(Map flightEvent) {
        if (flightEvent == null) {
            log.warn((Object)"Can not delete a null flight event");
            return;
        }
        String uaft = (String)flightEvent.get("oid");
        boolean deleted = _standsDataFactory.deleteFlightEventFromStand(flightEvent);
        if (deleted) {
            this.checkDeleteEventAndUpdatesStandStatus(uaft, flightEvent);
        } else {
            log.warn((Object)("Flight event (" + uaft + ") could not be deleted!"));
        }
    }

    private void checkDeleteEventAndUpdatesStandStatus(String uaft, Map flightEvent) {
        Map arrivalFlightEvent;
        Map currentFlight = null;
        String standId = "";
        Object tmp = flightEvent.get("fstd");
        if (tmp != null && (standId = tmp.toString()).length() != 0) {
            currentFlight = _standsDataFactory.getCurrentFlightByStand(standId);
        }
        if ("D".equals(flightEvent.get("adflag")) && (arrivalFlightEvent = (Map)_standsDataFactory.getArrivalFlightEventsMap().get(uaft)) != null) {
            arrivalFlightEvent.remove("departureUAFT");
            arrivalFlightEvent.remove("departureRKEY");
        }
        flightEvent.put("oid", uaft);
        flightEvent.put("FlightEventType", "FlightDelete");
        if (currentFlight == null) {
            this.updateStandWithEmptyStatus(flightEvent);
        } else {
            this.updateStandWithTakenStatus(flightEvent);
        }
    }

    protected void proceedWithSingleFlightEvents(StandsDataFactory standsDataFactory) {
        if (standsDataFactory.getGeneralValue("UPDATE_OBSOLETE_DATA_FLAG") != null) {
            if (!this.updateAllDataThread.isUpdate()) {
                this.updateAllDataThread.startUpdateProcess();
            }
        } else if (standsDataFactory.getGeneralValue("UPDATE_ALL_DATA_FLAG") != null) {
            this.updateAllDataThread.startUpdateAllDataProcess();
        } else {
            this.updateStandsWithEvents(standsDataFactory);
        }
    }

    protected abstract StandsDataFactory readAllNewFlightData();

    protected void sendAllDataToJMS(StandsDataFactory standsDataFactory) {
        try {
            SerializableEventWrapper eventWrapper = new SerializableEventWrapper((Serializable)standsDataFactory);
            eventWrapper.set_typeOfEvent("AllStandData");
            this.informantFacade.notify(eventWrapper, "AllStandData");
            log.debug((Object)"All data to JMS sent!");
        }
        catch (Exception e) {
            log.error((Object)("sendAllDataToJMS runs into Exception: " + e));
            this.informantClient.notify("sendAllDataToJMS() runs into Exception: " + e, "StandErrorEvent");
        }
    }

    protected void sendFlightEventToJMS(Map flightEvent) {
        DebugClass debugClass = new DebugClass();
        debugClass.generateDebugInfo(flightEvent);
        try {
            SerializableEventWrapper eventWrapper = new SerializableEventWrapper(flightEvent);
            eventWrapper.set_typeOfEvent("StandEvent");
            this.informantFacade.notify(eventWrapper, "StandEvent");
            log.debug((Object)"Event sent to JMS!");
        }
        catch (Exception e) {
            log.error((Object)("sendTransferDataToJMS runs into Exception: " + e));
            this.informantClient.notify("sendTransferDataToJMS() runs into Exception: " + e, "StandErrorEvent");
        }
    }

    protected void sendStaffEventToJMS(Map staffEvent) {
        try {
            SerializableEventWrapper eventWrapper = new SerializableEventWrapper(staffEvent);
            eventWrapper.set_typeOfEvent("StaffAllocationEvent");
            this.informantFacade.notify(eventWrapper, "AllocationEvent");
            log.debug((Object)"Staff event sent to JMS!");
        }
        catch (Exception e) {
            log.error((Object)("sendTransferDataToJMS runs into Exception: " + e));
            this.informantClient.notify("sendTransferDataToJMS() runs into Exception: " + e, "StandErrorEvent");
        }
    }

    protected void sendGSEEventToJMS(Map gseEvent) {
        try {
            SerializableEventWrapper eventWrapper = new SerializableEventWrapper(gseEvent);
            eventWrapper.set_typeOfEvent("GSEAllocationEvent");
            this.informantFacade.notify(eventWrapper, "AllocationEvent");
            log.debug((Object)"GSE event sent to JMS!");
        }
        catch (Exception e) {
            log.error((Object)("sendTransferDataToJMS runs into Exception: " + e));
            this.informantClient.notify("sendTransferDataToJMS() runs into Exception: " + e, "StandErrorEvent");
        }
    }

    protected abstract void sendTestDataToJMS() throws UnknownHostException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStandsWithEvents(StandsDataFactory standsDataFactory) {
        log.debug((Object)"Updating current flight/stands information with new flight event!");
        if (_standsDataFactory == null) {
            log.info((Object)"standsDataFactory not initialized! Waiting for first data. Retrying...");
            try {
                AbstractStandsConnector abstractStandsConnector = this;
                synchronized (abstractStandsConnector) {
                    this.wait(2000L);
                }
            }
            catch (InterruptedException e) {
                log.error((Object)"updateStandsWithEvents runs into InterruptedException: ", (Throwable)e);
            }
            this.updateStandsWithEvents(standsDataFactory);
        } else {
            Map allFlightEvents = standsDataFactory.getAllADFlights();
            for (Map newFlightEvent : allFlightEvents.values()) {
                String flightEventUAFT = (String)newFlightEvent.get("arrivalUAFT");
                if (flightEventUAFT == null) {
                    flightEventUAFT = (String)newFlightEvent.get("departureUAFT");
                }
                if (flightEventUAFT == null) {
                    log.warn((Object)"Flight UAFT is not available!");
                    continue;
                }
                Map alreadyKnownFlightEvent = (Map)_standsDataFactory.getAllADFlights().get(flightEventUAFT);
                if (alreadyKnownFlightEvent != null) {
                    log.debug((Object)"Updating stands data and sending to jms topic...");
                    Map completeFlightEvent = null;
                    if (alreadyKnownFlightEvent.get("adflag").equals("A")) {
                        String arrivalUAFT = (String)alreadyKnownFlightEvent.get("arrivalUAFT");
                        completeFlightEvent = _standsDataFactory.getSpecificFlightEvent(arrivalUAFT);
                        if (completeFlightEvent != null) {
                            completeFlightEvent.put("adflag", "A");
                        }
                    } else {
                        String newDepartureRKEY = (String)newFlightEvent.get("departureRKEY");
                        String oldDepartureRKEY = (String)alreadyKnownFlightEvent.get("departureRKEY");
                        if (newDepartureRKEY.length() != 0 && oldDepartureRKEY.length() != 0 && !newDepartureRKEY.equals(oldDepartureRKEY)) {
                            completeFlightEvent = _standsDataFactory.getSpecificFlightEvent(oldDepartureRKEY);
                            if (completeFlightEvent != null) {
                                completeFlightEvent.put("adflag", "D");
                                _standsDataFactory.deleteFlightEvent(oldDepartureRKEY);
                                this.checkDeleteEventAndUpdatesStandStatus(oldDepartureRKEY, completeFlightEvent);
                            }
                            alreadyKnownFlightEvent.put("departureRKEY", newDepartureRKEY);
                            _standsDataFactory.concateDepartureFlightEvent(flightEventUAFT, alreadyKnownFlightEvent);
                            completeFlightEvent = _standsDataFactory.getSpecificFlightEvent(newDepartureRKEY);
                        } else if (newDepartureRKEY.length() != 0) {
                            if (oldDepartureRKEY.length() == 0 && newDepartureRKEY.length() != 0) {
                                oldDepartureRKEY = newDepartureRKEY;
                                alreadyKnownFlightEvent.put("departureRKEY", newDepartureRKEY);
                                _standsDataFactory.concateDepartureFlightEvent(flightEventUAFT, alreadyKnownFlightEvent);
                            }
                            completeFlightEvent = _standsDataFactory.getSpecificFlightEvent(oldDepartureRKEY);
                        } else if (oldDepartureRKEY.length() != 0 && (completeFlightEvent = _standsDataFactory.getSpecificFlightEvent(oldDepartureRKEY)) != null) {
                            completeFlightEvent.put("adflag", "D");
                            this.checkDeleteEventAndUpdatesStandStatus(oldDepartureRKEY, completeFlightEvent);
                            completeFlightEvent = null;
                        }
                        if (completeFlightEvent != null) {
                            completeFlightEvent.put("adflag", "D");
                        }
                    }
                    HashMap flightEventCopy = null;
                    if (completeFlightEvent != null) {
                        flightEventCopy = new HashMap(completeFlightEvent);
                    }
                    alreadyKnownFlightEvent.putAll(newFlightEvent);
                    if (completeFlightEvent != null) {
                        completeFlightEvent.putAll(newFlightEvent);
                    }
                    if (completeFlightEvent != null) {
                        String oldStandID = (String)flightEventCopy.get("fstd");
                        String newStandID = (String)completeFlightEvent.get("fstd");
                        if (oldStandID != null && oldStandID.trim().length() != 0 && !oldStandID.equals(newStandID)) {
                            log.debug((Object)("delete moved (from: " + oldStandID + " -> to: " + newStandID + ") flight event with uaft " + flightEventCopy.get("oid") + " from old stand"));
                            this.deleteFlightEventFromStand(flightEventCopy);
                        }
                        _standsDataFactory.addFlightEvent((String)completeFlightEvent.get("oid"), completeFlightEvent);
                        this.addStandStateAndSendToJMS(completeFlightEvent);
                    }
                    log.debug((Object)"Updated and event sent to jms topic!");
                    continue;
                }
                log.debug((Object)"Flight is unknown and has to be added to the StandDataFactory");
                String flightPairID = _standsDataFactory.addADFlight(flightEventUAFT, newFlightEvent);
                if (flightPairID == null) continue;
                Map flightPair = _standsDataFactory.getSpecificFlightEvent(flightPairID);
                this.addStandStateAndSendToJMS(flightPair);
            }
        }
    }

    private void addStandStateAndSendToJMS(Map flightEvent) {
        String standId = "";
        Object tmp = flightEvent.get("fstd");
        if (tmp != null) {
            standId = tmp.toString();
        }
        long flightStartTime = 0L;
        long flightEndTime = 0L;
        if (flightEvent.get("st") != null) {
            flightStartTime = (Long)flightEvent.get("st");
        }
        if (flightEvent.get("et") != null) {
            flightEndTime = (Long)flightEvent.get("et");
        }
        if (flightStartTime != 0L && flightEndTime != 0L) {
            Map currentFlight = null;
            if (standId.length() != 0) {
                currentFlight = _standsDataFactory.getCurrentFlightByStand(standId);
                if (currentFlight == null) {
                    log.debug((Object)("No current flight found for stand " + standId + " while updating flight " + flightEvent.get("oid")));
                }
            } else {
                log.warn((Object)("Flight pair (" + flightEvent.get("oid") + ") doesn't contain a standID, do not update to clients!"));
            }
            if (_standsDataFactory.isFlightTMO(flightEvent)) {
                this.updateStandWithTMOStatus(flightEvent);
            } else if (currentFlight != null) {
                this.updateStandWithTakenStatus(flightEvent);
            } else {
                this.updateStandWithEmptyStatus(flightEvent);
            }
        } else {
            log.warn((Object)"Flight pair doesn't contain either start or end time!");
        }
    }

    private void checkForDifferences(StandsDataFactory standsDataFactory) {
        Iterator newFlights = standsDataFactory.getAllFlightEvents();
        while (newFlights.hasNext()) {
            Map newFlightEvent = (Map)newFlights.next();
            String newFlightEventID = (String)newFlightEvent.get("oid");
            Set newEventItemIDs = newFlightEvent.keySet();
            Map oldFlightEvent = _standsDataFactory.getSpecificFlightEvent(newFlightEventID);
            for (String newEventItem : newEventItemIDs) {
                if (oldFlightEvent.get(newEventItem) == null || newFlightEvent.get(newEventItem) == null || oldFlightEvent.get(newEventItem).equals(newFlightEvent.get(newEventItem))) continue;
                log.debug((Object)"Difference was found. Updating data, generating state event and sending information to jms topic...");
                StandsDataFactory dataFactory = new StandsDataFactory();
                dataFactory.addFlightEvent(newFlightEventID, newFlightEvent);
                this.updateStandsWithEvents(dataFactory);
            }
        }
    }
}

