/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.client;

import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.ObservableClientServlet;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.RemoteClient;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableClientFactory {
    private static ObservableClientFactory observableClientFactory = null;
    private final Log log = LogFactory.getLog(ObservableClientFactory.class);
    private InformantClient informantClient = null;
    private HashMap<String, ObservableClient> observableClientPool = null;
    private boolean sendAllStands = true;
    private boolean sendAllUnits = true;

    private ObservableClientFactory() {
        this.log.debug((Object)"Constructor ObservableClientfactory invoked.");
        this.informantClient = new InformantClient();
        this.observableClientPool = new HashMap();
    }

    public static ObservableClientFactory getInstance() {
        if (observableClientFactory == null) {
            observableClientFactory = new ObservableClientFactory();
        }
        return observableClientFactory;
    }

    public boolean createObserverClient(ObservableClientServlet parentServletThread, String clientName, String username, String password, RemoteClient remoteClient) {
        this.log.debug((Object)("ObserverClientFactory.createObserverClient(): Creating new OberserverClient... FactoryInstance: " + this.toString()));
        ObservableClient observableClient = this.observableClientPool.get(clientName);
        boolean newClient = false;
        if (observableClient != null) {
            this.log.debug((Object)("ObservableClient with name " + clientName + " alredy exists. Use existing one!"));
            return newClient;
        }
        this.log.debug((Object)("ObservableClient with name " + clientName + " unknown. Create new instance..."));
        observableClient = this.createObserverClientJMSReceiver(clientName, parentServletThread, username, password, remoteClient);
        this.observableClientPool.put(clientName, observableClient);
        newClient = true;
        if (observableClient == null) {
            throw new NullPointerException("ObserverClient is null!");
        }
        observableClient.setClient(remoteClient);
        try {
            if (this.sendAllUnits) {
                this.log.debug((Object)("Sending all Units from ObservableClient-Instance: " + observableClient.toString()));
                observableClient.observableUnitsClient.sendAllStampsToClient();
            }
            if (this.sendAllStands) {
                observableClient.observableStandsClient.sendAllStandsToClient();
            }
        }
        catch (JMSException e) {
            this.log.error((Object)"createObserverClient() runs into JMSException! ", (Throwable)e);
            this.informantClient.notify("createObserverClient() runs into JMSException! " + (Object)((Object)e), "ServerErrorEvent");
        }
        this.log.debug((Object)"ObserverClientFactory.createObserverClient(): OberserverClient created!");
        return newClient;
    }

    protected void finalize() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("finalize(): Object " + this.toString() + " deleted by garbage collector!"));
        }
    }

    private ObservableClient createObserverClientJMSReceiver(final String clientName, final ObservableClientServlet servlet, final String username, final String password, final RemoteClient remoteClient) {
        this.sendAllUnits = true;
        this.sendAllStands = true;
        this.log.debug((Object)"createObserverClientJMSReceiver() entered.");
        try {
            String selector;
            InitialContext ctx = new InitialContext();
            Topic topic = null;
            TopicSession session = null;
            TopicSubscriber subscriber = null;
            TopicConnectionFactory fact = (TopicConnectionFactory)ctx.lookup("ConnectionFactory");
            final TopicConnection connect = fact.createTopicConnection();
            connect.setExceptionListener(new ExceptionListener(){
                public static final int NUM_RETRIES = 3;

                public void onException(JMSException ex) {
                    for (int i = 0; i < 3; ++i) {
                        ObservableClientFactory.this.log.warn((Object)("Connection has problems, trying to re-create it, attempt " + (i + 1) + " ..."));
                        try {
                            connect.close();
                        }
                        catch (Exception e2) {
                            ObservableClientFactory.this.log.error((Object)"ExceptionLister is not able to close the connection!");
                        }
                        ObservableClient observableClient = ObservableClientFactory.this.createObserverClientJMSReceiver(clientName, servlet, username, password, remoteClient);
                        if (observableClient.isReconnected()) {
                            ObservableClientFactory.this.log.info((Object)"Connection re-established");
                            return;
                        }
                        ObservableClientFactory.this.log.warn((Object)"Re-creating connection failed, retrying ...");
                    }
                }
            });
            session = connect.createTopicSession(false, 2);
            try {
                topic = (Topic)ctx.lookup("topic/proveoDataProviderTopic");
            }
            catch (NameNotFoundException ex) {
                topic = session.createTopic("topic/proveoDataProviderTopic");
                ctx.bind("topic/proveoDataProviderTopic", (Object)topic);
            }
            ObservableClient observableClient = new ObservableClient(clientName, servlet, username, password);
            observableClient.selector = selector = this.getSelector(remoteClient);
            String typeOfClientInterest = remoteClient.getProperties().getProperty("TypeOfInterest", "");
            if (typeOfClientInterest.indexOf("units") == -1) {
                this.sendAllUnits = false;
            }
            if (typeOfClientInterest.indexOf("stands") == -1) {
                this.sendAllStands = false;
            }
            subscriber = session.createSubscriber(topic, selector, true);
            observableClient.getJmsClient().setSession(session);
            observableClient.getJmsClient().setConnect(connect);
            observableClient.getJmsClient().setCtx(ctx);
            observableClient.getJmsClient().setSubscriber(subscriber);
            observableClient.getJmsClient().setTopic(topic);
            subscriber.setMessageListener((MessageListener)observableClient);
            connect.start();
            this.log.debug((Object)"createObserverClient(): MessageListener set!");
            observableClient.setReconnected(true);
            return observableClient;
        }
        catch (NamingException e) {
            this.log.error((Object)("createObserverClient() ends in NamingException: " + e));
            this.informantClient.notify("createObserverClient() ends in NamingException: " + e, "ServerErrorEvent");
        }
        catch (JMSException e) {
            this.log.error((Object)("createObserverClient() ends in JMSException: " + (Object)((Object)e)));
            this.informantClient.notify("createObserverClient() ends in JMSException: " + (Object)((Object)e), "ServerErrorEvent");
        }
        return null;
    }

    private String createSelector(String selectorValues) {
        String selector = "";
        if (!selectorValues.equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(selectorValues, ",");
            boolean standsSelected = false;
            boolean unitsSelected = false;
            boolean errorSelected = false;
            while (tokenizer.hasMoreTokens()) {
                String nextToken = tokenizer.nextToken().trim();
                if (nextToken.equals("units")) {
                    if (!selector.equals("")) {
                        selector = selector + " OR ";
                    }
                    selector = selector + this.getSelectorString("KeepAlive") + " OR " + this.getSelectorString("GeoStructHistoryAndCache") + " OR " + this.getSelectorString("StateEventHistoryAndCache");
                    unitsSelected = true;
                    continue;
                }
                if (nextToken.equals("stands")) {
                    if (!selector.equals("")) {
                        selector = selector + " OR ";
                    }
                    selector = selector + this.getSelectorString("AllStandData") + " OR " + this.getSelectorString("StandEvent") + " OR " + this.getSelectorString("AllocationEvent");
                    standsSelected = true;
                    continue;
                }
                if (nextToken.equals("notify_messages")) {
                    if (!selector.equals("")) {
                        selector = selector + " OR ";
                    }
                    selector = selector + this.getSelectorString("InfomanNotifyMessages");
                    continue;
                }
                if (nextToken.equals("use_messages")) {
                    if (!selector.equals("")) {
                        selector = selector + " OR ";
                    }
                    selector = selector + this.getSelectorString("UseEvent");
                    continue;
                }
                if (nextToken.equals("infoman_messages")) {
                    if (!selector.equals("")) {
                        selector = selector + " OR ";
                    }
                    selector = selector + this.getSelectorString("InfomanMessages");
                    continue;
                }
                if (nextToken.equals("server_errors")) {
                    errorSelected = true;
                    continue;
                }
                if (!selector.equals("")) {
                    selector = selector + " OR " + this.getSelectorString(nextToken);
                    this.log.warn((Object)("Unidentified selector given: " + nextToken));
                    continue;
                }
                selector = this.getSelectorString(nextToken);
                this.log.warn((Object)("Unidentified selector given: " + nextToken));
            }
            if (standsSelected && unitsSelected && errorSelected) {
                selector = selector + " OR " + this.getSelectorString("ServerErrorEvent") + " OR " + this.getSelectorString("StandErrorEvent") + " OR " + this.getSelectorString("UnitErrorEvent");
            } else if (unitsSelected && errorSelected) {
                selector = selector + " OR " + this.getSelectorString("ServerErrorEvent") + " OR " + this.getSelectorString("UnitErrorEvent");
            } else if (standsSelected && errorSelected) {
                selector = selector + " OR " + this.getSelectorString("ServerErrorEvent") + " OR " + this.getSelectorString("StandErrorEvent");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Topic selector: " + selector));
            }
        }
        return selector;
    }

    public ObservableClient getObservableClient(String clientID) {
        return this.observableClientPool.get(clientID);
    }

    public void removeClient(String clientName) {
        ObservableClient observableClient = this.observableClientPool.get(clientName);
        if (observableClient != null) {
            this.observableClientPool.remove(observableClient.getClientName());
            this.log.debug((Object)("ObservableClient " + clientName + " removed --> " + observableClient.toString()));
        } else {
            this.log.warn((Object)("No ObservableClient registered with name " + clientName));
        }
    }

    private String getSelector(RemoteClient remoteClient) {
        return this.createSelector(remoteClient.getProperties().getProperty("TypeOfInterest", ""));
    }

    private String getSelectorString(String selectionItem) {
        return "TypeOfInterest='" + selectionItem + "'";
    }

    public HashMap<String, ObservableClient> getObservableClientPool() {
        return this.observableClientPool;
    }
}

