/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.client;

import de.proveo.util.observable.interfaces.PingThreadListener;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.ObservableClientServlet;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.JMSClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClientFactory;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableErrorClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableStandsClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableUnitsClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.RemoteClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.threads.PingThread;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TopicSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObservableClient
implements MessageListener,
PingThreadListener {
    private static final Log log = LogFactory.getLog(ObservableClient.class);
    private JMSClient jmsClient = null;
    protected LinkedList<SerializableEventWrapper> unitEventBufferLinkedList = null;
    protected LinkedList<SerializableEventWrapper> standsEventBufferLinkedList = null;
    protected PingThread pingThread = null;
    protected RemoteClient client = null;
    protected String selector = "";
    protected boolean unitsEventBufferActive = true;
    protected boolean standsEventBufferActive = true;
    ObservableErrorClient observableErrorClient = null;
    ObservableStandsClient observableStandsClient = null;
    ObservableUnitsClient observableUnitsClient = null;
    private InformantClient informantClient = null;
    private TopicSession session = null;
    private boolean isObserverClientDeleted = false;
    private boolean lostConnectionToClient = false;
    private String clientName = null;
    private boolean markedForShutdown = false;
    private long markedForShutdownTimeStamp = 0L;
    private ObservableClientServlet parentServletThread = null;
    private String username = "";
    private String password = "";
    private boolean reconnected = false;

    public ObservableClient(String clientName, ObservableClientServlet servlet, String username, String password) {
        this.clientName = clientName;
        this.parentServletThread = servlet;
        this.username = username;
        this.password = password;
        log.debug((Object)(this.toString() + " - ObserverClient constructor started..."));
        this.startPingThread();
        log.debug((Object)"PingThread started.");
        this.observableUnitsClient = new ObservableUnitsClient(this);
        log.debug((Object)"ObservableUnitClient added");
        this.observableStandsClient = new ObservableStandsClient(this);
        this.observableErrorClient = new ObservableErrorClient(this);
        this.unitEventBufferLinkedList = new LinkedList();
        this.standsEventBufferLinkedList = new LinkedList();
        this.informantClient = new InformantClient();
        this.jmsClient = new JMSClient();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public RemoteClient getClient() {
        return this.client;
    }

    public void onMessage(Message message) {
        log.debug((Object)"onMessage() started...");
        if (!this.lostConnectionToClient && !this.isMarkedForShutdown()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"onMessage(): Message acknowleded!");
                }
                Serializable _object = ((ObjectMessage)message).getObject();
                SerializableEventWrapper event = (SerializableEventWrapper)_object;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"onMessage(): Receiving ObjectMessage:");
                }
                log.debug((Object)("EVENT TYPE: " + event.get_typeOfEvent()));
                if (event.get_typeOfEvent().equals("KeepAlive") || event.get_typeOfEvent().equals("GeoStructHistoryAndCache") || event.get_typeOfEvent().equals("StateEventHistoryAndCache") || event.get_typeOfEvent().equals("InfomanMessages") || event.get_typeOfEvent().equals("InfomanNotifyMessages") || event.get_typeOfEvent().equals("UseEvent")) {
                    this.observableUnitsClient.handleMessage(event);
                } else if (event.get_typeOfEvent().equals("AllStandData") || event.get_typeOfEvent().equals("StandEvent") || event.get_typeOfEvent().equals("GSEAllocationEvent") || event.get_typeOfEvent().equals("StaffAllocationEvent")) {
                    this.observableStandsClient.handleMessage(event);
                } else if (event.get_typeOfEvent().equals("ServerErrorEvent") || event.get_typeOfEvent().equals("StandErrorEvent") || event.get_typeOfEvent().equals("UnitErrorEvent")) {
                    this.observableErrorClient.handleMessage(event);
                }
                message.acknowledge();
            }
            catch (JMSException ex) {
                String errorMsg = "onMessage() runs into JMSException: " + (Object)((Object)ex);
                log.error((Object)errorMsg, (Throwable)ex);
                this.informantClient.notify(errorMsg, "ServerErrorEvent");
            }
            catch (NullPointerException ex) {
                log.error((Object)("onMessage() runs into NullPointerException. Probably the client was shut down. " + ex), (Throwable)ex);
            }
            catch (Exception ex) {
                String errorMsg = "onMessage() runs into Exception: " + ex;
                log.error((Object)errorMsg, (Throwable)ex);
                this.informantClient.notify(errorMsg, "ServerErrorEvent");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"onMessage(): Connection lost to client!");
            }
            if (this.isMarkedForShutdown()) {
                log.warn((Object)" - marked for shutdown. Client closed or Connection lost.");
                this.checkSelfDestruction();
            }
        }
    }

    public void ping() throws JMSException {
        if (!this.isMarkedForShutdown()) {
            try {
                log.debug((Object)"ping()");
                this.client.sendObject(new Long(System.currentTimeMillis()));
            }
            catch (IOException e) {
                log.debug((Object)"ping() runs into IOException! Probably the client was shut down. Session will be unsubscribed!");
                this.setMarkedForShutdown(true);
            }
            catch (NullPointerException e) {
                log.error((Object)"ping() runs into NullPointerException! Client session will be unsubscribed", (Throwable)e);
                this.informantClient.notify("ping() runs into NullPointerException! Client session will be unsubscribed!" + e, "ServerErrorEvent");
                log.warn((Object)"ping-Thread will be stopped manually");
                this.pingThread.stopRunning();
                this.setMarkedForShutdown(true);
            }
            catch (Exception e) {
                log.error((Object)"ping() Unkown Exception caught!!!!! Will shutdown all Client Threads as a precaution!!! See log-files for further infos!", (Throwable)e);
                this.informantClient.notify("ping() runs into NullPointerException! Client session will be unsubscribed!" + e, "ServerErrorEvent");
                log.warn((Object)"ping-Thread will be stopped manually");
                this.pingThread.stopRunning();
                this.setMarkedForShutdown(true);
            }
        } else {
            log.warn((Object)"This ObservableClient ist marked for shutdown. Ping not executed.");
            this.checkSelfDestruction();
        }
    }

    public void setClient(RemoteClient client) {
        this.client = client;
    }

    public void setSession(TopicSession session) {
        this.session = session;
    }

    protected synchronized void deleteObserverClient() throws JMSException {
        if (!this.isObserverClientDeleted) {
            log.debug((Object)"Deleting all connections in ObserverClient");
            try {
                this.lostConnectionToClient = true;
                this.deleteJMSClient();
                if (this.pingThread != null) {
                    this.pingThread.stopRunning();
                    this.pingThread.resetTimer();
                    this.pingThread = null;
                }
                if (this.observableUnitsClient != null) {
                    this.observableUnitsClient.cleanUp();
                    this.observableUnitsClient = null;
                }
                if (this.observableStandsClient != null) {
                    this.observableStandsClient.cleanUp();
                    this.observableStandsClient = null;
                }
                if (this.observableErrorClient != null) {
                    this.observableErrorClient.cleanUp();
                    this.observableErrorClient = null;
                }
            }
            catch (NullPointerException e) {
                log.error((Object)"deleteObserverClient runs into NullPointerException!", (Throwable)e);
                this.informantClient.notify("deleteObserverClient runs into NullPointerException! " + e, "ServerErrorEvent");
            }
        }
    }

    private void deleteJMSClient() {
        try {
            if (null != this.jmsClient.getSubscriber()) {
                this.jmsClient.getSubscriber().close();
                log.debug((Object)"TopicSubscriber closed!");
            }
        }
        catch (Exception ex) {
            log.error((Object)("deleteJMSClient ends in Exception: " + ex));
        }
        try {
            if (null != this.jmsClient.getSession()) {
                this.jmsClient.getSession().close();
                log.debug((Object)"TopicSession closed!");
            }
        }
        catch (Exception ex) {
            log.error((Object)("deleteJMSClient ends in Exception: " + ex));
        }
        try {
            if (null != this.jmsClient.getConnect()) {
                this.jmsClient.getConnect().close();
                log.debug((Object)"TopicConnection closed!");
            }
        }
        catch (Exception ex) {
            log.error((Object)("deleteJMSClient ends in Exception: " + ex));
        }
        try {
            if (null != this.jmsClient.getCtx()) {
                this.jmsClient.getCtx().close();
                log.debug((Object)"Context closed!");
            }
        }
        catch (Exception ex) {
            log.error((Object)("deleteJMSClient ends in Exception: " + ex));
        }
    }

    protected void sendEventBufferToClient() {
        String errorMsg;
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendEventBufferToClient()");
        }
        while (this.unitEventBufferLinkedList.size() > 0 && !this.isMarkedForShutdown()) {
            try {
                this.observableUnitsClient.sendMessageToClient(this.unitEventBufferLinkedList.poll());
            }
            catch (JMSException ex) {
                errorMsg = "sendEventBufferToClient() runs into JMSException: " + (Object)((Object)ex);
                log.error((Object)errorMsg, (Throwable)ex);
                this.informantClient.notify(errorMsg, "ServerErrorEvent");
                this.setMarkedForShutdown(true);
            }
            catch (Exception ex) {
                errorMsg = "sendEventBufferToClient() runs into Exception: " + ex;
                log.error((Object)errorMsg, (Throwable)ex);
                this.informantClient.notify(errorMsg, "ServerErrorEvent");
                this.setMarkedForShutdown(true);
            }
            this.pingThread.resetTimer();
            this.unitsEventBufferActive = false;
        }
        while (this.standsEventBufferLinkedList.size() > 0 && !this.isMarkedForShutdown()) {
            try {
                this.observableStandsClient.sendMessageToClient(this.standsEventBufferLinkedList.poll());
            }
            catch (JMSException ex) {
                errorMsg = "sendEventBufferToClient() runs into JMSException: " + (Object)((Object)ex);
                log.error((Object)errorMsg, (Throwable)ex);
                this.informantClient.notify(errorMsg, "ServerErrorEvent");
                this.setMarkedForShutdown(true);
            }
            catch (Exception ex) {
                errorMsg = "sendEventBufferToClient() runs into Exception: " + ex;
                log.error((Object)errorMsg, (Throwable)ex);
                this.informantClient.notify(errorMsg, "ServerErrorEvent");
                this.setMarkedForShutdown(true);
            }
            this.pingThread.resetTimer();
            this.standsEventBufferActive = false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendEventBufferToClient(): Buffer sent to client");
        }
        if (this.isMarkedForShutdown()) {
            log.warn((Object)"Client was marked for Shutdown while sending Eventlist to the client. Sending aborded");
            this.checkSelfDestruction();
        }
        log.debug((Object)"sendMessageToClient():EventBuffer deactivated!");
    }

    private void startPingThread() {
        if (log.isDebugEnabled()) {
            log.info((Object)"Init new PingThread");
        }
        this.pingThread = new PingThread();
        this.pingThread.setListener(this);
        this.pingThread.start();
    }

    public void cleanUp() {
        String method = "cleanUp(): ";
        try {
            log.debug((Object)(method + "start"));
            this.deleteObserverClient();
            log.debug((Object)(method + "end"));
        }
        catch (JMSException e) {
            log.error((Object)(method + "runs into JMSException: "), (Throwable)e);
        }
    }

    public JMSClient getJmsClient() {
        return this.jmsClient;
    }

    public void setJmsClient(JMSClient jmsClient) {
        this.jmsClient = jmsClient;
    }

    public String getClientName() {
        return this.clientName;
    }

    public boolean isReconnected() {
        return this.reconnected;
    }

    public void setReconnected(boolean reconnected) {
        this.reconnected = reconnected;
    }

    public boolean isMarkedForShutdown() {
        return this.markedForShutdown;
    }

    public void setMarkedForShutdown(boolean markedForShutdown) {
        this.markedForShutdown = markedForShutdown;
        if (this.markedForShutdownTimeStamp == 0L) {
            this.markedForShutdownTimeStamp = System.currentTimeMillis();
        }
    }

    private void checkSelfDestruction() {
        if (this.markedForShutdownTimeStamp != 0L) {
            if (System.currentTimeMillis() - this.markedForShutdownTimeStamp > 6000L) {
                log.warn((Object)"Waittime of servlet shutdown exceeded. Will force self destruction of this ObservableClient. ");
                this.parentServletThread.setRunning(false);
                log.debug((Object)"Stopflag in parent servlet set.");
                try {
                    this.deleteObserverClient();
                    log.debug((Object)"Selfdestruction finished.");
                }
                catch (JMSException e) {
                    log.error((Object)"runs into: ", (Throwable)e);
                }
                log.debug((Object)"Remove entry in ObservableClientFactory.");
                ObservableClientFactory.getInstance().removeClient(this.clientName);
            }
        } else {
            log.warn((Object)"No timestamp for self destruction set.");
        }
    }
}

