/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable;

import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClient;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientWrapper
extends Thread {
    private final Log log = LogFactory.getLog(ClientWrapper.class);
    private ObservableClient observableClient = null;
    private int reconnectCount = 0;
    private int maxReconnects = 0;
    private String clientName = null;
    private ConfigurationClient configurationClient = null;
    private boolean keepRunnig = true;

    public ClientWrapper(ObservableClient client) {
        this.log.debug((Object)"ClientWrapper - Constructor called.");
        this.configurationClient = new ConfigurationClient();
        try {
            this.maxReconnects = this.configurationClient.getInteger("observable.max-reconnect");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Will allow" + this.maxReconnects + " reconnects."));
            }
        }
        catch (RemoteException e) {
            this.log.error((Object)"No value for max. reconnects in configuration found. Will use default of 5 reconnects.  --> RemoteException");
            this.maxReconnects = 5;
        }
        catch (ConfigurationParameterNotFoundException e) {
            this.log.error((Object)"No value for max. reconnects in configuration found. Will use default of 5 reconnects.  --> ConfigurationParameterNotFoundException");
            this.maxReconnects = 5;
        }
        this.observableClient = client;
        this.clientName = this.observableClient.getClientName();
    }

    public boolean increaseReconnectCount() {
        if (this.reconnectCount < this.maxReconnects) {
            ++this.reconnectCount;
            return true;
        }
        return false;
    }

    public ObservableClient getObservableClient() {
        return this.observableClient;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void run() {
        while (this.keepRunnig) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Wait state interrupted --> " + this.getClientName()));
            }
        }
        this.log.debug((Object)"ClientWrapper stopped.");
    }

    public void stopWrapperFromOutside() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("ClientWrapper will be stopped by a external call. " + this.getClientName()));
        }
        this.keepRunnig = false;
    }
}

