/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.fis;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.FisFlightFacade;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.FisFlightFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.FisFlightTransform;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.FisFlightTransformUtil;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableFacade;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableFacadeUtil;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestingFisEventServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(TestingFisEventServlet.class);
    private FisFlightTransform fisFlightTransform;
    private FisFlightFacade fisFlightFacade;
    private ObservableFacade observableFacade;
    private String state = "ok";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.getWriter().println("GET CALLED!");
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String type = request.getParameter("type");
        if (type.equals("flight")) {
            this.proceedFlightEvent(request, response);
        } else if (type.equals("staff")) {
            this.proceedStaffEvent(request, response);
        } else if (type.equals("gse")) {
            this.proceedGSEEvent(request, response);
        }
        response.getWriter().println(this.state + "\n type of event: " + type + "\n request was: " + request.getRequestURI() + "\n server path:" + request.getContextPath() + "\n remote address:" + request.getRemoteAddr());
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            this.fisFlightTransform = FisFlightTransformUtil.getHome().create();
            this.fisFlightFacade = FisFlightFacadeUtil.getHome().create();
            this.observableFacade = ObservableFacadeUtil.getHome().create();
        }
        catch (CreateException e) {
            this.state = "internal server error, CreateException";
            log.error((Object)e.getStackTrace());
        }
        catch (NamingException e) {
            this.state = "internal server error, NamingException";
            log.error((Object)e.getStackTrace());
        }
        catch (RemoteException e) {
            this.state = "internal server error, RemoteException";
            log.error((Object)e.getStackTrace());
        }
    }

    private void proceedFlightEvent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String testXML = request.getParameter("testXML");
        log.debug((Object)("XMLTest: " + testXML));
        log.debug((Object)("Flight XMLString: " + request.getParameter("FISxmlString")));
        if (testXML != null) {
            if (testXML.equals("true")) {
                SerializableEventWrapper wrapper = new SerializableEventWrapper((Serializable)((Object)request.getParameter("FISxmlString")));
                wrapper.set_typeOfEvent("FlightUpdate");
                this.observableFacade.notifyClients(wrapper, "FlightTestEvent");
            } else if (testXML.equals("false")) {
                if (request.getParameter("FISxmlString") != null) {
                    this.fisFlightFacade.updateFlight(request.getParameter("FISxmlString"));
                } else {
                    log.error((Object)"FISxmlString was null!");
                    this.state = "FISxmlString was null!";
                }
            }
        }
    }

    private void proceedStaffEvent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String testXML = request.getParameter("testXML");
        log.debug((Object)("Staff XMLString: " + request.getParameter("FISxmlString")));
        SerializableEventWrapper wrapper = new SerializableEventWrapper((Serializable)((Object)request.getParameter("FISxmlString")));
        wrapper.set_typeOfEvent("StaffAllocationEventUpdate");
        log.debug((Object)"calling observableFacade.cotifyClients");
        log.debug((Object)("testXML: " + testXML));
        if (testXML.equals("true")) {
            this.observableFacade.notifyClients(wrapper, "AllocationTestEvent");
        } else if (testXML.equals("false")) {
            this.observableFacade.notifyClients(wrapper, "StaffAllocationEvent");
        } else {
            log.error((Object)"testXML is neither true nor false");
        }
    }

    private void proceedGSEEvent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String testXML = request.getParameter("testXML");
        log.debug((Object)("Gse XMLString: " + request.getParameter("FISxmlString")));
        SerializableEventWrapper wrapper = new SerializableEventWrapper((Serializable)((Object)request.getParameter("FISxmlString")));
        wrapper.set_typeOfEvent("GSEAllocationEventUpdate");
        log.debug((Object)"calling observableFacade.cotifyClients");
        log.debug((Object)("testXML: " + testXML));
        if (testXML.equals("true")) {
            this.observableFacade.notifyClients(wrapper, "AllocationTestEvent");
        } else if (testXML.equals("false")) {
            this.observableFacade.notifyClients(wrapper, "GSEAllocationEvent");
        } else {
            log.error((Object)"testXML is neither true nor false");
        }
    }
}

