/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn;

import de.proveo.wwt.logic.ejb.dataIn.event.EventFacade;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeUtil;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutOfServiceServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(OutOfServiceServlet.class);
    protected static final String PARAM_NAME_UNITID = "unitId";
    protected static final String PARAM_NAME_STATE = "state";
    protected static final String PARAM_NAME_REASON = "reason";
    protected static final String PARAM_NAME_REMARK = "remark";
    protected static final String PARAM_STATE_AVAILABLE = "available";
    protected static final String PARAM_STATE_OUTOFSERVICE = "outofservice";
    protected static final String PARAM_REASON_MAINTENANCE = "maintenance";
    protected static final String PARAM_REASON_BREAKDOWN = "breakdown";
    protected static final long STATEMODEL_ID = 2090L;
    private EventFacade eventFacade;

    public String getServletInfo() {
        return "Set the outofservice state of an unit";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.eventFacade = EventFacadeUtil.getHome().create();
        }
        catch (Exception ex) {
            throw new ServletException("cannot lookup EventFacade", (Throwable)ex);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected long getStateId(HttpServletRequest request) throws ServletException {
        if (request.getParameter(PARAM_NAME_STATE) == null) {
            throw new ServletException("Parameter state is missing");
        }
        if (request.getParameter(PARAM_NAME_STATE).equalsIgnoreCase(PARAM_STATE_AVAILABLE)) {
            return 2091L;
        }
        if (request.getParameter(PARAM_NAME_STATE).equalsIgnoreCase(PARAM_STATE_OUTOFSERVICE)) {
            if (request.getParameter(PARAM_NAME_REASON) == null || request.getParameter(PARAM_NAME_REASON).trim().equals("")) {
                return 2095L;
            }
            if (request.getParameter(PARAM_NAME_REASON).equalsIgnoreCase(PARAM_REASON_MAINTENANCE)) {
                return 2092L;
            }
            if (request.getParameter(PARAM_NAME_REASON).equalsIgnoreCase(PARAM_REASON_BREAKDOWN)) {
                return 2096L;
            }
            log.warn((Object)"unkown value for parameter state use other");
            return 2095L;
        }
        throw new ServletException("unkown value for parameter state");
    }

    protected long getUnitId(HttpServletRequest request) throws ServletException {
        if (request.getParameter(PARAM_NAME_UNITID) == null) {
            throw new ServletException("Parameter unitId is missing");
        }
        try {
            return Long.parseLong(request.getParameter(PARAM_NAME_UNITID));
        }
        catch (NumberFormatException ex) {
            throw new ServletException("Parameter unitId is not a number", (Throwable)ex);
        }
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("processRequest() begin: " + request.getQueryString()));
        }
        response.setContentType("text/html;charset=UTF-8");
        Properties event = new Properties();
        event.setProperty("t", Long.toString(System.currentTimeMillis()));
        event.setProperty("u", Long.toString(this.getUnitId(request)));
        event.setProperty("m", Long.toString(2090L));
        event.setProperty("s", Long.toString(this.getStateId(request)));
        if (request.getParameter(PARAM_NAME_REMARK) != null && !request.getParameter(PARAM_NAME_REMARK).trim().equals("")) {
            event.setProperty("c", request.getParameter(PARAM_NAME_REMARK));
        }
        try {
            this.eventFacade.handleEvent(event);
        }
        catch (Exception ex) {
            throw new ServletException("cannot send event, server problem", (Throwable)ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("processRequest() end: " + request.getQueryString()));
        }
    }
}

