/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn;

import de.proveo.wwt.logic.ejb.general.area.AreaData;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacade;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacadeUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsValue;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AreaInServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(AreaInServlet.class);
    private static final long serialVersionUID = 165726844391L;
    private AreaInFacade areaInFacade;

    public String getServletInfo() {
        return "Short description";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.areaInFacade = AreaInFacadeUtil.getHome().create();
        }
        catch (Exception ex) {
            log.error((Object)"Exception throwing during returning a AreaBean", (Throwable)ex);
            throw new ServletException("Exception throwing during returning a AreaBean ");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletInputStream is = request.getInputStream();
        ObjectInputStream oin = new ObjectInputStream((InputStream)is);
        HashMap areasMap = null;
        try {
            areasMap = (HashMap)oin.readObject();
        }
        catch (Exception ex) {
            throw new ServletException("Error while deserializing", (Throwable)ex);
        }
        ArrayList<AreaData> areas = new ArrayList<AreaData>();
        for (String areaName : areasMap.keySet()) {
            HashMap areaValues = (HashMap)areasMap.get(areaName);
            String areaDesc = (String)areaValues.get("desc");
            String areaPrio = (String)areaValues.get("prio");
            ArrayList areaPoints = (ArrayList)areaValues.get("points");
            AreaData areaData = new AreaData();
            areaData.setName(areaName);
            areaData.setDescription(areaDesc);
            areaData.setPriority(Integer.parseInt(areaPrio));
            ArrayList<AreaPointsValue> pointValues = new ArrayList<AreaPointsValue>();
            Iterator itePoints = areaPoints.iterator();
            int p = 1;
            while (itePoints.hasNext()) {
                AreaPointsValue areaPointsValue;
                Point point = (Point)itePoints.next();
                if (!itePoints.hasNext()) {
                    areaPointsValue = new AreaPointsValue();
                    areaPointsValue.setArea(areaName);
                    areaPointsValue.setLongMsec((int)point.getX());
                    areaPointsValue.setLatMsec((int)point.getY());
                    areaPointsValue.setPoint(p);
                } else {
                    areaPointsValue = new AreaPointsValue();
                    areaPointsValue.setArea(areaName);
                    areaPointsValue.setLongMsec((int)point.getX());
                    areaPointsValue.setLatMsec((int)point.getY());
                    areaPointsValue.setPoint(p);
                }
                pointValues.add(areaPointsValue);
                ++p;
            }
            areaData.setAreaPointDatas(pointValues);
            areas.add(areaData);
        }
        try {
            this.areaInFacade.updateAllAreas(areas);
        }
        catch (Exception ex) {
            throw new ServletException("Error while updateAllAreas", (Throwable)ex);
        }
    }
}

