/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.historyData.dto;

import de.proveo.util.geo.GPSPosition;
import de.proveo.wwt.logic.ejb.geo.history.GdataHistoryValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.UnitStateDTOBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PositionDTO
extends UnitStateDTOBase {
    private static final Log log = LogFactory.getLog(PositionDTO.class);
    private boolean trusted;
    private String ggaRec;
    private int latMSEC;
    private int longMSEC;
    private String rmcRmcRec;
    private String reason;
    private String area;
    private String areaDescr;
    private GPSPosition gpsPosition;
    private long pkGdataPrevious;

    public PositionDTO(UnitDTO unitDTO, GdataHistoryValue value, String area, String areaDescription) {
        super(unitDTO);
        this.beginTime = value.getBeginTime();
        this.endTime = value.getEndTime();
        this.beginReceiveTime = value.getBeginReceiveTime();
        this.endReceiveTime = value.getEndReceiveTime();
        this.trusted = value.getTrusted();
        this.ggaRec = value.getGgaRec();
        this.latMSEC = value.getLatMSEC();
        this.longMSEC = value.getLongMSEC();
        this.rmcRmcRec = value.getRmcRec();
        this.reason = value.getReason();
        this.area = area;
        this.areaDescr = areaDescription;
        this.gpsPosition = new GPSPosition(this.rmcRmcRec, this.ggaRec, this.trusted);
    }

    public PositionDTO(UnitDTO unitDTO, long beginTime, long endTime, long beginReceiveTime, long endReceiveTime, boolean trusted, String ggaRec, int latMSEC, int longMSEC, String rmcRmcRec, String reason, String area, String areaDescrption) {
        super(unitDTO);
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.beginReceiveTime = beginReceiveTime;
        this.endReceiveTime = endReceiveTime;
        this.trusted = trusted;
        this.ggaRec = ggaRec;
        this.latMSEC = latMSEC;
        this.longMSEC = longMSEC;
        this.rmcRmcRec = rmcRmcRec;
        this.reason = reason;
        this.area = area;
        this.areaDescr = areaDescrption;
        if (ggaRec != null) {
            this.gpsPosition = new GPSPosition(rmcRmcRec, ggaRec, trusted);
        }
    }

    public long getBeginDelay() {
        return this.beginReceiveTime - this.beginTime;
    }

    public long getEndDelay() {
        long delay = this.endReceiveTime - this.endTime;
        if (delay < 0L) {
            delay = 0L;
        }
        return delay;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }

    public String getGgaRec() {
        return this.ggaRec;
    }

    public int getLatMSEC() {
        return this.latMSEC;
    }

    public int getLongMSEC() {
        return this.longMSEC;
    }

    public String getRmcRmcRec() {
        return this.rmcRmcRec;
    }

    public String getReason() {
        return this.reason;
    }

    public String getArea() {
        return this.area;
    }

    public String getAreaDescription() {
        return this.areaDescr;
    }

    public int getSpeedMph() {
        return this.gpsPosition.getSpeedMphIntValue();
    }

    public int getSpeedKmh() {
        return this.gpsPosition.getSpeedKmhIntValue();
    }

    public long getDuration() {
        return this.endTime - this.beginTime;
    }

    public String getPositionString() {
        return this.gpsPosition.getPositionString();
    }

    public float getAltitude() {
        return this.gpsPosition.getAltitude();
    }

    public String getRmcAndGgaRec() {
        return this.getRmcRmcRec() + "\n" + this.getGgaRec();
    }

    public int getCourse() {
        return this.gpsPosition.getCourseIntValue();
    }

    public long getPkGdataPrevious() {
        return this.pkGdataPrevious;
    }

    public void setPkGdataPrevious(long pkGdataPrevious) {
        this.pkGdataPrevious = pkGdataPrevious;
    }
}

