/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto;

import de.proveo.wwt.logic.ejb.general.tree.TreeNode;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitTreeNode
extends TreeNode<UnitTreeNode, UnitDTO> {
    private static final long serialVersionUID = -1941187981866048788L;
    private static final Log log = LogFactory.getLog(UnitTreeNode.class);

    public UnitTreeNode() {
        this.setData(new UnitDTO(null, null, null));
    }

    public UnitTreeNode(UnitModelValue unitModelValue, UnitIdentityValue unitIdentityValue, UnitTypeIdentityValue unitTypeIdentityValue) {
        this.setData(new UnitDTO(unitModelValue, unitIdentityValue, unitTypeIdentityValue));
    }

    public boolean isBasic() {
        return ((UnitDTO)this.getData()).getUnitModelValue().getBasic();
    }

    @Override
    public void addChild(UnitTreeNode node) {
        if (node != null) {
            if (!((UnitDTO)this.getData()).getUnitModelValue().getBasic()) {
                node.setParent(this);
                this.getChildren().add(node);
            } else {
                log.error((Object)"addChild(): Tried to add child to basic unit! Skipped.");
            }
        }
    }

    public void setBasic(boolean basic) {
        ((UnitDTO)this.getData()).getUnitModelValue().setBasic(basic);
    }

    public void removeUnauthorizedUnits(Set<Long> authorizedUnits) {
        List allNodes = this.getAllNodes(false);
        for (int i = allNodes.size() - 1; i >= 0; --i) {
            UnitTreeNode currentNode = (UnitTreeNode)allNodes.get(i);
            UnitDTO unitDto = (UnitDTO)currentNode.getData();
            if (!unitDto.isBasic() || authorizedUnits.contains(unitDto.getUnitId())) continue;
            currentNode.remove();
        }
        this.removeEmptyGroups();
    }

    public void removeEmptyGroups() {
        List allNodes = this.getAllNodes(false);
        for (int i = allNodes.size() - 1; i >= 0; --i) {
            UnitTreeNode currentNode = (UnitTreeNode)allNodes.get(i);
            if (((UnitDTO)currentNode.getData()).isBasic() || currentNode.hasChildren()) continue;
            currentNode.remove();
        }
    }
}

