/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.hierarchicalData.unitTree;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeUtil;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeComparator;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocal;
import de.proveo.wwt.logic.web.security.PermissionCheckerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnitTreeFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final long serialVersionUID = -1747561574171800108L;
    private PermissionCheckerLocal permissionCheckerLocal;
    private UnitFacadeLocal adminUnitFacadeLocal;
    private static final Log log = LogFactory.getLog(UnitTreeFacadeBean.class);

    public void ejbCreate() throws CreateException {
        try {
            this.adminUnitFacadeLocal = UnitFacadeUtil.getLocalHome().create();
            this.permissionCheckerLocal = PermissionCheckerUtil.getLocalHome().create();
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    public UnitTreeNode getTreeViewData(boolean permissionFiltered, boolean airportMapFiltered, boolean withoutDeletedUnits) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTreeViewData called permissionFiltered:" + permissionFiltered + " airportMapFiltered: " + airportMapFiltered));
        }
        UnitTreeNode treeRoot = null;
        try {
            Collection<UnitModelLocal> rootGroups = this.adminUnitFacadeLocal.getUnitsWithoutParents(false);
            if (rootGroups != null) {
                Iterator<UnitModelLocal> rootGroupIterator = rootGroups.iterator();
                treeRoot = new UnitTreeNode();
                while (rootGroupIterator.hasNext()) {
                    UnitModelLocal rootUnit = rootGroupIterator.next();
                    UnitTreeNode rootGroupNode = DTOFactory.buildUnitTreeNode(rootUnit);
                    treeRoot.addChild(rootGroupNode);
                    this.iterateNodes(rootUnit, rootGroupNode, airportMapFiltered, withoutDeletedUnits);
                }
                Collection<UnitModelLocal> rootUnits = this.adminUnitFacadeLocal.getUnitsWithoutParents(true);
                for (UnitModelLocal unit : rootUnits) {
                    if (airportMapFiltered) {
                        if (!unit.getUnitModelValue().getAirportMapVisible()) continue;
                        treeRoot.addChild(DTOFactory.buildUnitTreeNode(unit));
                        continue;
                    }
                    treeRoot.addChild(DTOFactory.buildUnitTreeNode(unit));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        if (permissionFiltered) {
            treeRoot.removeUnauthorizedUnits(this.permissionCheckerLocal.getUnitPermissions());
            if (treeRoot.getChildren().size() == 0) {
                return null;
            }
        }
        return treeRoot;
    }

    private void iterateNodes(UnitModelLocal unitModel, UnitTreeNode node, boolean airportMapFiltered, boolean withoutDeletedUnits) {
        Collection unitModels = unitModel.getChildUnits();
        Iterator unitModelIterator = unitModels.iterator();
        ArrayList<UnitModelLocal> unitList = new ArrayList<UnitModelLocal>();
        while (unitModelIterator.hasNext()) {
            UnitModelLocal currentUnitModel = (UnitModelLocal)unitModelIterator.next();
            if (withoutDeletedUnits && currentUnitModel.getUnitModelValue().getDeleted()) continue;
            if (airportMapFiltered && currentUnitModel.getUnitModelValue().getBasic()) {
                if (!currentUnitModel.getUnitModelValue().getAirportMapVisible()) continue;
                unitList.add(currentUnitModel);
                continue;
            }
            unitList.add(currentUnitModel);
        }
        Collections.sort(unitList, new UnitTreeComparator());
        for (UnitModelLocal currentUnitModel : unitList) {
            UnitTreeNode unitNode = DTOFactory.buildUnitTreeNode(currentUnitModel);
            try {
                node.addChild(unitNode);
                if (currentUnitModel.getBasic()) continue;
                this.iterateNodes(currentUnitModel, unitNode, airportMapFiltered, withoutDeletedUnits);
            }
            catch (Exception e) {
                log.error((Object)"run into", (Throwable)e);
            }
        }
    }

    public UnitTreeNode getWebTreeModel(boolean filtered, boolean withoutDeletedUnits) {
        log.debug((Object)("getWebTreeModel logged in as: " + super.getCallerName()));
        return this.getTreeViewData(filtered, false, withoutDeletedUnits);
    }

    public UnitTreeNode getICCTreeModel() {
        log.debug((Object)("getICCTreeModel logged in as: " + super.getCallerName()));
        return this.getTreeViewData(true, false, true);
    }

    public UnitTreeNode getAirportMapTreeModel() {
        log.debug((Object)("getAirportMapTreeModel logged in as: " + super.getCallerName()));
        return this.getTreeViewData(true, true, true);
    }
}

