/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data;

import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.FastLaneBase;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FastLaneReader
extends FastLaneBase {
    private static final Log log = LogFactory.getLog(FastLaneReader.class);
    protected static final int DEFAULT_ROW_LIMIT = 50001;
    private ConfigurationClient configurationClient = new ConfigurationClient();

    protected static int rowCount(ResultSet resultSet) {
        int size = 0;
        if (resultSet != null) {
            try {
                resultSet.last();
                size = resultSet.getRow();
                resultSet.beforeFirst();
            }
            catch (SQLException e) {
                log.error((Object)("Error counting rows of ResultSet. (" + e.getMessage() + ")"));
            }
        }
        return size;
    }

    protected int getRowLimit() {
        int maxRowsLimit = 50001;
        try {
            maxRowsLimit = Integer.parseInt(this.configurationClient.getParameter("maxRowsFetchLimit", String.valueOf(50001)));
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving row limit for FastLaneReader. Defaulting to " + String.valueOf(50001)));
        }
        return maxRowsLimit;
    }

    protected UnitDTO buildUnitDTO(ResultSet rst) {
        UnitDTO unitDTO = null;
        try {
            long shUnitId = rst.getLong("UNIT_ID");
            String unitName = rst.getString("NAME");
            String unitImageName = rst.getString("IMAGE_NAME");
            String typeName = rst.getString("TYPE_NAME");
            String typeImageName = rst.getString("TYPE_IMAGE_NAME");
            String bodyNumber = rst.getString("BODY_NUMBER");
            String regNumber = rst.getString("REGISTRATION_NUMBER");
            String brand = rst.getString("BRAND");
            String modelType = rst.getString("MODEL_TYPE");
            boolean deleted = rst.getBoolean("DELETED");
            UnitModelValue unitModelValue = new UnitModelValue();
            unitModelValue.setUnitId(shUnitId);
            unitModelValue.setBasic(true);
            unitModelValue.setBodyNumber(bodyNumber);
            unitModelValue.setRegistrationNumber(regNumber);
            unitModelValue.setBrand(brand);
            unitModelValue.setModelType(modelType);
            unitModelValue.setDeleted(deleted);
            UnitIdentityValue unitIdentityValue = new UnitIdentityValue();
            unitIdentityValue.setName(unitName);
            unitIdentityValue.setImageName(unitImageName);
            UnitTypeIdentityValue unitTypeIdentity = new UnitTypeIdentityValue();
            unitTypeIdentity.setName(typeName);
            unitTypeIdentity.setImageName(typeImageName);
            unitDTO = new UnitDTO(unitModelValue, unitIdentityValue, unitTypeIdentity);
        }
        catch (SQLException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return unitDTO;
    }
}

