/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.commonData;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.app.state.StateModel;
import de.proveo.wwt.logic.app.state.StateModelFactory;
import de.proveo.wwt.logic.app.state.aviation.AviationStateModelConstants;
import de.proveo.wwt.logic.app.state.exception.StateModelNotFoundException;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleValue;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeUtil;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocalHome;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocalHome;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserUtil;
import de.proveo.wwt.logic.web.admin.AdminStartpageDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonDataFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final long serialVersionUID = -1747561574171800108L;
    private AccountLocalHome accountLocalHome;
    private GroupIdentLocalHome groupIdentHome;
    private UseUserLocalHome useUserLocalHome;
    private UseGroupLocalHome useGroupLocalHome;
    private RoleLocalHome roleLocalHome;
    private UnitFacadeLocal unitFacade;
    private AreaLocalHome areaLocalHome;
    private static final Log log = LogFactory.getLog(CommonDataFacadeBean.class);

    public void ejbCreate() throws CreateException {
        try {
            this.accountLocalHome = AccountUtil.getLocalHome();
            this.groupIdentHome = GroupIdentUtil.getLocalHome();
            this.useUserLocalHome = UseUserUtil.getLocalHome();
            this.useGroupLocalHome = UseGroupUtil.getLocalHome();
            this.roleLocalHome = RoleUtil.getLocalHome();
            this.areaLocalHome = AreaUtil.getLocalHome();
            this.unitFacade = UnitFacadeUtil.getLocalHome().create();
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    public List<AreaValue> getAllAreas() {
        ArrayList<AreaValue> list = null;
        try {
            Collection areas = this.areaLocalHome.findOrderedByPriority();
            list = new ArrayList<AreaValue>();
            for (AreaLocal area : areas) {
                list.add(area.getAreaValue());
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public HashMap<Long, List<Long>> getAllStates() {
        log.debug((Object)"getAllStates");
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>();
        StateModelFactory s = new StateModelFactory();
        long[] stateModelIDs = AviationStateModelConstants.POSSIBLE_STATES;
        for (int i = 0; i < stateModelIDs.length; ++i) {
            ArrayList<Long> list = new ArrayList<Long>();
            Long stateModelId = stateModelIDs[i];
            try {
                StateModel model = s.getStateModel(stateModelId, 0L);
                long[] stateIds = model.getPossibleStates();
                for (int j = 0; j < stateIds.length; ++j) {
                    list.add(stateIds[j]);
                }
                map.put(stateModelId, list);
                continue;
            }
            catch (StateModelNotFoundException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        return map;
    }

    public AdminStartpageDTO getAdminStartpageDTO() {
        AdminStartpageDTO adminStartpageDTO = new AdminStartpageDTO();
        try {
            adminStartpageDTO.setUserCount(this.accountLocalHome.findAll().size());
            adminStartpageDTO.setUserGroupCount(this.groupIdentHome.findAll().size());
            adminStartpageDTO.setUseUserGroupCount(this.useGroupLocalHome.findAll().size());
            adminStartpageDTO.setUseUserCount(this.useUserLocalHome.findAll().size());
            adminStartpageDTO.setBasicUnitCount(this.unitFacade.getUnitsByIsBasic(true, false, true).size());
            adminStartpageDTO.setNotBasicUnitCount(this.unitFacade.getUnitsByIsBasic(false, false, true).size());
            Collection list = this.roleLocalHome.findAll();
            ArrayList<RoleValue> filteredList = new ArrayList<RoleValue>();
            for (RoleLocal local : list) {
                RoleValue value = local.getRoleValue();
                if (value.getRolename().startsWith("section.")) continue;
                filteredList.add(value);
            }
            adminStartpageDTO.setRoleCount(filteredList.size());
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return adminStartpageDTO;
    }
}

