/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.dto;

import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.history.FisFlightHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.history.FisFlightHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountValue;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.scheduledReports.ScheduledReportLocal;
import de.proveo.wwt.logic.ejb.general.scheduledReports.ScheduledReportValue;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.NotificationReportDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.OutputFormat;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.PageFormat;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.PeakModelReportDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.PositionReportDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.ReportBaseDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.StatusReportDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.TimeInterval;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.UnitReporBaseDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.UseUserReportDTO;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocal;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupValue;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import de.proveo.wwt.logic.ejb.geo.cache.CurrentGdataCacheLocal;
import de.proveo.wwt.logic.ejb.geo.cache.CurrentGdataCacheValue;
import de.proveo.wwt.logic.ejb.geo.history.GdataHistoryLocal;
import de.proveo.wwt.logic.ejb.geo.history.GdataHistoryValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.currentData.dto.GseAvailabilityDTO;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import de.proveo.wwt.logic.web.historyData.dto.AccidentReconstructionDTO;
import de.proveo.wwt.logic.web.historyData.dto.FlightDTO;
import de.proveo.wwt.logic.web.historyData.dto.FlightRotationDTO;
import de.proveo.wwt.logic.web.historyData.dto.GseProductivityDTO;
import de.proveo.wwt.logic.web.historyData.dto.KeepAliveDTO;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import de.proveo.wwt.logic.web.historyData.dto.ScanmanMessageDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateAssignmentDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTOList;
import de.proveo.wwt.logic.web.historyData.dto.UseDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.statusDuration.RunTimeDurationsDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.statusDuration.StatusDurationsDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DTOFactory {
    private static final Log log = LogFactory.getLog(DTOFactory.class);

    public static final StateDTO buildStateDTO(UnitModelValue unitModelValue, UnitIdentityValue unitIdentityValue, UnitTypeIdentityValue unitTypeIdentityValue, StateHistoryValue value) {
        return new StateDTO(unitModelValue, unitIdentityValue, unitTypeIdentityValue, value.getDuration(), value.getStateId(), value.getStateModelId(), value.getRemark(), value.getBeginTime(), value.getEndTime(), value.getBeginReceiveTime(), value.getEndReceiveTime(), value.getAreaTrusted());
    }

    public static final StateDTO buildStateDTO(UnitModelValue unitModelValue, UnitIdentityValue unitIdentityValue, UnitTypeIdentityValue unitTypeIdentityValue, CurrentStateCacheValue value) {
        long duration = System.currentTimeMillis() - value.getBeginTime();
        return new StateDTO(unitModelValue, unitIdentityValue, unitTypeIdentityValue, duration, value.getState(), value.getStateModelId(), value.getRemark(), value.getBeginTime(), 0L, value.getBeginReceiveTime(), 0L, value.getAreaTrusted());
    }

    public static final StateDTO buildStateDTO(UnitModelLocal unitModelLocal, CurrentStateCacheValue value) {
        return DTOFactory.buildStateDTO(DTOFactory.buildUnitDTO(unitModelLocal), value);
    }

    public static final StateDTO buildStateDTO(UnitModelLocal unitModelLocal, StateHistoryValue value) {
        return new StateDTO(DTOFactory.buildUnitDTO(unitModelLocal), value.getStateHistoryId(), value.getDuration(), value.getStateId(), value.getStateModelId(), value.getRemark(), value.getBeginTime(), value.getEndTime(), value.getBeginReceiveTime(), value.getEndReceiveTime());
    }

    public static final StateDTO buildStateDTO(UnitDTO unitDTO, CurrentStateCacheValue value) {
        return DTOFactory.buildStateDTO(unitDTO.getUnitModelValue(), unitDTO.getUnitIdentityValue(), unitDTO.getUnitTypeIdentityValue(), value);
    }

    public static final UnitDTO buildUnitDTO(UnitModelLocal model) {
        if (model == null) {
            return null;
        }
        UnitTypeIdentityLocal typeIdentityLocal = model.getUnitTypeIdentity();
        UnitTypeIdentityValue identityValue = null;
        if (typeIdentityLocal != null) {
            identityValue = typeIdentityLocal.getUnitTypeIdentityValue();
        }
        return new UnitDTO(model.getUnitModelValue(), model.getUnitIdentity().getUnitIdentityValue(), identityValue);
    }

    public static final UnitTreeNode buildUnitTreeNode(UnitModelLocal unitModelLocal) {
        UnitModelValue unitModelValue = unitModelLocal.getUnitModelValue();
        UnitIdentityValue unitIdentityValue = unitModelLocal.getUnitIdentity().getUnitIdentityValue();
        UnitTypeIdentityLocal typeIdentityLocal = unitModelLocal.getUnitTypeIdentity();
        UnitTypeIdentityValue unitTypeIdentityValue = null;
        if (typeIdentityLocal != null) {
            unitTypeIdentityValue = typeIdentityLocal.getUnitTypeIdentityValue();
        }
        return new UnitTreeNode(unitModelValue, unitIdentityValue, unitTypeIdentityValue);
    }

    public static final ScanmanMessageDTO buildScanManMessageDTO(UnitModelLocal unitModelLocal, ScanmanMsgCacheValue cacheValue) {
        return new ScanmanMessageDTO(DTOFactory.buildUnitDTO(unitModelLocal), cacheValue);
    }

    public static final ScanmanMessageDTO buildScanManMessageDTO(UnitModelLocal unitModelLocal, ScanmanMsgHistoryValue historyValue) {
        return new ScanmanMessageDTO(DTOFactory.buildUnitDTO(unitModelLocal), historyValue);
    }

    public static final UseDTO buildUseDTO(UseHistoryLocal useHistoryLocal) {
        UseUserLocal useUserLocal = useHistoryLocal.getUseUser();
        UseUserValue useUserValue = null;
        if (useUserLocal != null) {
            useUserValue = useUserLocal.getUseUserValue();
        }
        UseGroupLocal useGroupLocal = useHistoryLocal.getUseGroup();
        UseGroupValue useGroupValue = null;
        if (useGroupLocal != null) {
            useGroupValue = useGroupLocal.getUseGroupValue();
        }
        AreaValue beginAreaValue = null;
        AreaValue endAreaValue = null;
        if (useHistoryLocal.getBeginArea() != null) {
            beginAreaValue = useHistoryLocal.getBeginArea().getAreaValue();
        }
        if (useHistoryLocal.getEndArea() != null) {
            endAreaValue = useHistoryLocal.getEndArea().getAreaValue();
        }
        return new UseDTO(DTOFactory.buildUnitDTO(useHistoryLocal.getUnitModel()), useUserValue, useGroupValue, useHistoryLocal.getUseHistoryValue(), beginAreaValue, endAreaValue);
    }

    public static final UseDTO buildUseDTO(UseCacheLocal useCacheLocal) {
        AreaValue areaValue = null;
        if (useCacheLocal.getArea() != null) {
            areaValue = useCacheLocal.getArea().getAreaValue();
        }
        return new UseDTO(useCacheLocal.getUseCacheValue(), DTOFactory.buildUnitDTO(useCacheLocal.getUnitModel()), useCacheLocal.getUseUser().getUseUserValue(), useCacheLocal.getUseGroup().getUseGroupValue(), areaValue, null);
    }

    public static final UseDTO buildUseDTO(UnitModelLocal unitModelLocal, UseUserValue useUserValue, UseGroupValue useGroupValue, long beginTime, long endTime, long beginReceiveTime, long endReceiveTime, AreaValue beginArea, AreaValue endArea) {
        return new UseDTO(DTOFactory.buildUnitDTO(unitModelLocal), useUserValue, useGroupValue, beginArea, endArea, beginTime, endTime, beginReceiveTime, endReceiveTime);
    }

    public static final KeepAliveDTO buildKeepAliveDTO(UnitModelLocal untModelLocal, long createTimeStamp, long receiveTimeStamp, Boolean timedOut) {
        return new KeepAliveDTO(DTOFactory.buildUnitDTO(untModelLocal), createTimeStamp, receiveTimeStamp, timedOut);
    }

    public static final ReportBaseDTO buildScheduledReportDTO(ScheduledReportLocal report) {
        UnitReporBaseDTO dto = null;
        ScheduledReportValue value = report.getScheduledReportValue();
        String design = value.getReportDesign();
        String reportType = value.getReportType();
        String emails = value.getEmails();
        Locale locale = new Locale(value.getLocale());
        OutputFormat outPutFormat = OutputFormat.valueOf(value.getOutputFormat());
        PageFormat pageFormat = null;
        if (value.getPageFormat() != null) {
            pageFormat = PageFormat.valueOf(value.getPageFormat());
        }
        String reportName = value.getReportName();
        long createTime = value.getCreateTime();
        TimeInterval timeInterval = TimeInterval.valueOf(value.getTimeInterval());
        HashMap<String, String> reportParamsMap = new HashMap<String, String>();
        String reportParameters = value.getReportParameters();
        String[] params = reportParameters.split(";");
        for (int i = 0; i < params.length; ++i) {
            String[] values = params[i].split("=");
            String paramName = values[0];
            String paramValue = values[1];
            reportParamsMap.put(paramName, paramValue);
        }
        ArrayList<AccountValue> accountValues = new ArrayList<AccountValue>();
        Collection accounts = report.getAccounts();
        for (AccountLocal local : accounts) {
            accountValues.add(local.getAccountValue());
        }
        if (reportType.equalsIgnoreCase("status")) {
            dto = new StatusReportDTO(reportType, reportName, design, reportParamsMap, outPutFormat, pageFormat, locale, timeInterval, accountValues, emails, createTime);
        } else if (reportType.equalsIgnoreCase("notification")) {
            dto = new NotificationReportDTO(reportType, reportName, design, reportParamsMap, outPutFormat, pageFormat, locale, timeInterval, accountValues, emails, createTime);
        } else if (reportType.equalsIgnoreCase("useUser")) {
            dto = new UseUserReportDTO(reportType, reportName, design, reportParamsMap, outPutFormat, pageFormat, locale, timeInterval, accountValues, emails, createTime);
        } else if (reportType.equalsIgnoreCase("position")) {
            dto = new PositionReportDTO(reportType, reportName, design, reportParamsMap, outPutFormat, pageFormat, locale, timeInterval, accountValues, emails, createTime);
        } else if (reportType.equalsIgnoreCase("peakModel")) {
            dto = new PeakModelReportDTO(reportType, reportName, design, reportParamsMap, outPutFormat, pageFormat, locale, timeInterval, accountValues, emails, createTime);
        }
        if (dto == null) {
            dto = new NotificationReportDTO(reportType, reportName, design, reportParamsMap, outPutFormat, pageFormat, locale, timeInterval, accountValues, emails, createTime);
        }
        dto.setId(report.getId());
        return dto;
    }

    public static final PositionDTO buildPositionDTO(UnitModelLocal unitModelLocal, CurrentGdataCacheLocal currentGdataCacheLocal, long selectionBeginTime, long selectionEndTime, boolean correctTimes) {
        AreaValue areaValue;
        CurrentGdataCacheValue value = currentGdataCacheLocal.getCurrentGdataCacheValue();
        AreaLocal areaLocal = currentGdataCacheLocal.getAreaLocal();
        String areaName = "";
        String areaDesc = "";
        if (areaLocal != null && (areaValue = areaLocal.getAreaValue()) != null) {
            areaName = areaValue.getArea();
            areaDesc = areaValue.getDescription();
        }
        PositionDTO dto = new PositionDTO(DTOFactory.buildUnitDTO(unitModelLocal), value.getCreateTime(), System.currentTimeMillis(), value.getBeginReceiveTime(), 0L, value.getTrusted(), value.getGgaRec(), value.getLatMSEC(), value.getLongMSEC(), value.getRmcRec(), value.getReason(), areaName, areaDesc);
        if (correctTimes) {
            dto.correctTimes(selectionBeginTime, selectionEndTime);
        }
        return dto;
    }

    public static final PositionDTO buildPostionDTO(GdataHistoryLocal gdataHistoryLocal, long selectionBeginTime, long selectionEndTime, boolean correctTimes) {
        AreaValue areaValue;
        GdataHistoryValue value = gdataHistoryLocal.getGdataHistoryValue();
        AreaLocal areaLocal = gdataHistoryLocal.getAreaLocal();
        String areaName = "";
        String areaDesc = "";
        if (areaLocal != null && (areaValue = areaLocal.getAreaValue()) != null) {
            areaName = areaValue.getArea();
            areaDesc = areaValue.getDescription();
        }
        PositionDTO dto = new PositionDTO(DTOFactory.buildUnitDTO(gdataHistoryLocal.getUnitModel()), value, areaName, areaDesc);
        if (correctTimes) {
            dto.correctTimes(selectionBeginTime, selectionEndTime);
        }
        return dto;
    }

    public static final NotificationDTO buildNotificationDTO(CurrentNotifyCacheLocal currentNotifyCacheLocal) {
        UseUserValue useValue = null;
        UseUserLocal useUserLocal = currentNotifyCacheLocal.getUseUser();
        if (useUserLocal != null) {
            useValue = useUserLocal.getUseUserValue();
        }
        AreaValue areaValue = null;
        AreaLocal areaLocal = currentNotifyCacheLocal.getArea();
        if (areaLocal != null) {
            areaValue = areaLocal.getAreaValue();
        }
        return DTOFactory.buildNotificationDTO(currentNotifyCacheLocal.getUnitModel(), currentNotifyCacheLocal.getCurrentNotifyCacheValue(), useValue, areaValue);
    }

    public static final NotificationDTO buildNotificationDTO(NotifyHistoryLocal notifyHistoryLocal) {
        UseUserValue useValue = null;
        UseUserLocal useUserLocal = notifyHistoryLocal.getUseUser();
        if (useUserLocal != null) {
            useValue = useUserLocal.getUseUserValue();
        }
        AreaValue areaValue = null;
        AreaLocal areaLocal = notifyHistoryLocal.getArea();
        if (areaLocal != null) {
            areaValue = areaLocal.getAreaValue();
        }
        return DTOFactory.buildNotificationDTO(notifyHistoryLocal.getUnitModel(), notifyHistoryLocal.getNotifyHistoryValue(), useValue, areaValue);
    }

    public static final NotificationDTO buildNotificationDTO(UnitModelLocal unitModel, CurrentNotifyCacheValue value, UseUserValue useValue, AreaValue areaValue) {
        return new NotificationDTO(DTOFactory.buildUnitDTO(unitModel), value.getMessageId(), value.getCreateTime(), value.getReceiveTime(), value.getRemark(), useValue, areaValue);
    }

    public static final NotificationDTO buildNotificationDTO(UnitModelLocal unitModel, NotifyHistoryValue value, UseUserValue useValue, AreaValue areaValue) {
        return new NotificationDTO(DTOFactory.buildUnitDTO(unitModel), value.getMessageId(), value.getCreateTime(), value.getReceiveTime(), value.getRemark(), useValue, areaValue);
    }

    public static final AccidentReconstructionDTO buildAccidentReconstructionDTO(UnitModelLocal unitModel, NotificationDTO notificationDTO, StateDTO stateDTO, PositionDTO positionDTO, long totalRuntimeHours) {
        long stateId = -1L;
        long stateBeg = 0L;
        long stateEnd = 0L;
        if (stateDTO != null) {
            stateId = stateDTO.getStateId();
            stateBeg = stateDTO.getBeginTime();
            stateEnd = stateDTO.getEndTime();
        }
        int speedKmh = 0;
        int speedMph = 0;
        int direction = 0;
        long gdataBeg = 0L;
        long gdataEnd = 0L;
        String gdataArea = "";
        if (positionDTO != null) {
            speedKmh = positionDTO.getSpeedKmh();
            speedMph = positionDTO.getSpeedMph();
            direction = positionDTO.getCourse();
            gdataBeg = positionDTO.getBeginTime();
            gdataEnd = positionDTO.getEndTime();
            gdataArea = positionDTO.getArea();
        }
        return new AccidentReconstructionDTO(DTOFactory.buildUnitDTO(unitModel), notificationDTO.getMessageId(), notificationDTO.getCreateTime(), notificationDTO.getBeginReceiveTime(), notificationDTO.getRemark(), notificationDTO.getUseUserName(), notificationDTO.getUseUserPersonalNumber(), notificationDTO.getUseUserKey(), notificationDTO.getArea(), notificationDTO.getAreaDescr(), stateId, stateBeg, stateEnd, speedKmh, speedMph, direction, totalRuntimeHours, gdataArea, gdataBeg, gdataEnd);
    }

    public static final GseAvailabilityDTO buildGseAvailabilityDTO(UnitModelLocal unitModel, FisFlightCacheValue flightValue, PositionDTO posDTO, Long nextTime) {
        return new GseAvailabilityDTO(DTOFactory.buildUnitDTO(unitModel), flightValue, posDTO, nextTime);
    }

    public static final StatusDurationsDTO buildStatusDurationsDTO(UnitModelLocal unitModel, Long stateModelId, long beginTime) {
        return new StatusDurationsDTO(DTOFactory.buildUnitDTO(unitModel), stateModelId, beginTime);
    }

    public static final UnitDTO buildUnitDTO(UnitIdentityLocal unitIdentity) {
        UnitIdentityValue unitIdentityValue = unitIdentity.getUnitIdentityValue();
        UnitModelLocal unitModelLocal = unitIdentity.getUnitModel();
        UnitModelValue unitModelValue = unitModelLocal.getUnitModelValue();
        UnitTypeIdentityValue unitTypeIdentityValue = null;
        if (unitModelValue.getBasic()) {
            unitTypeIdentityValue = unitModelLocal.getUnitTypeIdentity().getUnitTypeIdentityValue();
        }
        return new UnitDTO(unitModelValue, unitIdentityValue, unitTypeIdentityValue);
    }

    public static final GseProductivityDTO buildGseProductivityDTO(UnitModelLocal unitModel, FlightRotationDTO rotation, ArrayList<StateDTOList> arrStateDTOList, Long duration2012, Long duration2013) {
        return new GseProductivityDTO(DTOFactory.buildUnitDTO(unitModel), rotation, arrStateDTOList, duration2012, duration2013);
    }

    public static final FlightDTO buildFlightDTO(Object flight, int gseArrivalSetupStartTime, int gseArrivalSetupEndTimePax, int gseArrivalSetupEndTimeCgo, int gseDepartureSetupStartTime, int gseDepartureSetupEndTime) {
        FlightDTO flightDTO = null;
        if (flight instanceof FisFlightCacheLocal) {
            FisFlightCacheLocal loc = (FisFlightCacheLocal)flight;
            flightDTO = DTOFactory.buildFlightDTO(loc.getFisFlightCacheValue(), gseArrivalSetupStartTime, gseArrivalSetupEndTimePax, gseArrivalSetupEndTimeCgo, gseDepartureSetupStartTime, gseDepartureSetupEndTime);
        } else if (flight instanceof FisFlightHistoryLocal) {
            FisFlightHistoryLocal loc = (FisFlightHistoryLocal)flight;
            flightDTO = DTOFactory.buildFlightDTO(loc.getFisFlightHistoryValue(), gseArrivalSetupStartTime, gseArrivalSetupEndTimePax, gseArrivalSetupEndTimeCgo, gseDepartureSetupStartTime, gseDepartureSetupEndTime);
        }
        return flightDTO;
    }

    public static final FlightDTO buildFlightDTO(FisFlightCacheValue f, int gseArrivalSetupStartTime, int gseArrivalSetupEndTimePax, int gseArrivalSetupEndTimeCgo, int gseDepartureSetupStartTime, int gseDepartureSetupEndTime) {
        return new FlightDTO(f.getUniqueFlightNumber(), f.getRotationKey(), f.getArrivalDeparture(), f.getFlightNumberSemantics(), f.getFlightNature(), f.getScheduledTimeOfArrival(), f.getEstimatedTimeOfArrival(), f.getLandingTime(), f.getOnBlockTime(), f.getScheduledTimeOfDeparture(), f.getEstimatedTimeOfDeparture(), f.getOffBlockTime(), f.getTakeOffTime(), gseArrivalSetupStartTime, gseArrivalSetupEndTimePax, gseArrivalSetupEndTimeCgo, gseDepartureSetupStartTime, gseDepartureSetupEndTime);
    }

    public static final FlightDTO buildFlightDTO(FisFlightHistoryValue f, int gseArrivalSetupStartTime, int gseArrivalSetupEndTimePax, int gseArrivalSetupEndTimeCgo, int gseDepartureSetupStartTime, int gseDepartureSetupEndTime) {
        return new FlightDTO(f.getUniqueFlightNumber(), f.getRotationKey(), f.getArrivalDeparture(), f.getFlightNumberSemantics(), f.getFlightNature(), f.getScheduledTimeOfArrival(), f.getEstimatedTimeOfArrival(), f.getLandingTime(), f.getOnBlockTime(), f.getScheduledTimeOfDeparture(), f.getEstimatedTimeOfDeparture(), f.getOffBlockTime(), f.getTakeOffTime(), gseArrivalSetupStartTime, gseArrivalSetupEndTimePax, gseArrivalSetupEndTimeCgo, gseDepartureSetupStartTime, gseDepartureSetupEndTime);
    }

    public static final FlightRotationDTO buildFlightRotationDTO(ArrayList<FlightDTO> rotation) {
        return new FlightRotationDTO(rotation);
    }

    public static final RunTimeDurationsDTO buildRunTimeDurationsDTO(UnitModelLocal unitModel, long beginTime) {
        return new RunTimeDurationsDTO(DTOFactory.buildUnitDTO(unitModel), beginTime, unitModel.getUnitModelValue().getOperativeTimeOffset());
    }

    public static final StateAssignmentDTO buildStateAssignmentDTO(FlightRotationDTO rotation, Object stateAssignment) {
        StateAssignmentDTO assignmentDTO = null;
        if (stateAssignment instanceof CurrentStateCacheLocal) {
            CurrentStateCacheLocal loc = (CurrentStateCacheLocal)stateAssignment;
            assignmentDTO = DTOFactory.buildStateAssignmentDTO(rotation, DTOFactory.buildStateDTO(loc.getUnitModel(), loc.getCurrentStateCacheValue()));
        } else if (stateAssignment instanceof StateHistoryLocal) {
            StateHistoryLocal loc = (StateHistoryLocal)stateAssignment;
            assignmentDTO = DTOFactory.buildStateAssignmentDTO(rotation, DTOFactory.buildStateDTO(loc.getUnitModel(), loc.getStateHistoryValue()));
        }
        return assignmentDTO;
    }

    public static final StateAssignmentDTO buildStateAssignmentDTO(FlightRotationDTO rotation, StateDTO stateDTO) {
        return new StateAssignmentDTO(rotation, stateDTO);
    }
}

