/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.admin;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ejb.SessionBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionUpdateToolsBean
extends BaseSessionBean
implements SessionBean {
    public void ejbCreate() {
    }

    public Collection getDiffOfCollection(Collection col1, Collection col2) {
        ArrayList col3 = new ArrayList();
        col3.addAll(col1);
        col1.removeAll(col2);
        col2.removeAll(col3);
        col1.addAll(col2);
        return col1;
    }

    public String[] getDifferentUsers(Collection<AccountValue> currentUsers, String[] newUserList) {
        ArrayList<String> currentUserNames = new ArrayList<String>();
        ArrayList<String> newUserNames = new ArrayList<String>(Arrays.asList(newUserList));
        for (AccountValue account : currentUsers) {
            currentUserNames.add(account.getUsername());
        }
        Collection myCollection = this.getDiffOfCollection(currentUserNames, newUserNames);
        return myCollection.toArray(new String[myCollection.size()]);
    }

    public String[] getDifferentUsersByAccountValueList(List<AccountValue> currentUsers, List<AccountValue> newAccounts) {
        ArrayList<String> currentUserNames = new ArrayList<String>(currentUsers.size());
        ArrayList<String> newUserNames = new ArrayList<String>(newAccounts.size());
        for (AccountValue account : currentUsers) {
            currentUserNames.add(account.getUsername());
        }
        for (AccountValue account : newAccounts) {
            newUserNames.add(account.getUsername());
        }
        Collection myCollection = this.getDiffOfCollection(currentUserNames, newUserNames);
        return myCollection.toArray(new String[myCollection.size()]);
    }

    public List<String> getAffectedUsersByRolesChanges(Map<String, String[]> oldAccounts, Map<String, String[]> newAccounts, String[] usernames) {
        ArrayList<String> affectedUsers = new ArrayList<String>(usernames.length);
        for (int i = 0; i < usernames.length; ++i) {
            ArrayList<String> newRolesList;
            String userName = usernames[i];
            String[] oldRoles = oldAccounts.get(userName);
            String[] newRoles = newAccounts.get(userName);
            ArrayList<String> oldRolesList = new ArrayList<String>(Arrays.asList(oldRoles));
            if (!this.getDiffOfCollection(oldRolesList, newRolesList = new ArrayList<String>(Arrays.asList(newRoles))).toString().contains("section.airportmap")) continue;
            affectedUsers.add(userName);
        }
        return affectedUsers;
    }

    public List<String> getAffectedUsersByVisibleUnitChanges(Map<String, HashSet<Long>> oldUnitPermissions, Map<String, HashSet<Long>> newUnitPermissions, String[] usernames) {
        ArrayList<String> affectedUsers = new ArrayList<String>(usernames.length);
        for (int i = 0; i < usernames.length; ++i) {
            HashSet<Long> newUnitIDs;
            String userName = usernames[i];
            HashSet<Long> oldUnitIDs = oldUnitPermissions.get(userName);
            if (this.getDiffOfCollection(oldUnitIDs, newUnitIDs = newUnitPermissions.get(userName)).size() == 0) continue;
            affectedUsers.add(userName);
        }
        return affectedUsers;
    }

    public List<AccountValue> getSameAccountInBothLists(List<String> userNames, List<AccountValue> accounts) {
        ArrayList<AccountValue> filteredAccounts = new ArrayList<AccountValue>();
        for (AccountValue account : accounts) {
            if (!userNames.contains(account.getUsername())) continue;
            filteredAccounts.add(account);
        }
        return filteredAccounts;
    }

    public String[] getUserNames(List<AccountValue> accounts) {
        int count = accounts.size();
        String[] affectedUserNames = new String[count];
        for (int i = 0; i != count; ++i) {
            affectedUserNames[i] = accounts.get(i).getUsername();
        }
        return affectedUserNames;
    }
}

