/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.admin;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.observable.wrapper.PermissionVO;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountValue;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionUpdateNotifyBean
extends BaseSessionBean
implements SessionBean {
    private InformantFacadeLocal informantFacadeLocal = null;
    private static final Log log = LogFactory.getLog(PermissionUpdateNotifyBean.class);

    public void ejbCreate() {
        try {
            this.informantFacadeLocal = InformantFacadeUtil.getLocalHome().create();
        }
        catch (CreateException e) {
            log.error((Object)"PermissionUpdateViaJMS runs into CreateException: ", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"PermissionUpdateViaJMS runs into NamingException: ", (Throwable)e);
        }
    }

    public void sendPermissionChangedJMSMessage(List<AccountValue> accounts) {
        log.debug((Object)"Permissions changed");
        if (accounts != null) {
            List<PermissionVO> permissionVOList = this.getPermissionVOList(accounts, false, false);
            this.sendMessage(permissionVOList);
        } else {
            log.error((Object)"List 'accounts' is null!");
        }
    }

    public void sendPermissionChangedJMSMessageByUserNames(List<String> usernames) {
        log.debug((Object)"Permissions changed");
        if (usernames != null) {
            List<PermissionVO> permissionVOList = this.getPermissionVOListByUserNames(usernames, false, false);
            this.sendMessage(permissionVOList);
        } else {
            log.error((Object)"List 'usernames' is null!");
        }
    }

    public void sendUserDeletedJMSMessage(List<AccountValue> accounts) {
        log.debug((Object)"Permissions changed: User deleted!");
        if (accounts != null) {
            List<PermissionVO> permissionVOList = this.getPermissionVOList(accounts, true, false);
            this.sendMessage(permissionVOList);
        } else {
            log.error((Object)"List 'accounts' is null!");
        }
    }

    public void sendRoleChangedJMSMessage(List<AccountValue> accounts) {
        log.debug((Object)"Permissions changed: Role changed!");
        if (accounts != null) {
            List<PermissionVO> permissionVOList = this.getPermissionVOList(accounts, false, true);
            this.sendMessage(permissionVOList);
        } else {
            log.error((Object)"List 'accounts' is null!");
        }
    }

    public void sendRoleChangedJMSMessageByUserNames(List<String> usernames) {
        log.debug((Object)"Permissions changed: Role changed!");
        if (usernames != null) {
            List<PermissionVO> permissionVOList = this.getPermissionVOListByUserNames(usernames, false, true);
            this.sendMessage(permissionVOList);
        } else {
            log.error((Object)"List 'usernames' is null!");
        }
    }

    public void sendUserPwChangedJMSMessage(AccountValue account) {
        log.debug((Object)"Permissions changed: Pw changed!");
        if (account != null) {
            PermissionVO permissionVO = new PermissionVO();
            permissionVO.setUserName(account.getUsername());
            permissionVO.setUserDeleted(false);
            permissionVO.setRoleChanged(false);
            permissionVO.setUserPwChanged(true);
            this.sendMessage(permissionVO);
        } else {
            log.error((Object)"'accounts' is null!");
        }
    }

    private List<PermissionVO> getPermissionVOList(List<AccountValue> accounts, boolean deleted, boolean roleChanged) {
        ArrayList<PermissionVO> permissionVOList = new ArrayList<PermissionVO>();
        for (AccountValue accountValue : accounts) {
            PermissionVO permissionVO = new PermissionVO();
            permissionVO.setUserName(accountValue.getUsername());
            permissionVO.setUserDeleted(deleted);
            permissionVO.setRoleChanged(roleChanged);
            permissionVO.setUserPwChanged(false);
            permissionVOList.add(permissionVO);
            log.debug((Object)("------> " + accountValue.getUsername()));
        }
        return permissionVOList;
    }

    private List<PermissionVO> getPermissionVOListByUserNames(List<String> userNames, boolean deleted, boolean roleChanged) {
        ArrayList<PermissionVO> permissionVOList = new ArrayList<PermissionVO>();
        for (String userName : userNames) {
            PermissionVO permissionVO = new PermissionVO();
            permissionVO.setUserName(userName);
            permissionVO.setUserDeleted(deleted);
            permissionVO.setRoleChanged(roleChanged);
            permissionVO.setUserPwChanged(false);
            permissionVOList.add(permissionVO);
            log.debug((Object)("------> " + userName));
        }
        return permissionVOList;
    }

    public void sendAirportMapFlagChangedMessage(Long unitID, boolean airportMapVisibleHasBeenSet) {
        PermissionVO permissionVO = new PermissionVO();
        permissionVO.setAirportMapVisible(unitID, airportMapVisibleHasBeenSet);
        permissionVO.setUserName("");
        permissionVO.setUserDeleted(false);
        permissionVO.setRoleChanged(false);
        permissionVO.setUserPwChanged(false);
        this.sendMessage(permissionVO);
    }

    private void sendMessage(List<PermissionVO> permissionVOList) {
        SerializableEventWrapper eventWrapper = new SerializableEventWrapper();
        eventWrapper.set_typeOfEvent("ViewPermissionUpdateMessage");
        eventWrapper.setSystemTime(System.currentTimeMillis());
        eventWrapper.setPermissionVOList(permissionVOList);
        this.informantFacadeLocal.notify(eventWrapper, "ViewPermissionUpdateMessage");
    }

    private void sendMessage(PermissionVO permissionVO) {
        ArrayList<PermissionVO> permissionVOList = new ArrayList<PermissionVO>();
        permissionVOList.add(permissionVO);
        this.sendMessage(permissionVOList);
    }
}

