/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.statesum;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryUtil;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryLocal;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryLocalHome;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryUtil;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StateSummaryFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(StateSummaryFacadeBean.class);
    private StateSummaryLocalHome stateSummaryHome;
    private GrouphistoryLocalHome grouphistoryHome;

    public void ejbCreate() throws CreateException {
        try {
            this.stateSummaryHome = StateSummaryUtil.getLocalHome();
            this.grouphistoryHome = GrouphistoryUtil.getLocalHome();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public Set<StateSummaryValue> getStateSummaryValues(long unitId, int periodType, long beginTime, long endTime) {
        HashSet<StateSummaryValue> stateSummaryValues = new HashSet<StateSummaryValue>();
        try {
            Collection stateSummaryLocals = this.stateSummaryHome.findByUnitIdPeriodTypePeriod(unitId, periodType, beginTime, endTime);
            for (StateSummaryLocal stateSummaryLocal : stateSummaryLocals) {
                stateSummaryValues.add(stateSummaryLocal.getStateSummaryValue());
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return stateSummaryValues;
    }

    public Set<StateSummaryValue> getStateSummaryValues(long unitId, int periodType, long stateModelId, long beginTime, long endTime) {
        HashSet<StateSummaryValue> stateSummaryValues = new HashSet<StateSummaryValue>();
        try {
            Collection stateSummaryLocals = this.stateSummaryHome.findByUnitIdPeriodTypeStateModelIdPeriod(unitId, periodType, stateModelId, beginTime, endTime);
            for (StateSummaryLocal stateSummaryLocal : stateSummaryLocals) {
                stateSummaryValues.add(stateSummaryLocal.getStateSummaryValue());
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return stateSummaryValues;
    }

    public Set<StateSummaryValue> getStateSummaryValues(long unitId, int periodType, long stateModelId, long stateId, long beginTime, long endTime) {
        HashSet<StateSummaryValue> stateSummaryValues = new HashSet<StateSummaryValue>();
        try {
            Collection stateSummaryLocals = this.stateSummaryHome.findByUnitIdPeriodTypeStateModelIdStateIdPeriod(unitId, periodType, stateModelId, stateId, beginTime, endTime);
            for (StateSummaryLocal stateSummaryLocal : stateSummaryLocals) {
                stateSummaryValues.add(stateSummaryLocal.getStateSummaryValue());
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return stateSummaryValues;
    }

    public long getStateSummaryDuration(long unitId, int periodType, long stateModelId, long stateId, long beginTime, long endTime) {
        long duration = this.stateSummaryHome.getSumDuration(unitId, periodType, stateModelId, stateId, beginTime, endTime);
        return duration;
    }

    public long getMaxBeginTime(long unitId, int periodType) {
        return this.stateSummaryHome.getMaxBeginTime(unitId, periodType);
    }

    public long getMinBeginTime(long unitId, int periodType) {
        return this.stateSummaryHome.getMinBeginTime(unitId);
    }

    public boolean insertStateSummaryValue(StateSummaryValue stateSummaryValue) {
        try {
            StateSummaryLocal summary = this.stateSummaryHome.create(stateSummaryValue);
            summary.setGroupHistoryId(this.grouphistoryHome.getGrouphistoryForUnit(stateSummaryValue.getUnitId(), stateSummaryValue.getBeginTime()));
        }
        catch (Exception e) {
            log.error((Object)"runs into", (Throwable)e);
            return false;
        }
        return true;
    }
}

