/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.statesum;

import de.proveo.wwt.logic.app.keepalive.event.KeepAliveEvent;
import de.proveo.wwt.logic.ejb.dataOut.raw.StateStamp;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.ejb.state.StateOutFacadeLocal;
import de.proveo.wwt.logic.ejb.state.StateOutFacadeUtil;
import de.proveo.wwt.logic.ejb.state.exception.NoStateFoundException;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryFacadeLocal;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryFacadeUtil;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryValue;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateSummarizeBean
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 2496601723151295734L;
    private static final Log log = LogFactory.getLog(StateSummarizeBean.class);
    public static final String CONFIG_PERIOD_TYPES = "statesummary.period.types";
    public static final String CONFIG_EXCLUSION_STATES = "statesummary.exclusion.states";
    public static final String DEF_PERIOD_TYPES = "0";
    public static final String DEF_EXCLUSION_STATES = "-1";
    public static final String CONFIG_PARAM_DELIMITER = ",";
    private ConfigurationLocal config;
    private StateSummaryFacadeLocal stateSummaryFacade;
    private StateOutFacadeLocal stateOutFacade;
    private Set<Long> exclusionStates;
    private int[] periodTypes;

    public void ejbCreate() {
        try {
            this.config = ConfigurationUtil.getLocalHome().create();
            this.stateSummaryFacade = StateSummaryFacadeUtil.getLocalHome().create();
            this.stateOutFacade = StateOutFacadeUtil.getLocalHome().create();
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        this.initConfig();
    }

    private void initConfig() {
        String periodTypesString = this.config.getParameter(CONFIG_PERIOD_TYPES, DEF_PERIOD_TYPES);
        Collection<String> periodTypeTokens = this.getTokensFromConfigurationString(periodTypesString, CONFIG_PARAM_DELIMITER);
        Iterator<String> iter = periodTypeTokens.iterator();
        int[] tempPeriodTypes = new int[periodTypeTokens.size()];
        int i = 0;
        while (iter.hasNext()) {
            String periodTypeString = iter.next();
            try {
                int periodType;
                tempPeriodTypes[i] = periodType = Integer.valueOf(periodTypeString).intValue();
                ++i;
            }
            catch (NumberFormatException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        this.periodTypes = new int[i];
        System.arraycopy(tempPeriodTypes, 0, this.periodTypes, 0, i);
        if (log.isDebugEnabled()) {
            log.debug((Object)("got " + i + " periodTypes from configuration"));
        }
        this.exclusionStates = new HashSet<Long>();
        String exclusionStatesString = this.config.getParameter(CONFIG_EXCLUSION_STATES, DEF_EXCLUSION_STATES);
        Collection<String> exclusionStateTokens = this.getTokensFromConfigurationString(exclusionStatesString, CONFIG_PARAM_DELIMITER);
        for (String exclusionState : exclusionStateTokens) {
            try {
                this.exclusionStates.add(Long.valueOf(exclusionState));
            }
            catch (NumberFormatException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("got " + this.exclusionStates.size() + " exclusionStates from configuration -> " + this.exclusionStates));
        }
    }

    public void ejbRemove() throws EJBException {
    }

    public void setMessageDrivenContext(MessageDrivenContext ctx) throws EJBException {
    }

    public void onMessage(Message msg) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"onMessage(msg)");
        }
        long startTime = System.currentTimeMillis();
        if (msg instanceof ObjectMessage) {
            try {
                Serializable obj = ((ObjectMessage)msg).getObject();
                if (obj instanceof KeepAliveEvent) {
                    this.handleEvent((KeepAliveEvent)obj);
                }
            }
            catch (JMSException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        } else {
            log.error((Object)("recieved unknown message: " + msg));
        }
        if (log.isDebugEnabled()) {
            long duration = System.currentTimeMillis() - startTime;
            log.debug((Object)("StateSummarizeBean duration: " + duration + " ms"));
        }
    }

    private void handleEvent(KeepAliveEvent keepAliveEvent) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("handleEvent() - " + keepAliveEvent));
        }
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.periodTypes.length; ++i) {
            this.summarizeStates(keepAliveEvent, this.periodTypes[i]);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("handleEvent() - duration " + (System.currentTimeMillis() - startTime) + " ms"));
        }
    }

    private void summarizeStates(KeepAliveEvent keepAliveEvent, int periodType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("summarizeStates('" + keepAliveEvent + "', '" + periodType + "')"));
        }
        long unitId = keepAliveEvent.getUnitId();
        long eventTime = keepAliveEvent.getCreateTimestamp();
        long currentPeriodTime = this.rollPeriod(eventTime, -1, periodType);
        long maxBeginTime = this.stateSummaryFacade.getMaxBeginTime(unitId, periodType);
        if (maxBeginTime == 0L) {
            maxBeginTime = this.rollPeriod(currentPeriodTime, -1, periodType);
        }
        if (currentPeriodTime == maxBeginTime) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("StateSummary is already up to date for unitId '" + unitId + "', beginTime=" + currentPeriodTime + " and period type '" + periodType + "'"));
            }
            return;
        }
        long begin = this.rollPeriod(maxBeginTime, 1, periodType);
        long end = this.rollPeriod(begin, 1, periodType);
        while (begin <= currentPeriodTime) {
            this.writeStateSummary(unitId, periodType, begin, end);
            begin = end;
            end = this.rollPeriod(begin, 1, periodType);
        }
    }

    private void writeStateSummary(long unitId, int periodType, long begin, long end) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("writeStateSummary('" + unitId + "', '" + periodType + "', '" + begin + "', '" + end + "')"));
        }
        long startTime = System.currentTimeMillis();
        Set stateEntries = this.getStateEntries(unitId, begin, end, periodType);
        Map<Object, Object> stateModels = new HashMap();
        switch (periodType) {
            case 0: {
                log.debug((Object)("periodType: " + periodType + " -> this.summarizeStateStamps()"));
                stateModels = this.summarizeStateStamps(unitId, periodType, begin, stateEntries);
                break;
            }
            default: {
                log.debug((Object)("periodType: " + periodType + " -> this.summarizeStateSummaryValues"));
                stateModels = this.summarizeStateSummaryValues(unitId, periodType, begin, stateEntries);
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeStateSummary duration " + duration + " ms for summarizing " + stateEntries.size() + " StateStamps for unitId " + unitId));
            startTime = System.currentTimeMillis();
        }
        Iterator<Object> iter = stateModels.keySet().iterator();
        while (iter.hasNext()) {
            long stateModelId = (Long)iter.next();
            HashMap stateModel = (HashMap)stateModels.get(stateModelId);
            for (Long stateId : stateModel.keySet()) {
                if (this.exclusionStates.contains(stateId)) continue;
                StateSummaryValue value = (StateSummaryValue)stateModel.get(stateId);
                this.stateSummaryFacade.insertStateSummaryValue(value);
            }
        }
        if (log.isDebugEnabled()) {
            duration = System.currentTimeMillis() - startTime;
            log.debug((Object)("writeStateSummary duration " + duration + " ms for creating " + stateEntries.size() + " Entities for unitId " + unitId));
        }
    }

    private Set getStateEntries(long unitId, long begin, long end, int periodType) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("getStateEntries('" + unitId + "', '" + begin + "', '" + end + "', '" + periodType + "');"));
        }
        Set<StateSummaryValue> unitEvents = new HashSet<StateSummaryValue>();
        switch (periodType) {
            case 0: {
                try {
                    unitEvents = this.stateOutFacade.getUnitEvents(unitId, begin, end);
                }
                catch (NoStateFoundException e) {
                    log.error((Object)"runs into", (Throwable)e);
                }
                break;
            }
            default: {
                unitEvents.addAll(this.stateSummaryFacade.getStateSummaryValues(unitId, 0, begin, end));
            }
        }
        return unitEvents;
    }

    private Map<Long, Map<Long, StateSummaryValue>> summarizeStateStamps(long unitId, int periodType, long begin, Set<StateStamp> stateStamps) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("summarizeStateStamps('" + unitId + "', '" + periodType + "', '" + begin + "', 'stateStamps');"));
        }
        HashMap<Long, Map<Long, StateSummaryValue>> stateModels = new HashMap<Long, Map<Long, StateSummaryValue>>();
        for (StateStamp stateStamp : stateStamps) {
            StateSummaryValue summarizedStateSummaryValue;
            HashMap stateModel;
            long currentStateModelId = stateStamp.getStateModelId();
            if (stateModels.containsKey(currentStateModelId)) {
                stateModel = (HashMap)stateModels.get(currentStateModelId);
            } else {
                stateModel = new HashMap();
                stateModels.put(currentStateModelId, stateModel);
            }
            long currentStateId = stateStamp.getStateId();
            if (stateModel.containsKey(currentStateId)) {
                summarizedStateSummaryValue = (StateSummaryValue)stateModel.get(currentStateId);
            } else {
                summarizedStateSummaryValue = new StateSummaryValue(unitId, periodType, currentStateModelId, currentStateId, begin, 0L);
                stateModel.put(currentStateId, summarizedStateSummaryValue);
            }
            summarizedStateSummaryValue.setDuration(summarizedStateSummaryValue.getDuration() + (stateStamp.getEnd() - stateStamp.getBegin()));
        }
        return stateModels;
    }

    private Map<Long, Map<Long, StateSummaryValue>> summarizeStateSummaryValues(long unitId, int periodType, long begin, Set<StateSummaryValue> stateSummaryValues) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("summarizeStateSummaryValues('" + unitId + "', '" + periodType + "', '" + begin + "', 'stateSummaryValues');"));
        }
        HashMap<Long, Map<Long, StateSummaryValue>> stateModels = new HashMap<Long, Map<Long, StateSummaryValue>>();
        for (StateSummaryValue singleStateSummaryValue : stateSummaryValues) {
            StateSummaryValue summarizedStateSummaryValue;
            HashMap stateModel;
            long currentStateModelId = singleStateSummaryValue.getStateModelId();
            if (stateModels.containsKey(currentStateModelId)) {
                stateModel = (HashMap)stateModels.get(currentStateModelId);
            } else {
                stateModel = new HashMap();
                stateModels.put(currentStateModelId, stateModel);
            }
            long currentStateId = singleStateSummaryValue.getStateId();
            if (stateModel.containsKey(currentStateId)) {
                summarizedStateSummaryValue = (StateSummaryValue)stateModel.get(currentStateId);
            } else {
                summarizedStateSummaryValue = new StateSummaryValue(unitId, periodType, currentStateModelId, currentStateId, begin, 0L);
                stateModel.put(currentStateId, summarizedStateSummaryValue);
            }
            summarizedStateSummaryValue.setDuration(summarizedStateSummaryValue.getDuration() + singleStateSummaryValue.getDuration());
        }
        return stateModels;
    }

    private long rollPeriod(long time, int amount, int periodType) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (periodType == 0) {
            cal.add(5, amount);
        } else if (periodType == 1) {
            cal.add(3, amount);
            cal.set(7, 2);
        } else if (periodType == 2) {
            cal.add(2, amount);
            cal.set(5, 1);
        } else if (periodType == 3) {
            cal.add(1, amount);
            cal.set(2, 0);
            cal.set(5, 1);
        } else {
            log.error((Object)("unknown period type '" + periodType + "'"));
        }
        return cal.getTimeInMillis();
    }

    private Collection<String> getTokensFromConfigurationString(String string, String delim) {
        Vector<String> tokens = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(string, delim);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }
}

