/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.state;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.helper.BaseHelperUtil;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.app.state.event.StateEvent;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCachePK;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryHelperUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryValue;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaPK;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacade;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocalHome;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserPK;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserUtil;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;
import de.proveo.wwt.logic.ejb.state.exception.NoStateFoundException;
import de.proveo.wwt.logic.ejb.state.exception.StatesForUnitNotFoundException;
import de.proveo.wwt.logic.ejb.state.exception.WriteStateException;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CurrentStateFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(CurrentStateFacadeBean.class);
    private CurrentStateCacheLocalHome currentStateCacheHome;
    private StateHistoryLocalHome stateHistoryHome;
    private GrouphistoryLocalHome grouphistoryHome;
    private AreaLocalHome areaHome;
    private UseUserLocalHome useUserHome;
    private UnitFacade unit;
    private static final int DEFAULT_MAX_REMARK_LENGTH = 100;
    private int maxRemarkLength = 100;

    public CurrentStateFacadeStruct getCurrentState(long unitId, long stateModelId) throws NoStateFoundException {
        CurrentStateFacadeStruct currentState;
        try {
            currentState = this.getCurrentStateFromCache(unitId, stateModelId);
        }
        catch (NoStateFoundException exCache) {
            currentState = this.getCurrentStateFromHistory(unitId, stateModelId);
        }
        return currentState;
    }

    public Map<Long, CurrentStateFacadeStruct> getCurrentState(long unitId) throws StatesForUnitNotFoundException {
        Map<Long, CurrentStateFacadeStruct> stateMap;
        try {
            stateMap = this.getCurrentStateFromCache(unitId);
        }
        catch (StatesForUnitNotFoundException ex) {
            log.debug((Object)"getCurrentState(unitId) Nothing found in Cache. Try stateHistory");
            stateMap = this.getCurrentStateFromHistory(unitId);
        }
        return stateMap;
    }

    public Collection getStructs(Collection stateHistories) {
        ArrayList<StateHistoryValue> structs = new ArrayList<StateHistoryValue>(stateHistories.size());
        for (StateHistoryLocal history : stateHistories) {
            try {
                structs.add(history.getStateHistoryValue());
            }
            catch (Exception ex) {
                log.error((Object)"getStructs() runs during getStruct into", (Throwable)ex);
            }
        }
        return structs;
    }

    public String getRemark(String uncheckedRemark) {
        if (uncheckedRemark == null) {
            return null;
        }
        if (uncheckedRemark.length() > this.maxRemarkLength) {
            String remark = uncheckedRemark.substring(0, this.maxRemarkLength);
            if (log.isWarnEnabled()) {
                log.warn((Object)("getRemark() remark exceeded maximumlenth of " + this.maxRemarkLength + " cutted off. orignal: " + uncheckedRemark + " cutted to: " + remark));
            }
            return remark;
        }
        return uncheckedRemark;
    }

    public SerializableEventWrapper changeState(StateEvent stateEvent) throws ImplicitRollbackException {
        StateHistoryValue stateHistoryValue = new StateHistoryValue();
        CurrentStateCacheValue currentStateCacheValue = new CurrentStateCacheValue();
        try {
            StateHistoryLocal stateHistory;
            CurrentStateFacadeStruct currentState;
            block26: {
                currentState = this.getCurrentState(stateEvent.getUnitId(), stateEvent.getStateModelId());
                stateHistory = null;
                try {
                    CurrentStateCachePK pk;
                    if (currentState.getEntryTime() > stateEvent.getTimestamp()) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("incoming event '" + stateEvent + "' older than current state '" + currentState + "', don't move current state to history!"));
                        }
                        break block26;
                    }
                    if (currentState.getEntryTime() == stateEvent.getTimestamp()) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("incoming event '" + stateEvent + "' equals current state '" + currentState + "', don't move current state to history!"));
                        }
                        break block26;
                    }
                    if (stateEvent.getStateId() == currentState.getStateId()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("incoming event '" + stateEvent + "' has the same stateId as curent state '" + currentState + "', update REMARK only..."));
                        }
                        pk = new CurrentStateCachePK(stateEvent.getUnitId(), stateEvent.getStateModelId());
                        CurrentStateCacheLocal cache = this.currentStateCacheHome.findByPrimaryKey(pk);
                        cache.setRemark(stateEvent.getRemark());
                        break block26;
                    }
                    stateHistoryValue.setUnitId(stateEvent.getUnitId());
                    stateHistoryValue.setStateModelId(stateEvent.getStateModelId());
                    stateHistoryValue.setStateId(currentState.getStateId());
                    stateHistoryValue.setBeginTime(currentState.getEntryTime());
                    stateHistoryValue.setBeginReceiveTime(currentState.getEntryReceiveTime());
                    stateHistoryValue.setEndTime(stateEvent.getTimestamp());
                    stateHistoryValue.setEndReceiveTime(stateEvent.getReceiveTime());
                    stateHistoryValue.setStateIdPrevious(currentState.getStateIdPrevious());
                    stateHistoryValue.setStateIdAfter(stateEvent.getStateId());
                    stateHistoryValue.setPkStatePrevious(currentState.getPkStatePrevious());
                    stateHistoryValue.setRemark(this.getRemark(currentState.getRemark()));
                    try {
                        stateHistory = this.stateHistoryHome.create(stateHistoryValue);
                    }
                    catch (DuplicateKeyException ex) {
                        this.stateHistoryHome.reorganizeSequence();
                        stateHistory = this.stateHistoryHome.create(stateHistoryValue);
                    }
                    catch (Exception ex) {
                        log.debug((Object)("create history runs into " + ex.getMessage()));
                        if (!this.fixDuplicateHistoryEntry(stateHistoryValue)) {
                            throw ex;
                        }
                        log.debug((Object)"try to create history after successful fixDuplicateHistoryEntry");
                        stateHistory = this.stateHistoryHome.create(stateHistoryValue);
                    }
                    pk = new CurrentStateCachePK(stateEvent.getUnitId(), stateEvent.getStateModelId());
                    CurrentStateCacheLocal cache = this.currentStateCacheHome.findByPrimaryKey(pk);
                    stateHistory.setGroupHistoryId(cache.getGroupHistoryId());
                    stateHistory.setAreaTrusted(cache.getAreaTrusted());
                    AreaLocal area = cache.getArea();
                    if (area != null) {
                        stateHistory.setArea(area);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("set area of history entry to " + area.getArea()));
                        }
                    } else {
                        log.debug((Object)"no area in cache, nothing to write into history");
                    }
                    stateHistory.setUseUser(cache.getUseUser());
                    stateHistoryValue = stateHistory.getStateHistoryValue();
                    long[] daystamps = BaseHelperUtil.roundToDaystamps((long)stateHistoryValue.getBeginTime(), (long)stateHistoryValue.getEndTime());
                    long groupHistoryId = 0L;
                    GrouphistoryLocal grouphistoryLocal = stateHistory.getGroupHistoryId();
                    if (grouphistoryLocal != null) {
                        groupHistoryId = grouphistoryLocal.getGroupHistoryId();
                    }
                    for (int i = 0; i < daystamps.length; ++i) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("creating helper: (" + stateHistory.getStateHistoryId() + ", " + daystamps[i] + ", " + stateHistoryValue.getUnitId() + ", " + groupHistoryId + ");"));
                        }
                        StateHistoryHelperUtil.getLocalHome().create(stateHistory.getStateHistoryId(), daystamps[i], stateHistoryValue.getUnitId(), groupHistoryId);
                    }
                }
                catch (Exception ex) {
                    String msg = "changeStateInto() runs during leave old State into Exception";
                    log.error((Object)msg, (Throwable)ex);
                    throw new ImplicitRollbackException(msg);
                }
            }
            long pkStatePre = stateHistory != null ? stateHistory.getStateHistoryId() : 0L;
            currentStateCacheValue.setUnitId(stateEvent.getUnitId());
            currentStateCacheValue.setStateModelId(stateEvent.getStateModelId());
            currentStateCacheValue.setState(stateEvent.getStateId());
            currentStateCacheValue.setBeginTime(stateEvent.getTimestamp());
            currentStateCacheValue.setBeginReceiveTime(stateEvent.getReceiveTime());
            currentStateCacheValue.setDontValidateNext(true);
            currentStateCacheValue.setStateIdPrevious(currentState.getStateId());
            currentStateCacheValue.setPkStatePrevious(pkStatePre);
            currentStateCacheValue.setRemark(this.getRemark(stateEvent.getRemark()));
            currentStateCacheValue.setAreaTrusted(stateEvent.isAreaTrusted());
            try {
                this.writeIntoCache(currentStateCacheValue, stateEvent);
            }
            catch (WriteStateException ex) {
                String msg = "changeState() runs during writeIntoCache() into Exception";
                throw new ImplicitRollbackException(msg);
            }
        }
        catch (NoStateFoundException ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("changeState(): the unitId " + stateEvent.getUnitId() + " was stateless for state model " + stateEvent.getStateModelId() + "! (initial state was missing)"));
                log.warn((Object)"changeState(): ... create *first* cache entry for this unit.");
            }
            currentStateCacheValue.setUnitId(stateEvent.getUnitId());
            currentStateCacheValue.setStateModelId(stateEvent.getStateModelId());
            currentStateCacheValue.setState(stateEvent.getStateId());
            currentStateCacheValue.setBeginTime(stateEvent.getTimestamp());
            currentStateCacheValue.setBeginReceiveTime(stateEvent.getReceiveTime());
            currentStateCacheValue.setDontValidateNext(false);
            currentStateCacheValue.setRemark(this.getRemark(stateEvent.getRemark()));
            try {
                this.writeIntoCache(currentStateCacheValue, stateEvent);
            }
            catch (WriteStateException e) {
                String msg = "changeState() runs during writeIntoCache() into Exception";
                throw new ImplicitRollbackException(msg);
            }
        }
        catch (NullPointerException ex) {
            String msg = "changeState() runs into NullPointerException (maybe timestamp problem) ";
            log.error((Object)msg, (Throwable)ex);
            throw new ImplicitRollbackException(msg);
        }
        SerializableEventWrapper wrapper = new SerializableEventWrapper((Serializable)currentStateCacheValue, (Serializable)stateHistoryValue);
        wrapper.set_PkGdataHistoryPre(stateHistoryValue.getStateHistoryId());
        return wrapper;
    }

    public void ejbCreate() throws CreateException {
        try {
            this.currentStateCacheHome = CurrentStateCacheUtil.getLocalHome();
            this.stateHistoryHome = StateHistoryUtil.getLocalHome();
            this.unit = UnitFacadeUtil.getHome().create();
            this.grouphistoryHome = GrouphistoryUtil.getLocalHome();
            this.areaHome = AreaUtil.getLocalHome();
            this.useUserHome = UseUserUtil.getLocalHome();
            InitialContext ctx = new InitialContext();
            this.maxRemarkLength = (Integer)ctx.lookup("java:comp/env/maxRemarkLength");
        }
        catch (NamingException ex) {
            throw new EJBException("problem during lookup other EJBs: " + ex.getMessage());
        }
        catch (RemoteException ex) {
            throw new EJBException("problem during create SB: " + ex.getMessage());
        }
    }

    protected CurrentStateFacadeStruct getCurrentStateFromCache(long unitId, long stateModelId) throws NoStateFoundException {
        try {
            CurrentStateCachePK pk = new CurrentStateCachePK(unitId, stateModelId);
            CurrentStateCacheLocal cachedState = this.currentStateCacheHome.findByPrimaryKey(pk);
            CurrentStateCacheValue cachedStruct = cachedState.getCurrentStateCacheValue();
            CurrentStateFacadeStruct currentState = new CurrentStateFacadeStruct();
            currentState.setUnitId(unitId);
            currentState.setStateModelId(stateModelId);
            currentState.setStateId(cachedStruct.getState());
            currentState.setEntryTime(cachedStruct.getBeginTime());
            currentState.setEntryReceiveTime(cachedStruct.getBeginReceiveTime());
            currentState.setDontValidateNext(cachedStruct.getDontValidateNext());
            currentState.setStateIdPrevious(cachedStruct.getStateIdPrevious());
            currentState.setPkStatePrevious(cachedStruct.getPkStatePrevious());
            currentState.setRemark(cachedStruct.getRemark());
            return currentState;
        }
        catch (Exception ex) {
            throw new NoStateFoundException(unitId, stateModelId, "Unable to found the state in the cache", ex);
        }
    }

    protected Map<Long, CurrentStateFacadeStruct> getCurrentStateFromCache(long unitId) throws StatesForUnitNotFoundException {
        Collection states;
        try {
            states = this.currentStateCacheHome.findByUnitId(unitId);
        }
        catch (FinderException ex) {
            throw new StatesForUnitNotFoundException(unitId, "No states for this unit in cache", (Exception)((Object)ex));
        }
        if (states == null || states.isEmpty()) {
            throw new StatesForUnitNotFoundException(unitId, "Finder Collection is empty");
        }
        HashMap<Long, CurrentStateFacadeStruct> stateMap = new HashMap<Long, CurrentStateFacadeStruct>(states.size());
        for (CurrentStateCacheLocal state : states) {
            CurrentStateCacheValue cachedStruct = state.getCurrentStateCacheValue();
            CurrentStateFacadeStruct struct = new CurrentStateFacadeStruct();
            struct.setUnitId(unitId);
            struct.setStateModelId(cachedStruct.getStateModelId());
            struct.setStateId(cachedStruct.getState());
            struct.setEntryTime(cachedStruct.getBeginTime());
            struct.setEntryReceiveTime(cachedStruct.getBeginReceiveTime());
            struct.setDontValidateNext(cachedStruct.getDontValidateNext());
            struct.setStateIdPrevious(cachedStruct.getStateIdPrevious());
            struct.setPkStatePrevious(cachedStruct.getPkStatePrevious());
            struct.setRemark(cachedStruct.getRemark());
            stateMap.put(new Long(cachedStruct.getStateModelId()), struct);
        }
        return stateMap;
    }

    protected Map<Long, CurrentStateFacadeStruct> getCurrentStateFromHistory(long unitId) throws StatesForUnitNotFoundException {
        Collection stateStubs;
        log.trace((Object)("getCurrentStateFromHistory(" + unitId + ")"));
        try {
            stateStubs = this.stateHistoryHome.findByUnitSorted(unitId);
        }
        catch (FinderException ex) {
            throw new StatesForUnitNotFoundException(unitId, "No states for this unit in stateHistory", (Exception)((Object)ex));
        }
        if (stateStubs == null || stateStubs.isEmpty()) {
            throw new StatesForUnitNotFoundException(unitId, "Finder Collection is empty");
        }
        Iterator it = stateStubs.iterator();
        HashMap<Long, CurrentStateFacadeStruct> stateStructMap = new HashMap<Long, CurrentStateFacadeStruct>();
        while (it.hasNext()) {
            StateHistoryLocal stateHistory = (StateHistoryLocal)it.next();
            StateHistoryValue historyStruct = stateHistory.getStateHistoryValue();
            CurrentStateFacadeStruct struct = new CurrentStateFacadeStruct();
            struct.setUnitId(unitId);
            struct.setStateModelId(historyStruct.getStateModelId());
            struct.setStateId(historyStruct.getStateIdAfter());
            struct.setEntryTime(historyStruct.getEndTime());
            struct.setEntryReceiveTime(historyStruct.getEndReceiveTime());
            struct.setDontValidateNext(false);
            struct.setStateIdPrevious(historyStruct.getStateId());
            struct.setPkStatePrevious(historyStruct.getStateHistoryId());
            stateStructMap.remove(new Long(historyStruct.getStateModelId()));
            stateStructMap.put(new Long(historyStruct.getStateModelId()), struct);
        }
        HashMap<Long, CurrentStateFacadeStruct> stateMap = new HashMap<Long, CurrentStateFacadeStruct>(stateStructMap.size());
        for (Long stateModelId : stateStructMap.keySet()) {
            CurrentStateFacadeStruct struct = (CurrentStateFacadeStruct)stateStructMap.get(stateModelId);
            stateMap.put(stateModelId, struct);
        }
        return stateMap;
    }

    protected CurrentStateFacadeStruct getCurrentStateFromHistory(long unitId, long stateModelId) throws NoStateFoundException {
        Collection stateHistories;
        log.trace((Object)"getCurrentStateFromHistory(long,long)");
        try {
            stateHistories = this.stateHistoryHome.findByUnitStateModelSorted(unitId, stateModelId);
        }
        catch (FinderException ex) {
            throw new NoStateFoundException(unitId, stateModelId, "No States for this unit in StateHistory Found", (Exception)((Object)ex));
        }
        if (stateHistories == null || stateHistories.isEmpty()) {
            throw new NoStateFoundException(unitId, stateModelId, "Finder returns empty Collection.");
        }
        Iterator it = stateHistories.iterator();
        Object last = null;
        while (it.hasNext()) {
            last = it.next();
        }
        StateHistoryLocal stateHistory = last;
        StateHistoryValue stateHistoryValue = stateHistory.getStateHistoryValue();
        try {
            this.writeIntoCache(stateHistoryValue);
        }
        catch (WriteStateException ex) {
            throw new NoStateFoundException(unitId, stateModelId, "getCurrentStateFromHistory() runs into Exception", ex);
        }
        CurrentStateFacadeStruct currentState = new CurrentStateFacadeStruct();
        currentState.setUnitId(unitId);
        currentState.setStateModelId(stateModelId);
        currentState.setStateId(stateHistoryValue.getStateIdAfter());
        currentState.setEntryTime(stateHistoryValue.getEndTime());
        currentState.setEntryReceiveTime(stateHistoryValue.getEndReceiveTime());
        currentState.setDontValidateNext(false);
        currentState.setStateIdPrevious(stateHistoryValue.getStateId());
        currentState.setPkStatePrevious(stateHistoryValue.getStateHistoryId());
        return currentState;
    }

    protected void writeIntoCache(CurrentStateCacheValue currentStateCacheValue, StateEvent stateEvent) throws WriteStateException {
        block28: {
            String method = "writeIntoCache(): ";
            CurrentStateCachePK pk = new CurrentStateCachePK(currentStateCacheValue.getUnitId(), currentStateCacheValue.getStateModelId());
            try {
                CurrentStateCacheLocal cachedState = this.currentStateCacheHome.findByPrimaryKey(pk);
                CurrentStateCacheValue oldCacheStruct = cachedState.getCurrentStateCacheValue();
                if (currentStateCacheValue.getBeginTime() >= oldCacheStruct.getBeginTime()) {
                    if (currentStateCacheValue.getState() != oldCacheStruct.getState()) {
                        block29: {
                            cachedState.setCurrentStateCacheValue(currentStateCacheValue);
                            cachedState.setGroupHistoryId(this.grouphistoryHome.getGrouphistoryForUnit(currentStateCacheValue.getUnitId(), currentStateCacheValue.getBeginTime()));
                            if (stateEvent == null) break block28;
                            if (stateEvent.getAreaId() != 0) {
                                try {
                                    AreaLocal areaLocal = this.areaHome.findByPrimaryKey(new AreaPK(stateEvent.getAreaId()));
                                    cachedState.setArea(areaLocal);
                                    cachedState.setAreaTrusted(stateEvent.isAreaTrusted());
                                    if (log.isTraceEnabled()) {
                                        log.trace((Object)(method + "set area to " + areaLocal.getArea()));
                                    }
                                    break block29;
                                }
                                catch (ObjectNotFoundException ex) {
                                    if (log.isErrorEnabled()) {
                                        log.error((Object)(method + "area not found: " + stateEvent.getAreaId()));
                                    }
                                    break block29;
                                }
                            }
                            cachedState.setArea(null);
                            cachedState.setAreaTrusted(false);
                            log.debug((Object)(method + "no area in event"));
                        }
                        if (stateEvent.getUser() != null) {
                            try {
                                UseUserLocal useUserLocal = this.useUserHome.findByPrimaryKey(new UseUserPK(stateEvent.getUser().getId()));
                                cachedState.setUseUser(useUserLocal);
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)(method + "set to useUser: " + useUserLocal.getId()));
                                }
                                break block28;
                            }
                            catch (ObjectNotFoundException ex) {
                                if (log.isErrorEnabled()) {
                                    log.error((Object)(method + "useUser not found: " + stateEvent.getUser().getId()));
                                }
                                break block28;
                            }
                        }
                        cachedState.setUseUser(null);
                        log.trace((Object)(method + "no useUser in event"));
                        break block28;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(method + "nothing new. cache: " + oldCacheStruct + " new: " + currentStateCacheValue));
                    }
                    break block28;
                }
                if (log.isErrorEnabled()) {
                    log.error((Object)(method + "we have already a newer entry. database value: " + oldCacheStruct + " received event: " + currentStateCacheValue));
                }
            }
            catch (FinderException exFinder) {
                try {
                    CurrentStateCacheLocal cachedState = this.currentStateCacheHome.create(currentStateCacheValue);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(method + "create currentState for unitId: " + currentStateCacheValue.getUnitId() + " stateModelId: " + currentStateCacheValue.getStateModelId() + " stateId: " + currentStateCacheValue.getState() + " (persistent)"));
                    }
                    if (stateEvent == null) break block28;
                    if (stateEvent.getAreaId() != 0) {
                        try {
                            AreaLocal areaLocal = this.areaHome.findByPrimaryKey(new AreaPK(stateEvent.getAreaId()));
                            cachedState.setArea(areaLocal);
                            cachedState.setAreaTrusted(stateEvent.isAreaTrusted());
                            if (log.isTraceEnabled()) {
                                log.trace((Object)(method + "set area to " + areaLocal.getArea()));
                            }
                        }
                        catch (ObjectNotFoundException ex) {
                            log.error((Object)(method + "area not found: " + stateEvent.getAreaId()));
                        }
                    } else {
                        log.debug((Object)(method + "no area in event"));
                    }
                    if (stateEvent.getUser() != null) {
                        try {
                            UseUserLocal useUserLocal = this.useUserHome.findByPrimaryKey(new UseUserPK(stateEvent.getUser().getId()));
                            cachedState.setUseUser(useUserLocal);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)(method + "set to useUser: " + useUserLocal.getId()));
                            }
                        }
                        catch (ObjectNotFoundException ex) {
                            log.error((Object)(method + "useUser not found: " + stateEvent.getUser().getId()));
                        }
                    }
                    log.trace((Object)(method + "no useUser in event"));
                }
                catch (Exception ex) {
                    String msg = method + "runs during currentStateCacheHome.create into Exception";
                    log.error((Object)msg, (Throwable)ex);
                    throw new WriteStateException(currentStateCacheValue.getUnitId(), currentStateCacheValue.getStateModelId(), currentStateCacheValue.getState(), msg, ex);
                }
            }
        }
    }

    protected void writeIntoCache(StateHistoryValue stateHistoryValue) throws WriteStateException {
        CurrentStateCacheValue cachedStruct = new CurrentStateCacheValue();
        cachedStruct.setUnitId(stateHistoryValue.getUnitId());
        cachedStruct.setStateModelId(stateHistoryValue.getStateModelId());
        cachedStruct.setState(stateHistoryValue.getStateIdAfter());
        cachedStruct.setBeginTime(stateHistoryValue.getEndTime());
        cachedStruct.setBeginReceiveTime(stateHistoryValue.getEndReceiveTime());
        cachedStruct.setDontValidateNext(false);
        cachedStruct.setStateIdPrevious(stateHistoryValue.getStateId());
        cachedStruct.setPkStatePrevious(stateHistoryValue.getPkStatePrevious());
        cachedStruct.setRemark(stateHistoryValue.getRemark());
        this.writeIntoCache(cachedStruct, null);
    }

    public boolean moveCacheDataToHistoryForDeletedUnit(UnitModelLocal unitModel) {
        long timeNow = System.currentTimeMillis();
        Collection currentStateCaches = unitModel.getCurrentStateCaches();
        CurrentStateCacheLocal[] currArr = currentStateCaches.toArray(new CurrentStateCacheLocal[currentStateCaches.size()]);
        StateHistoryLocal stateHistory = null;
        StateHistoryValue stateHistoryValue = null;
        for (int k = 0; k != currArr.length; ++k) {
            UseUserLocal useUser;
            AreaLocal area;
            CurrentStateCacheLocal currentStateLocal = currArr[k];
            if (currentStateLocal == null) continue;
            CurrentStateCacheValue currentState = currentStateLocal.getCurrentStateCacheValue();
            stateHistoryValue = new StateHistoryValue();
            stateHistoryValue.setUnitId(currentState.getUnitId());
            stateHistoryValue.setStateModelId(currentState.getStateModelId());
            stateHistoryValue.setStateId(currentState.getState());
            stateHistoryValue.setBeginTime(currentState.getBeginTime());
            stateHistoryValue.setBeginReceiveTime(currentState.getBeginReceiveTime());
            stateHistoryValue.setEndTime(timeNow);
            stateHistoryValue.setEndReceiveTime(timeNow);
            stateHistoryValue.setStateIdPrevious(currentState.getStateIdPrevious());
            stateHistoryValue.setStateIdAfter(-1L);
            stateHistoryValue.setPkStatePrevious(currentState.getPkStatePrevious());
            stateHistoryValue.setRemark(currentState.getRemark());
            stateHistoryValue.setAreaTrusted(currentState.getAreaTrusted());
            try {
                try {
                    stateHistory = this.stateHistoryHome.create(stateHistoryValue);
                }
                catch (DuplicateKeyException ex) {
                    this.stateHistoryHome.reorganizeSequence();
                    stateHistory = this.stateHistoryHome.create(stateHistoryValue);
                }
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            GrouphistoryLocal ghLocal = currentStateLocal.getGroupHistoryId();
            if (ghLocal != null) {
                stateHistory.setGroupHistoryId(ghLocal);
            }
            if ((area = currentStateLocal.getArea()) != null) {
                stateHistory.setArea(area);
            }
            if ((useUser = currentStateLocal.getUseUser()) != null) {
                stateHistory.setUseUser(useUser);
            }
            stateHistoryValue = stateHistory.getStateHistoryValue();
            try {
                if (currentStateLocal == null) continue;
                currentStateLocal.remove();
                continue;
            }
            catch (EJBException e) {
                log.error((Object)"runs into", (Throwable)e);
                continue;
            }
            catch (RemoveException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        return true;
    }

    private boolean fixDuplicateHistoryEntry(StateHistoryValue stateHistoryValue) {
        log.debug((Object)("fixDuplicateHistoryEntry() with " + stateHistoryValue));
        try {
            Collection duplicates = this.stateHistoryHome.findByUnitStateModelBeginTime(stateHistoryValue.getUnitId(), stateHistoryValue.getStateModelId(), stateHistoryValue.getBeginTime());
            if (duplicates != null) {
                for (StateHistoryLocal stateHistoryLocal : duplicates) {
                    if (stateHistoryLocal == null) continue;
                    log.debug((Object)("remove: " + stateHistoryLocal.getStateHistoryValue()));
                    stateHistoryLocal.remove();
                    log.info((Object)"Removed duplicate StateHistory entry!");
                    return true;
                }
            }
        }
        catch (FinderException e) {
        }
        catch (EJBException e) {
            log.error((Object)"fixDuplicateHistoryEntry runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            log.error((Object)"fixDuplicateHistoryEntry runs into", (Throwable)e);
        }
        log.debug((Object)"fixDuplicateHistoryEntry not successful!");
        return false;
    }
}

