/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.keepalive;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.helper.BaseHelperUtil;
import de.proveo.wwt.logic.app.keepalive.event.KeepAliveEvent;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.keepalive.cache.KeepAliveCacheLocal;
import de.proveo.wwt.logic.ejb.keepalive.cache.KeepAliveCacheLocalHome;
import de.proveo.wwt.logic.ejb.keepalive.cache.KeepAliveCachePK;
import de.proveo.wwt.logic.ejb.keepalive.cache.KeepAliveCacheUtil;
import de.proveo.wwt.logic.ejb.keepalive.cache.KeepAliveCacheValue;
import de.proveo.wwt.logic.ejb.keepalive.helper.KeepAliveHistoryHelperUtil;
import de.proveo.wwt.logic.ejb.keepalive.history.KeepAliveHistoryLocal;
import de.proveo.wwt.logic.ejb.keepalive.history.KeepAliveHistoryLocalHome;
import de.proveo.wwt.logic.ejb.keepalive.history.KeepAliveHistoryUtil;
import de.proveo.wwt.logic.ejb.keepalive.history.KeepAliveHistoryValue;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class KeepAliveInFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(KeepAliveInFacadeBean.class);
    private KeepAliveCacheLocalHome cacheHome;
    private KeepAliveHistoryLocalHome historyHome;
    private GrouphistoryLocalHome grouphistoryHome;

    public void ejbCreate() throws CreateException {
        try {
            this.cacheHome = KeepAliveCacheUtil.getLocalHome();
            this.historyHome = KeepAliveHistoryUtil.getLocalHome();
            this.grouphistoryHome = GrouphistoryUtil.getLocalHome();
        }
        catch (NamingException ex) {
            log.error((Object)"Cannot find KeepAlive Entity Bean", (Throwable)ex);
            throw new EJBException("Can not find KeepAlive Entity Bean: " + ex.getMessage());
        }
    }

    public boolean event(KeepAliveEvent keepAliveEvent, long unitId) throws ImplicitRollbackException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("event() for unitId " + unitId));
        }
        KeepAliveCachePK cachePK = new KeepAliveCachePK(unitId);
        try {
            try {
                KeepAliveCacheLocal cache = this.cacheHome.findByPrimaryKey(cachePK);
                if (cache.getCreateTimeStamp() >= keepAliveEvent.getCreateTimestamp()) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("event() double transmission: " + keepAliveEvent));
                    }
                    return false;
                }
                this.copyCacheToHistory(cache);
                cache.setCreateTimeStamp(keepAliveEvent.getCreateTimestamp());
                cache.setReceiveTimeStamp(keepAliveEvent.getReceiveTimestamp());
                cache.setGroupHistoryId(this.grouphistoryHome.getGrouphistoryForUnit(unitId, cache.getCreateTimeStamp()));
            }
            catch (FinderException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("event() Cannot find cache entry for unitId: " + unitId));
                }
                KeepAliveCacheValue value = new KeepAliveCacheValue();
                value.setUnitId(keepAliveEvent.getUnitId());
                value.setCreateTimeStamp(keepAliveEvent.getCreateTimestamp());
                value.setReceiveTimeStamp(keepAliveEvent.getReceiveTimestamp());
                KeepAliveCacheLocal cache = this.cacheHome.create(value);
                cache.setGroupHistoryId(this.grouphistoryHome.getGrouphistoryForUnit(unitId, value.getCreateTimeStamp()));
            }
        }
        catch (CreateException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("event(unitId: " + unitId + ") cannot create cache entry"), (Throwable)ex);
            }
            throw new ImplicitRollbackException(ex.toString());
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("event(unitId: " + unitId + ") runs into"), (Throwable)ex);
            }
            throw new ImplicitRollbackException(ex.toString());
        }
        return true;
    }

    protected void copyCacheToHistory(KeepAliveCacheLocal cache) throws FinderException {
        KeepAliveHistoryValue value = this.createHistoryValueFromCache(cache.getKeepAliveCacheValue());
        try {
            try {
                KeepAliveHistoryLocal history = this.historyHome.create(value);
                history.setGroupHistoryId(this.grouphistoryHome.getGrouphistoryForUnit(cache.getUnitId(), history.getReceiveTimeStamp()));
                long daystamp = BaseHelperUtil.roundToDaystamp((long)value.getCreateTimeStamp());
                long groupHistoryId = 0L;
                GrouphistoryLocal grouphistoryLocal = history.getGroupHistoryId();
                if (grouphistoryLocal != null) {
                    groupHistoryId = grouphistoryLocal.getGroupHistoryId();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("creating helper: (" + history.getId() + ", " + daystamp + ", " + history.getUnitId() + ", " + groupHistoryId + ");"));
                }
                KeepAliveHistoryHelperUtil.getLocalHome().create(history.getId(), daystamp, history.getUnitId(), groupHistoryId);
            }
            catch (DuplicateKeyException ex) {
                this.historyHome.reorganizeSequence();
                KeepAliveHistoryLocal history = this.historyHome.create(value);
                history.setGroupHistoryId(this.grouphistoryHome.getGrouphistoryForUnit(cache.getUnitId(), history.getReceiveTimeStamp()));
                long daystamp = BaseHelperUtil.roundToDaystamp((long)value.getCreateTimeStamp());
                long groupHistoryId = 0L;
                GrouphistoryLocal grouphistoryLocal = history.getGroupHistoryId();
                if (grouphistoryLocal != null) {
                    groupHistoryId = grouphistoryLocal.getGroupHistoryId();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("creating helper: (" + history.getId() + ", " + daystamp + ", " + history.getUnitId() + ", " + groupHistoryId + ");"));
                }
                KeepAliveHistoryHelperUtil.getLocalHome().create(history.getId(), daystamp, history.getUnitId(), groupHistoryId);
            }
        }
        catch (CreateException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        catch (NamingException ex) {
            throw new EJBException((Exception)ex);
        }
    }

    protected KeepAliveHistoryValue createHistoryValueFromCache(KeepAliveCacheValue cacheValue) {
        KeepAliveHistoryValue value = new KeepAliveHistoryValue();
        value.setUnitId(cacheValue.getUnitId());
        value.setCreateTimeStamp(cacheValue.getCreateTimeStamp());
        value.setReceiveTimeStamp(cacheValue.getReceiveTimeStamp());
        return value;
    }

    public boolean moveCacheDataToHistoryForDeletedUnit(UnitModelLocal unitModel) {
        KeepAliveCacheLocal keepAliveCacheLocal = unitModel.getKeepAliveCache();
        if (keepAliveCacheLocal == null) {
            return true;
        }
        KeepAliveCacheValue keepAliveCache = keepAliveCacheLocal.getKeepAliveCacheValue();
        KeepAliveHistoryValue keepAliveHistoryValue = this.createHistoryValueFromCache(keepAliveCache);
        KeepAliveHistoryLocal keepAliveHistoryLocal = null;
        try {
            try {
                keepAliveHistoryLocal = this.historyHome.create(keepAliveHistoryValue);
            }
            catch (DuplicateKeyException ex) {
                this.historyHome.reorganizeSequence();
                keepAliveHistoryLocal = this.historyHome.create(keepAliveHistoryValue);
            }
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        keepAliveHistoryLocal.setGroupHistoryId(keepAliveCacheLocal.getGroupHistoryId());
        try {
            if (keepAliveCacheLocal != null) {
                keepAliveCacheLocal.remove();
            }
        }
        catch (EJBException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return true;
    }
}

