/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml;

import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.UnknownErrorException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.ClientConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Enums;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Timestamp;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.SAXDocument;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.XMLDocument;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ErrorMessage {
    private static final Log log = LogFactory.getLog(ErrorMessage.class);
    private ClientConfiguration config = ClientConfiguration.getInstance();
    private Document doc;
    private Enums.ErrorCode errorCode = Enums.ErrorCode.UNKNOWN;
    private String originalXmlText;
    private String errorMessageText;
    private String exceptionMessage;
    private Element errorMessageElement;
    private Element detailsElement;

    public ErrorMessage() {
        this.init();
    }

    public ErrorMessage(Enums.ErrorCode errorCode, String errorMessageText, SAXDocument originalXMLDoc) {
        this.init();
        this.setErrorCode(errorCode);
        this.setErrorMessageText(errorMessageText);
        this.setOriginalXmlText(originalXMLDoc.getXmlText());
    }

    public ErrorMessage(Enums.ErrorCode errorCode, String errorMessageText, SAXDocument originalXMLDoc, String parameterName, String parameterValue) {
        this.init();
        this.setErrorCode(errorCode);
        this.setErrorMessageText(errorMessageText);
        this.setOriginalXmlText(originalXMLDoc.getXmlText());
        this.addParameter(parameterName, parameterValue);
    }

    public ErrorMessage(Enums.ErrorCode errorCode, String errorMessageText, SAXDocument originalXMLDoc, String exceptionMessage) {
        this.init();
        this.setErrorCode(errorCode);
        this.setErrorMessageText(errorMessageText);
        this.setOriginalXmlText(originalXMLDoc.getXmlText());
        this.setExceptionMessage(exceptionMessage);
    }

    public ErrorMessage(Enums.ErrorCode errorCode, String errorMessageText, SAXDocument originalXMLDoc, String exceptionMessage, Enums.EventType eventType, String whichData) {
        this.init();
        this.setErrorCode(errorCode);
        this.setErrorMessageText(errorMessageText);
        this.setOriginalXmlText(originalXMLDoc.getXmlText());
        this.setExceptionMessage(exceptionMessage);
        this.setSynchronizationDetails(eventType, whichData);
    }

    private void init() {
        this.doc = new Document();
        this.errorMessageElement = new Element(this.config.getString("xml.errorMessage.xmlName"));
        this.doc.setRootElement(this.errorMessageElement);
    }

    private String replaceTemplate(String message, Enums.ErrorCode errorCode) {
        return String.format(message, this.config.getString("xml.errorMessage.errorCode." + errorCode.getCode() + ".errorMessageTemplate"));
    }

    public String getOriginalXmlText() {
        return this.originalXmlText;
    }

    public void setOriginalXmlText(String originalXmlText) {
        this.originalXmlText = originalXmlText;
        if (originalXmlText != null && originalXmlText.length() > 0 && this.config.getBoolean("xml.errorMessage.originalMessage.active")) {
            Element originalMessageElement = new Element(this.config.getString("xml.errorMessage.originalMessage.xmlName"));
            try {
                XMLDocument originalDoc = new XMLDocument(originalXmlText);
                Element rootElement = originalDoc.getDoc().detachRootElement();
                originalMessageElement.addContent((Content)rootElement);
            }
            catch (JDOMException e) {
                originalMessageElement.setText(originalXmlText);
            }
            catch (UnknownErrorException e) {
                originalMessageElement.setText(originalXmlText);
            }
            this.errorMessageElement.addContent((Content)originalMessageElement);
        }
    }

    public String getErrorMessageText() {
        return this.errorMessageText;
    }

    public void setErrorMessageText(String errorMessageText) {
        if (this.errorCode.getCode() > 0) {
            errorMessageText = this.replaceTemplate(errorMessageText, this.errorCode);
        }
        this.errorMessageText = errorMessageText;
        if (this.doc != null) {
            Element root = this.doc.getRootElement();
            if (errorMessageText != null && errorMessageText.length() > 0 && this.config.getBoolean("xml.errorMessage.errorMessageText.active")) {
                root.setAttribute(this.config.getString("xml.errorMessage.errorMessageText.xmlName"), errorMessageText);
            }
        }
    }

    public Enums.ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(Enums.ErrorCode errorCode) {
        this.errorCode = errorCode;
        if (this.doc != null) {
            Element root = this.doc.getRootElement();
            if (errorCode.getCode() > 0 && this.config.getBoolean("xml.errorMessage.errorCode.active")) {
                root.setAttribute(this.config.getString("xml.errorMessage.errorCode.xmlName"), this.config.getString("xml.errorMessage.errorCode." + errorCode.getCode() + ".xmlCode"));
            }
        }
    }

    private Element getDetailsElement() {
        Element detailsElement;
        List detailsList = this.errorMessageElement.getChildren(this.config.getString("xml.errorMessage.details.xmlName"));
        if (detailsList.size() == 0) {
            detailsElement = new Element(this.config.getString("xml.errorMessage.details.xmlName"));
            this.errorMessageElement.addContent((Content)detailsElement);
        } else {
            detailsElement = (Element)detailsList.get(0);
        }
        return detailsElement;
    }

    public void addParameter(String name, String value) {
        log.debug((Object)("addParameter - name=" + name + " value=" + value));
        if (this.config.getBoolean("xml.errorMessage.details.active")) {
            this.detailsElement = this.getDetailsElement();
            Element parameterElement = new Element(this.config.getString("xml.errorMessage.details.parameter.xmlName"));
            if (name != null && name.length() > 0) {
                parameterElement.setAttribute(this.config.getString("xml.errorMessage.details.parameter.name.xmlName"), name);
                if (value != null && value.length() > 0) {
                    parameterElement.setAttribute(this.config.getString("xml.errorMessage.details.parameter.value.xmlName"), value);
                }
            }
            this.detailsElement.addContent((Content)parameterElement);
        }
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
        if (this.config.getBoolean("xml.errorMessage.details.active")) {
            this.detailsElement = this.getDetailsElement();
            List exceptionMessagesElementsList = this.detailsElement.getChildren(this.config.getString("xml.errorMessage.details.exceptionMessage.xmlName"));
            if (exceptionMessagesElementsList.size() > 0) {
                Element exceptionMessageElement = (Element)exceptionMessagesElementsList.get(0);
                exceptionMessageElement.setText(exceptionMessage);
            } else {
                Element exceptionMessageElement = new Element(this.config.getString("xml.errorMessage.details.exceptionMessage.xmlName"));
                exceptionMessageElement.setText(exceptionMessage);
                this.detailsElement.addContent((Content)exceptionMessageElement);
            }
        }
    }

    public void setSynchronizationDetails(Enums.EventType eventType, String whichData) {
        if (this.config.getBoolean("xml.errorMessage.details.active")) {
            Element synchronizationDetailsElement;
            String eventTypeString = "";
            switch (eventType) {
                case GEO: {
                    eventTypeString = "geo";
                    break;
                }
                case STATE: {
                    eventTypeString = "state";
                    break;
                }
                case NOTIFY: {
                    eventTypeString = "notify";
                }
            }
            this.detailsElement = this.getDetailsElement();
            List synchronizationDetailsList = this.detailsElement.getChildren(this.config.getString("xml.errorMessage.details.synchronizationDetails.xmlName"));
            if (synchronizationDetailsList.size() > 0) {
                synchronizationDetailsElement = (Element)synchronizationDetailsList.get(0);
            } else {
                synchronizationDetailsElement = new Element(this.config.getString("xml.errorMessage.details.synchronizationDetails.xmlName"));
                this.detailsElement.addContent((Content)synchronizationDetailsElement);
            }
            synchronizationDetailsElement.removeChildren(this.config.getString("xml.errorMessage.details.synchronizationDetails.type.xmlName"));
            Element typeElement = new Element(this.config.getString("xml.errorMessage.details.synchronizationDetails.type.xmlName"));
            typeElement.setText(eventTypeString);
            synchronizationDetailsElement.addContent((Content)typeElement);
            synchronizationDetailsElement.removeChildren(this.config.getString("xml.errorMessage.details.synchronizationDetails.whichData.xmlName"));
            Element whichDataElement = new Element(this.config.getString("xml.errorMessage.details.synchronizationDetails.whichData.xmlName"));
            whichDataElement.setText(whichData);
            synchronizationDetailsElement.addContent((Content)whichDataElement);
        }
    }

    public void setSynchronizationDetails(Enums.EventType eventType, String unitName, Timestamp startTime, Timestamp endTime) {
        if (this.config.getBoolean("xml.errorMessage.details.active")) {
            Element synchronizationDetailsElement;
            String eventTypeString = "";
            switch (eventType) {
                case GEO: {
                    eventTypeString = "geo";
                    break;
                }
                case STATE: {
                    eventTypeString = "state";
                    break;
                }
                case NOTIFY: {
                    eventTypeString = "notify";
                }
            }
            this.detailsElement = this.getDetailsElement();
            List synchronizationDetailsList = this.detailsElement.getChildren(this.config.getString("xml.errorMessage.details.synchronizationDetails.xmlName"));
            if (synchronizationDetailsList.size() > 0) {
                synchronizationDetailsElement = (Element)synchronizationDetailsList.get(0);
            } else {
                synchronizationDetailsElement = new Element(this.config.getString("xml.errorMessage.details.synchronizationDetails.xmlName"));
                this.detailsElement.addContent((Content)synchronizationDetailsElement);
            }
            synchronizationDetailsElement.removeChildren(this.config.getString("xml.errorMessage.details.synchronizationDetails.type.xmlName"));
            Element typeElement = new Element(this.config.getString("xml.errorMessage.details.synchronizationDetails.type.xmlName"));
            typeElement.setText(eventTypeString);
            synchronizationDetailsElement.addContent((Content)typeElement);
            synchronizationDetailsElement.removeChildren(this.config.getString("xml.errorMessage.details.synchronizationDetails.unitName.xmlName"));
            Element unitNameElement = new Element(this.config.getString("xml.errorMessage.details.synchronizationDetails.unitName.xmlName"));
            unitNameElement.setText(unitName);
            synchronizationDetailsElement.addContent((Content)unitNameElement);
            synchronizationDetailsElement.removeChildren(this.config.getString("xml.errorMessage.details.synchronizationDetails.startTime.xmlName"));
            Element startTimeElement = new Element(this.config.getString("xml.errorMessage.details.synchronizationDetails.startTime.xmlName"));
            startTimeElement.setText(startTime.getTimeString());
            synchronizationDetailsElement.addContent((Content)startTimeElement);
            synchronizationDetailsElement.removeChildren(this.config.getString("xml.errorMessage.details.synchronizationDetails.endTime.xmlName"));
            Element endTimeElement = new Element(this.config.getString("xml.errorMessage.details.synchronizationDetails.endTime.xmlName"));
            endTimeElement.setText(endTime.getTimeString());
            synchronizationDetailsElement.addContent((Content)endTimeElement);
        }
    }

    public String toString() {
        XMLOutputter xmlOut = new XMLOutputter();
        Format format = this.config.getBoolean("xml.formatted") ? Format.getPrettyFormat() : Format.getCompactFormat();
        format.setEncoding("ISO-8859-1");
        xmlOut.setFormat(format);
        String xmlData = xmlOut.outputString(this.doc);
        return xmlData;
    }
}

