/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Range {
    private static final Log log = LogFactory.getLog(Range.class);
    private long from = 0L;
    private long until = 0L;
    private String rangeString = "0;0";

    public Range() {
    }

    public Range(String rangeString) throws IllegalArgumentException {
        this.rangeString = rangeString;
        this.splitRangeString(rangeString);
    }

    public Range(long from, long until) {
        this.from = from;
        this.until = until;
        this.rangeString = this.buildRangeString(from, until);
    }

    private void splitRangeString(String rangeString) throws IllegalArgumentException {
        if (rangeString.equals("-1")) {
            this.from = -1L;
            this.until = -1L;
        } else {
            String[] split = rangeString.split(";");
            if (split.length == 2) {
                this.from = Long.parseLong(split[0]);
                this.until = Long.parseLong(split[1]);
            } else {
                throw new IllegalArgumentException("range contains more or less than 2 parts");
            }
        }
    }

    private String buildRangeString(long from, long until) {
        StringBuilder builder = new StringBuilder();
        builder.append(from);
        builder.append(";");
        builder.append(until);
        return builder.toString();
    }

    public long getFrom() {
        return this.from;
    }

    public void setFrom(long from) {
        this.from = from;
        this.rangeString = this.buildRangeString(from, this.until);
    }

    public long getUntil() {
        return this.until;
    }

    public void setUntil(long until) {
        this.until = until;
        this.rangeString = this.buildRangeString(this.from, until);
    }

    public String getRangeString() {
        return this.rangeString;
    }

    public void setRangeString(String rangeString) {
        this.rangeString = rangeString;
        this.splitRangeString(rangeString);
    }

    public String toString() {
        return this.rangeString;
    }
}

