/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.util;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheValue;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.UnitHelper;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageHelper {
    private static final Log log = LogFactory.getLog(MessageHelper.class);

    public static SerializableEventWrapper getSerializableEventWrapper(Message msg) {
        try {
            Serializable _object = ((ObjectMessage)msg).getObject();
            SerializableEventWrapper wrapper = (SerializableEventWrapper)_object;
            return wrapper;
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
            return null;
        }
    }

    public static long getMessageId(Message msg) {
        SerializableEventWrapper wrapper = MessageHelper.getSerializableEventWrapper(msg);
        if (wrapper.get_typeOfEvent().equals("GeoStructHistoryAndCache") || wrapper.get_typeOfEvent().equals("StateEventHistoryAndCache")) {
            return wrapper.get_PkGdataHistoryPre();
        }
        if (wrapper.get_typeOfEvent().equals("InfomanNotifyMessages")) {
            return wrapper.get_notifyHistoryId();
        }
        return 0L;
    }

    public static boolean isSendData(Message msg) {
        SerializableEventWrapper wrapper = MessageHelper.getSerializableEventWrapper(msg);
        if (wrapper.get_typeOfEvent().equals("GeoStructHistoryAndCache")) {
            GeoStruct geo = (GeoStruct)wrapper.get_cacheValue();
            return UnitHelper.isSendData(geo.getUnitId());
        }
        if (wrapper.get_typeOfEvent().equals("StateEventHistoryAndCache")) {
            CurrentStateCacheValue stateCache = (CurrentStateCacheValue)wrapper.get_cacheValue();
            return UnitHelper.isSendData(stateCache.getUnitId());
        }
        if (wrapper.get_typeOfEvent().equals("InfomanNotifyMessages")) {
            NotifyHistoryValue stateHistory = (NotifyHistoryValue)wrapper.get_historyValue();
            return UnitHelper.isSendData(stateHistory.getUnitId());
        }
        log.error((Object)"the message contains an invalid event type");
        return false;
    }
}

