/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacade;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryPK;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryValue;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.MessageNotSentException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TOWhileSyncException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TooMuchDataException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.UnknownNotifyException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler.AbstractHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.ClientConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Enums;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Range;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Timestamp;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.UnitHelper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.BeginStockPart;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.EndStockPart;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.TelemetryDataMessage;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.TelemetryDataMessages;
import de.proveo.wwt.logic.web.data.TelemetryFastLaneReader;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotifyHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(NotifyHandler.class);
    private ClientConfiguration config = ClientConfiguration.getInstance();
    private static NotifyHandler notifyHandler = null;
    private boolean discardOldMessages = false;
    private boolean synchronizing = false;
    private long lastSentMessageId = -1L;
    private NotifyHistoryLocalHome notifyHistoryLocalHome;
    private NotifyFacade notifyFacade;
    private TelemetryFastLaneReader fastLaneTelemetry = new TelemetryFastLaneReader();

    private NotifyHandler() {
        try {
            this.notifyHistoryLocalHome = NotifyHistoryUtil.getLocalHome();
            InitialContext ctx = new InitialContext();
            Object obj = ctx.lookup("NotifyFacade");
            NotifyFacadeHome notifyFacadeHome = (NotifyFacadeHome)PortableRemoteObject.narrow((Object)obj, NotifyFacadeHome.class);
            this.notifyFacade = notifyFacadeHome.create();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public static NotifyHandler getInstance() {
        if (notifyHandler == null) {
            notifyHandler = new NotifyHandler();
        }
        return notifyHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEvent(SerializableEventWrapper wrapper) throws MessageNotSentException {
        log.debug((Object)"handle event");
        NotifyHistoryValue notifyHistory = (NotifyHistoryValue)wrapper.get_historyValue();
        if (notifyHistory != null) {
            boolean sendData = UnitHelper.isSendData(notifyHistory.getUnitId());
            try {
                TelemetryDataMessage xmlMsg = new TelemetryDataMessage(notifyHistory);
                long messageID = notifyHistory.getId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("handleEvent() - messageId: " + messageID + " unitId: " + notifyHistory.getUnitId()));
                }
                if (sendData) {
                    log.debug((Object)("pushStatus: " + xmlMsg.toString()));
                    this.sendTextMessage(xmlMsg.toString());
                    return;
                }
                if (!log.isTraceEnabled()) return;
                log.trace((Object)("status event " + messageID + " not sent: " + xmlMsg.toString()));
                return;
            }
            catch (UnknownNotifyException e) {
                log.debug((Object)("don't send unknown notify:" + e.getNotifyMessageID()));
                return;
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                throw new MessageNotSentException();
            }
        } else {
            log.error((Object)"notifyCacheValue is null");
        }
    }

    public void pushCache(long minId) throws TOWhileSyncException {
        block13: {
            try {
                ArrayList<CurrentNotifyCacheValue> col = this.notifyFacade.getAllUnitEventsFromCacheSortedByHistoryId();
                Iterator it = col.iterator();
                long maxId = 0L;
                while (it.hasNext()) {
                    boolean sendData;
                    CurrentNotifyCacheValue notifyCacheValue = (CurrentNotifyCacheValue)it.next();
                    long pk = notifyCacheValue.getHistoryId();
                    if (pk <= 0L || !(sendData = UnitHelper.isSendData(notifyCacheValue.getUnitId()))) continue;
                    if (pk < minId) {
                        minId = pk;
                    }
                    if (pk <= maxId) continue;
                    maxId = pk;
                }
                Range includedData = new Range(minId, maxId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"beginNotifyStock");
                }
                BeginStockPart beginStockPart = new BeginStockPart(Enums.EventType.NOTIFY);
                this.sendTextMessage(beginStockPart.toString());
                it = col.iterator();
                int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
                while (it.hasNext()) {
                    TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.NOTIFY);
                    int count = 0;
                    while (count < maxMessageCount && it.hasNext()) {
                        boolean sendData;
                        NotifyHistoryValue notifyHistoryValue;
                        CurrentNotifyCacheValue notifyCacheValue = (CurrentNotifyCacheValue)it.next();
                        long id = notifyCacheValue.getHistoryId();
                        if (id <= 0L || (notifyHistoryValue = this.notifyFacade.getNotifyHistoryValue(id)) == null || !(sendData = UnitHelper.isSendData(notifyHistoryValue.getUnitId()))) continue;
                        try {
                            TelemetryDataMessage basicDataMessage = new TelemetryDataMessage(notifyHistoryValue);
                            xmlMsgs.add(basicDataMessage);
                            ++count;
                            this.lastSentMessageId = id;
                        }
                        catch (UnknownNotifyException e) {
                            log.debug((Object)("don't send unknown notify:" + e.getNotifyMessageID()));
                        }
                    }
                    if (xmlMsgs.isEmpty()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("pushNotifyStockPart: " + xmlMsgs.toString()));
                    }
                    this.sendTextMessage(xmlMsgs.toString());
                }
                this.setSynchronizing(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("endNotifyStock: " + includedData));
                }
                EndStockPart endStockPart = new EndStockPart(Enums.EventType.NOTIFY, includedData.getFrom(), includedData.getUntil());
                this.sendTextMessage(endStockPart.toString());
            }
            catch (RemoteException e) {
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while synchronization. Syncronization aborted.");
                }
                log.error((Object)"runs into", (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                if (!this.isTimeoutException(e)) break block13;
                throw new TOWhileSyncException("Transaction timed out while synchronization. Synchronization aborted.");
            }
        }
    }

    public long getMaxHistoryId() throws TOWhileSyncException {
        try {
            log.debug((Object)"try getMaxHistoryId...");
            return this.notifyHistoryLocalHome.getMaxHistoryId();
        }
        catch (Exception e) {
            if (this.isTimeoutException(e)) {
                throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
            }
            log.error((Object)"getMaxHistoryId runs into", (Throwable)e);
            return -1L;
        }
    }

    public NotifyHistoryLocal getNotifyHistory(long id) throws TOWhileSyncException {
        try {
            return this.notifyHistoryLocalHome.findByPrimaryKey(new NotifyHistoryPK(id));
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        catch (FinderException e) {
            if (this.isTimeoutException(e)) {
                throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
            }
            log.error((Object)"runs into", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            if (this.isTimeoutException(e)) {
                throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
            }
            log.error((Object)"runs into", (Throwable)e);
            return null;
        }
    }

    public TelemetryDataMessages getStockPart(long from, long until) throws TOWhileSyncException {
        long requestedUntil = until;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNotifyStockPart from " + from + " until " + until));
        }
        long maxHistoryId = this.getMaxHistoryId();
        TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.NOTIFY);
        until = requestedUntil;
        int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
        if (until > from + (long)maxMessageCount) {
            until = from + (long)maxMessageCount;
        }
        if (until > maxHistoryId) {
            until = maxHistoryId;
        }
        List<NotificationDTO> list = this.fastLaneTelemetry.getNotifyHistory(from, until);
        for (NotificationDTO notificationDTO : list) {
            if (notificationDTO == null) continue;
            try {
                boolean sendData = UnitHelper.isSendData(notificationDTO.getUnitId());
                if (!sendData) continue;
                xmlMsgs.add(new TelemetryDataMessage(notificationDTO));
            }
            catch (UnknownNotifyException e) {
                log.debug((Object)("don't send unknown notify:" + e.getNotifyMessageID()));
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                }
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        if (xmlMsgs.isEmpty()) {
            xmlMsgs.setIncludedData("-1");
            return xmlMsgs;
        }
        xmlMsgs.setFrom(from);
        xmlMsgs.setUntil(until);
        return xmlMsgs;
    }

    public TelemetryDataMessages getNotifiesForUnit(String unitName, Timestamp startTime, Timestamp endTime) throws TOWhileSyncException, TooMuchDataException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNotifiesForUnit for unit " + unitName + " from " + startTime.getTimestamp() + " until " + endTime.getTimestamp()));
        }
        TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.NOTIFY);
        try {
            long unitId = UnitHelper.getUnitId(unitName);
            log.debug((Object)("unitId: " + unitId));
            Collection notifyHistoryCol = this.notifyHistoryLocalHome.findByUnitIdSorted(unitId, startTime.getTimestamp(), endTime.getTimestamp(), true);
            int size = notifyHistoryCol.size();
            log.debug((Object)("notifyHistoryCol.size: " + size));
            int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
            if (size > maxMessageCount) {
                throw new TooMuchDataException();
            }
            for (NotifyHistoryLocal notifyHistory : notifyHistoryCol) {
                if (notifyHistory == null) continue;
                try {
                    boolean sendData;
                    NotifyHistoryValue notifyEvent = notifyHistory.getNotifyHistoryValue();
                    if (notifyEvent == null || !(sendData = UnitHelper.isSendData(notifyEvent.getUnitId()))) continue;
                    xmlMsgs.add(new TelemetryDataMessage(notifyEvent));
                }
                catch (Exception e) {
                    log.error((Object)"runs into", (Throwable)e);
                    if (this.isTimeoutException(e)) {
                        throw new TOWhileSyncException("Transaction timed out while synchronization. Synchronization aborted.");
                    }
                    log.error((Object)"runs into", (Throwable)e);
                }
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return xmlMsgs;
    }

    public boolean isDiscardOldMessages() {
        return this.discardOldMessages;
    }

    public void setDiscardOldMessages(boolean discardOldMessages) {
        this.discardOldMessages = discardOldMessages;
    }

    public boolean isSynchronizing() {
        return this.synchronizing;
    }

    public void setSynchronizing(boolean synchronizing) {
        this.synchronizing = synchronizing;
    }

    public long getLastSentMessageId() {
        return this.lastSentMessageId;
    }

    public void setLastSentMessageId(long lastSentMessageId) {
        this.lastSentMessageId = lastSentMessageId;
    }

    public static void undeploy() {
        if (notifyHandler != null) {
            notifyHandler.shutDownQueue();
            notifyHandler = null;
        }
    }
}

