/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.geo.history.GdataHistoryHome;
import de.proveo.wwt.logic.ejb.geo.history.GdataHistoryUtil;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.MessageDistributor;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataErrorLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataErrorUtil;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataMessageSenderLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataMessageSenderUtil;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TOWhileSyncException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TooMuchDataException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler.GeoHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler.NotifyHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler.StateHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.ClientConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Enums;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Range;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Timestamp;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.BeginStockPart;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.EndStockPart;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.ErrorMessage;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.SAXDocument;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.TelemetryDataMessages;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelemetryDataStockBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(TelemetryDataStockBean.class);
    private ClientConfiguration config = ClientConfiguration.getInstance();
    private TelemetryDataMessageSenderLocal messageSender;
    private TelemetryDataErrorLocal telemetryDataErrorBean;
    private GdataHistoryHome gdataHistoryHome;

    public void ejbCreate() throws CreateException {
        try {
            this.messageSender = TelemetryDataMessageSenderUtil.getLocalHome().create();
            this.gdataHistoryHome = GdataHistoryUtil.getHome();
            this.telemetryDataErrorBean = TelemetryDataErrorUtil.getLocalHome().create();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public void requestStateStock(String whichData) {
        Range range = new Range(whichData);
        this.requestStateStock(range.getFrom(), range.getUntil());
    }

    public void requestStateStock(long from, long until) {
        log.debug((Object)("requestStateStock " + from + "," + until));
        StateHandler stateHandler = StateHandler.getInstance();
        try {
            TelemetryDataMessages stockPart = stateHandler.getStockPart(from, until);
            this.messageSender.sendTextMessage(stockPart.toString());
        }
        catch (TOWhileSyncException e) {
            log.error((Object)"runs into", (Throwable)e);
            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.TIMEOUT, "%1s", new SAXDocument(""));
            Range whichData = new Range(from, until);
            errMsg.setSynchronizationDetails(Enums.EventType.STATE, whichData.toString());
            this.telemetryDataErrorBean.sendErrorMessage(errMsg);
        }
    }

    public void requestStatesForUnit(String unitName, Timestamp startTime, Timestamp endTime) throws TooMuchDataException {
        log.debug((Object)("requestStatesForUnit for unit " + unitName + " from " + startTime.getTimestamp() + " until " + endTime.getTimestamp()));
        StateHandler stateHandler = StateHandler.getInstance();
        try {
            TelemetryDataMessages stockPart = stateHandler.getStatesForUnit(unitName, startTime, endTime);
            this.messageSender.sendTextMessage(stockPart.toString());
        }
        catch (TOWhileSyncException e) {
            log.error((Object)"runs into", (Throwable)e);
            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.TIMEOUT, "%1s", new SAXDocument(""));
            errMsg.setSynchronizationDetails(Enums.EventType.STATE, unitName, startTime, endTime);
            this.telemetryDataErrorBean.sendErrorMessage(errMsg);
        }
    }

    public void requestGeoStock(String whichData) {
        Range range = new Range(whichData);
        this.requestGeoStock(range.getFrom(), range.getUntil());
    }

    public void requestGeoStock(long from, long until) {
        log.debug((Object)("requestGeoStock " + from + "," + until));
        try {
            TelemetryDataMessages stockPart = GeoHandler.getInstance().getStockPart(from, until);
            this.messageSender.sendTextMessage(stockPart.toString());
        }
        catch (TOWhileSyncException e) {
            log.error((Object)"runs into", (Throwable)e);
            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.TIMEOUT, "%1s", new SAXDocument(""));
            Range whichData = new Range(from, until);
            errMsg.setSynchronizationDetails(Enums.EventType.GEO, whichData.toString());
            this.telemetryDataErrorBean.sendErrorMessage(errMsg);
        }
    }

    public void requestGeosForUnit(String unitName, Timestamp startTime, Timestamp endTime) throws TooMuchDataException {
        log.debug((Object)("requestGeosForUnit for unit " + unitName + " from " + startTime.getTimestamp() + " until " + endTime.getTimestamp()));
        GeoHandler geoHandler = GeoHandler.getInstance();
        try {
            TelemetryDataMessages stockPart = geoHandler.getGeosForUnit(unitName, startTime, endTime);
            this.messageSender.sendTextMessage(stockPart.toString());
        }
        catch (TOWhileSyncException e) {
            log.error((Object)"runs into", (Throwable)e);
            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.TIMEOUT, "%1s", new SAXDocument(""));
            errMsg.setSynchronizationDetails(Enums.EventType.GEO, unitName, startTime, endTime);
            this.telemetryDataErrorBean.sendErrorMessage(errMsg);
        }
    }

    public void requestNotifyStock(String whichData) {
        Range range = new Range(whichData);
        this.requestNotifyStock(range.getFrom(), range.getUntil());
    }

    public void requestNotifyStock(long from, long until) {
        log.debug((Object)("requestNotifyStock " + from + "," + until));
        NotifyHandler notifyHandler = NotifyHandler.getInstance();
        try {
            TelemetryDataMessages stockPart = notifyHandler.getStockPart(from, until);
            this.messageSender.sendTextMessage(stockPart.toString());
        }
        catch (TOWhileSyncException e) {
            log.error((Object)"runs into", (Throwable)e);
            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.TIMEOUT, "%1s", new SAXDocument(""));
            Range whichData = new Range(from, until);
            errMsg.setSynchronizationDetails(Enums.EventType.NOTIFY, whichData.toString());
            this.telemetryDataErrorBean.sendErrorMessage(errMsg);
        }
    }

    public void requestNotifiesForUnit(String unitName, Timestamp startTime, Timestamp endTime) throws TooMuchDataException {
        log.debug((Object)("requestNotifiesForUnit for unit " + unitName + " from " + startTime.getTimestamp() + " until " + endTime.getTimestamp()));
        NotifyHandler notifyHandler = NotifyHandler.getInstance();
        try {
            TelemetryDataMessages stockPart = notifyHandler.getNotifiesForUnit(unitName, startTime, endTime);
            this.messageSender.sendTextMessage(stockPart.toString());
        }
        catch (TOWhileSyncException e) {
            log.error((Object)"runs into", (Throwable)e);
            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.TIMEOUT, "%1s", new SAXDocument(""));
            errMsg.setSynchronizationDetails(Enums.EventType.NOTIFY, unitName, startTime, endTime);
            this.telemetryDataErrorBean.sendErrorMessage(errMsg);
        }
    }

    public void synchronizeState(long lastStateId) throws TOWhileSyncException {
        if (log.isInfoEnabled()) {
            log.info((Object)("synchronizeState(" + lastStateId + ")"));
        }
        MessageDistributor messageDistributor = MessageDistributor.getInstance();
        StateHandler stateHandler = StateHandler.getInstance();
        messageDistributor.stop();
        stateHandler.setSynchronizing(true);
        stateHandler.setDiscardOldMessages(true);
        long maxHistoryId = stateHandler.getMaxHistoryId();
        log.debug((Object)("lastMessageId=" + lastStateId));
        log.debug((Object)("maxHistoryId=" + maxHistoryId));
        if (lastStateId == 0L) {
            log.error((Object)"lastMessageId = 0");
            stateHandler.pushCache(maxHistoryId);
        } else if (lastStateId > -1L) {
            Range includedData = lastStateId < maxHistoryId ? new Range(lastStateId + 1L, maxHistoryId) : new Range("-1");
            if (log.isDebugEnabled()) {
                log.debug((Object)"beginStateStock");
            }
            BeginStockPart beginStockPart = new BeginStockPart(Enums.EventType.STATE);
            this.messageSender.sendTextMessage(beginStockPart.toString());
            int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
            for (long i = lastStateId + 1L; i <= maxHistoryId; i += (long)maxMessageCount) {
                long until = i + (long)maxMessageCount < maxHistoryId ? i + (long)maxMessageCount : maxHistoryId;
                TelemetryDataMessages stockPart = stateHandler.getStockPart(i, until);
                String xml = stockPart.toString();
                if (xml.length() > 0 && !stockPart.getIncludedData().equals("-1")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("pushTeilBestandState: " + xml));
                    }
                    this.messageSender.sendTextMessage(xml);
                    stateHandler.setLastSentMessageId(stockPart.getUntil());
                    continue;
                }
                log.debug((Object)"TeilBestand is empty");
            }
            stateHandler.setSynchronizing(false);
            log.info((Object)"state synchronization completed");
            if (log.isDebugEnabled()) {
                log.debug((Object)("endStateStock: " + includedData));
            }
            EndStockPart endStockPart = new EndStockPart(Enums.EventType.STATE, includedData.getFrom(), includedData.getUntil());
            this.messageSender.sendTextMessage(endStockPart.toString());
        } else {
            stateHandler.pushCache(maxHistoryId);
        }
    }

    public void synchronizeGeo(long lastGeoId) throws TOWhileSyncException {
        if (log.isInfoEnabled()) {
            log.info((Object)("synchronizeGeo(" + lastGeoId + ")"));
        }
        MessageDistributor messageDistributor = MessageDistributor.getInstance();
        GeoHandler geoHandler = GeoHandler.getInstance();
        messageDistributor.stop();
        geoHandler.setSynchronizing(true);
        geoHandler.setDiscardOldMessages(true);
        String whichData = "";
        long maxHistoryId = geoHandler.getMaxHistoryId();
        log.debug((Object)("lastMessageId=" + lastGeoId));
        log.debug((Object)("maxHistoryId=" + maxHistoryId));
        if (lastGeoId == 0L) {
            log.error((Object)"lastMessageId = 0");
            geoHandler.pushCache(maxHistoryId);
        } else if (lastGeoId > -1L) {
            Range includedData = lastGeoId < maxHistoryId ? new Range(lastGeoId + 1L, maxHistoryId) : new Range("-1");
            if (log.isDebugEnabled()) {
                log.debug((Object)"beginGeoStock");
            }
            BeginStockPart beginStockPart = new BeginStockPart(Enums.EventType.GEO);
            this.messageSender.sendTextMessage(beginStockPart.toString());
            int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
            for (long i = lastGeoId + 1L; i <= maxHistoryId; i += (long)maxMessageCount) {
                long until = i + (long)maxMessageCount < maxHistoryId ? i + (long)maxMessageCount : maxHistoryId;
                TelemetryDataMessages stockPart = geoHandler.getStockPart(i, until);
                String xml = stockPart.toString();
                if (xml.length() > 0 && !stockPart.getIncludedData().equals("-1")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("pushTeilBestandGeo: " + xml));
                    }
                    this.messageSender.sendTextMessage(xml);
                    geoHandler.setLastSentMessageId(stockPart.getUntil());
                    continue;
                }
                log.debug((Object)"TeilBestand is empty");
            }
            geoHandler.setSynchronizing(false);
            log.info((Object)"geo synchronization completed");
            if (log.isDebugEnabled()) {
                log.debug((Object)("endGeoStock: " + whichData));
            }
            EndStockPart endStockPart = new EndStockPart(Enums.EventType.GEO, includedData.getFrom(), includedData.getUntil());
            this.messageSender.sendTextMessage(endStockPart.toString());
        } else {
            geoHandler.pushCache(maxHistoryId);
        }
    }

    public void synchronizeNotify(long lastNotifyId) throws TOWhileSyncException {
        if (log.isInfoEnabled()) {
            log.info((Object)("synchronizeNotify(" + lastNotifyId + ")"));
        }
        MessageDistributor messageDistributor = MessageDistributor.getInstance();
        NotifyHandler notifyHandler = NotifyHandler.getInstance();
        messageDistributor.stop();
        notifyHandler.setSynchronizing(true);
        notifyHandler.setDiscardOldMessages(true);
        String whichData = "";
        long maxHistoryId = notifyHandler.getMaxHistoryId();
        log.debug((Object)("lastMessageId=" + lastNotifyId));
        log.debug((Object)("maxHistoryId=" + maxHistoryId));
        if (lastNotifyId == 0L) {
            log.error((Object)"lastMessageId = 0");
            notifyHandler.pushCache(maxHistoryId);
        } else if (lastNotifyId > -1L) {
            Range includedData = lastNotifyId < maxHistoryId ? new Range(lastNotifyId + 1L, maxHistoryId) : new Range("-1");
            if (log.isDebugEnabled()) {
                log.debug((Object)"beginNotifyStock");
            }
            BeginStockPart beginStockPart = new BeginStockPart(Enums.EventType.NOTIFY);
            this.messageSender.sendTextMessage(beginStockPart.toString());
            int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
            for (long i = lastNotifyId + 1L; i <= maxHistoryId; i += (long)maxMessageCount) {
                long until = i + (long)maxMessageCount < maxHistoryId ? i + (long)maxMessageCount : maxHistoryId;
                TelemetryDataMessages stockPart = notifyHandler.getStockPart(i, until);
                String xml = stockPart.toString();
                if (xml.length() > 0 && !stockPart.getIncludedData().equals("-1")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("pushTeilBestandNotify: " + xml));
                    }
                    this.messageSender.sendTextMessage(xml);
                    notifyHandler.setLastSentMessageId(stockPart.getUntil());
                    continue;
                }
                log.debug((Object)"TeilBestand is empty");
            }
            notifyHandler.setSynchronizing(false);
            log.info((Object)"notify synchronization completed");
            if (log.isDebugEnabled()) {
                log.debug((Object)("endNotifyStock: " + whichData));
            }
            EndStockPart endStockPart = new EndStockPart(Enums.EventType.NOTIFY, includedData.getFrom(), includedData.getUntil());
            this.messageSender.sendTextMessage(endStockPart.toString());
        } else {
            notifyHandler.pushCache(maxHistoryId);
        }
    }
}

