/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData;

import de.proveo.util.ejb.BaseSessionBean;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.mx.util.MBeanServerLocator;

public class TelemetryDataMessageSenderBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(TelemetryDataMessageSenderBean.class);
    public static final String QUEUE_NAME = "queue/telemetryDataOutQueue";
    private transient QueueConnectionFactory queueConnectionFactory;
    private transient QueueConnection queueConnection;
    protected transient QueueSender queueSender;
    protected transient QueueSession queueSession;

    public void ejbCreate() throws CreateException {
        this.initializeQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeQueue() {
        try {
            Queue queue;
            InitialContext ctx = new InitialContext();
            this.queueConnectionFactory = (QueueConnectionFactory)ctx.lookup("ConnectionFactory");
            this.queueConnection = this.queueConnectionFactory.createQueueConnection();
            this.queueSession = this.queueConnection.createQueueSession(false, 1);
            try {
                queue = (Queue)ctx.lookup(QUEUE_NAME);
            }
            catch (NameNotFoundException ex) {
                log.debug((Object)"queue not found, create new");
                queue = this.queueSession.createQueue(QUEUE_NAME);
                ctx.bind(QUEUE_NAME, (Object)queue);
            }
            try {
                this.queueConnection.setExceptionListener((ExceptionListener)new ExceptionListenerImpl());
                this.queueSender = this.queueSession.createSender(queue);
                return true;
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                try {
                    this.queueConnection.close();
                }
                catch (JMSException ignored) {
                }
                finally {
                    ctx.close();
                }
            }
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return false;
    }

    public void sendTextMessage(String text) {
        try {
            TextMessage msg = this.queueSession.createTextMessage(text);
            log.debug((Object)("send message to out queue: " + text));
            this.queueSender.send((Message)msg);
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public void removeAllMessages() {
        log.debug((Object)"removeAllMessages()");
        MBeanServer server = MBeanServerLocator.locateJBoss();
        try {
            server.invoke(new ObjectName("jboss.mq.destination:name=telemetryDataOutQueue,service=Queue"), "removeAllMessages", new Object[0], new String[0]);
        }
        catch (Exception e) {
            log.error((Object)"removeAllMessages runs into", (Throwable)e);
        }
    }

    private class ExceptionListenerImpl
    implements ExceptionListener {
        public static final int NUM_RETRIES = 3;

        private ExceptionListenerImpl() {
        }

        public void onException(JMSException e) {
            for (int i = 0; i < 3; ++i) {
                log.warn((Object)("Connection has problems, trying to re-create it, attempt " + (i + 1) + " ..."));
                try {
                    TelemetryDataMessageSenderBean.this.queueConnection.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                boolean setupOK = TelemetryDataMessageSenderBean.this.initializeQueue();
                if (setupOK) {
                    log.info((Object)"Connection re-established");
                    return;
                }
                log.warn((Object)"Re-creating connection failed, retrying ...");
            }
            log.error((Object)"Cannot re-establish connection, giving up ...");
        }
    }
}

