/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.MessageNotSentException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler.GeoHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler.NotifyHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler.StateHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.ClientConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.MessageHelper;
import java.io.Serializable;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageDistributor
implements MessageListener {
    private static final Log log = LogFactory.getLog(MessageDistributor.class);
    private ClientConfiguration config = ClientConfiguration.getInstance();
    private static MessageDistributor instance = null;
    public static final String QUEUE_NAME = "queue/telemetryDataBufferQueue";
    private QueueConnectionFactory connectionFactory = null;
    private QueueConnection queueConnection = null;
    private boolean stopped = true;
    private boolean ignoreMessages = true;
    private boolean onMessageRunning = false;
    private static long lastPkGdataHistory = 0L;
    private QueueSession queueSession = null;

    private MessageDistributor() {
        log.debug((Object)"MessageDistributor() - Constructor");
        this.initialize();
    }

    public static MessageDistributor getInstance() {
        if (instance == null) {
            instance = new MessageDistributor();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize() {
        log.debug((Object)"initialize");
        try {
            InitialContext ctx = new InitialContext();
            this.connectionFactory = (QueueConnectionFactory)ctx.lookup("ConnectionFactory");
            this.queueConnection = this.connectionFactory.createQueueConnection();
            try {
                Queue queue;
                this.queueConnection.setExceptionListener((ExceptionListener)new ExceptionListenerImpl());
                this.queueSession = this.queueConnection.createQueueSession(false, 1);
                try {
                    log.debug((Object)"lookup queue queue/telemetryDataBufferQueue");
                    queue = (Queue)ctx.lookup(QUEUE_NAME);
                }
                catch (NameNotFoundException ex) {
                    log.debug((Object)"queue not found, create new");
                    queue = this.queueSession.createQueue(QUEUE_NAME);
                    ctx.bind(QUEUE_NAME, (Object)queue);
                }
                QueueReceiver queueReceiver = this.queueSession.createReceiver(queue, this.getSelector());
                queueReceiver.setMessageListener((MessageListener)this);
                return true;
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                try {
                    this.queueConnection.close();
                }
                catch (JMSException jMSException) {
                }
                finally {
                    ctx.close();
                }
            }
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        this.start();
        return false;
    }

    private String getSelector() {
        String selector = "";
        if (this.config.getBoolean("state.active")) {
            selector = "TypeOfInterest= 'StateEventHistoryAndCache'";
        }
        if (this.config.getBoolean("geo.active")) {
            if (selector.length() > 0) {
                selector = selector + " OR ";
            }
            selector = selector + "TypeOfInterest='GeoStructHistoryAndCache'";
        }
        if (this.config.getBoolean("notify.active")) {
            if (selector.length() > 0) {
                selector = selector + " OR ";
            }
            selector = selector + "TypeOfInterest='InfomanNotifyMessages'";
        }
        log.debug((Object)("selector: " + selector));
        return selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        this.onMessageRunning = true;
        log.debug((Object)"onMessage()");
        if (this.stopped) {
            log.warn((Object)"onMessage called although MessageSender is stopped!");
        } else {
            log.trace((Object)"MessageSender is not stopped");
        }
        if (this.ignoreMessages) {
            log.debug((Object)"ignore messages");
        }
        if (!this.ignoreMessages && !this.stopped) {
            SerializableEventWrapper wrapper = MessageHelper.getSerializableEventWrapper(msg);
            if (wrapper.get_typeOfEvent().equals("GeoStructHistoryAndCache")) {
                long pkGdataHistoryPre = wrapper.get_PkGdataHistoryPre();
                if (pkGdataHistoryPre < lastPkGdataHistory) {
                    log.warn((Object)("new pk (" + pkGdataHistoryPre + ") is less than last pk (" + lastPkGdataHistory + ")"));
                }
                lastPkGdataHistory = pkGdataHistoryPre;
            }
            try {
                if (this.config.isClientRegistered()) {
                    this.distributeMessage(msg);
                }
            }
            catch (MessageNotSentException e) {
                log.error((Object)"runs into", (Throwable)e);
                log.info((Object)"Stopping MessageSender in cause of MessageNotSentException...");
                this.stop();
                log.info((Object)"...MessageSender stopped by itself");
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                log.info((Object)"Stopping MessageSender in cause of Exception...");
                this.stop();
                log.info((Object)"...MessageSender stopped by itself");
            }
            finally {
                this.onMessageRunning = false;
            }
        }
        this.onMessageRunning = false;
    }

    public void start() {
        if (this.stopped) {
            log.debug((Object)"start()");
            this.stopped = false;
            if (this.queueConnection == null) {
                this.initialize();
            }
            try {
                this.queueConnection.start();
            }
            catch (JMSException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        } else {
            log.debug((Object)"MessageDistributor already started.");
        }
    }

    public void stop() {
        if (!this.stopped) {
            log.debug((Object)"stop()");
            this.stopped = true;
            try {
                if (this.queueConnection != null) {
                    this.queueConnection.stop();
                }
            }
            catch (JMSException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private void distributeMessage(Message msg) throws MessageNotSentException {
        try {
            Serializable object = ((ObjectMessage)msg).getObject();
            SerializableEventWrapper event = (SerializableEventWrapper)object;
            if (log.isDebugEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("sendMessage() - ");
                stringBuilder.append("event type = ");
                stringBuilder.append(event.get_typeOfEvent());
                log.debug((Object)stringBuilder.toString());
            }
            if (event.get_typeOfEvent().equals("GeoStructHistoryAndCache") && this.config.getBoolean("geo.active")) {
                log.trace((Object)"handle geo event");
                GeoHandler geoHandler = GeoHandler.getInstance();
                if (geoHandler.isDiscardOldMessages()) {
                    log.debug((Object)"discard old messages");
                    log.debug((Object)("msgId = " + MessageHelper.getMessageId(msg)));
                    log.debug((Object)("lastSentMessageId = " + geoHandler.getLastSentMessageId()));
                    if (MessageHelper.getMessageId(msg) > geoHandler.getLastSentMessageId()) {
                        geoHandler.handleEvent(event);
                        geoHandler.setDiscardOldMessages(false);
                    } else {
                        log.debug((Object)("discard old message with id " + MessageHelper.getMessageId(msg)));
                    }
                } else {
                    log.trace((Object)"do not discard old messages");
                    geoHandler.handleEvent(event);
                }
            }
            if (event.get_typeOfEvent().equals("StateEventHistoryAndCache") && this.config.getBoolean("state.active")) {
                log.debug((Object)"handle state event");
                StateHandler stateHandler = StateHandler.getInstance();
                if (stateHandler.isDiscardOldMessages()) {
                    log.debug((Object)("msgId = " + MessageHelper.getMessageId(msg)));
                    log.debug((Object)("lastSentMessageId = " + stateHandler.getLastSentMessageId()));
                    if (MessageHelper.getMessageId(msg) > stateHandler.getLastSentMessageId()) {
                        stateHandler.handleEvent(event);
                        stateHandler.setDiscardOldMessages(false);
                    } else {
                        log.debug((Object)("discard old message with id " + MessageHelper.getMessageId(msg)));
                    }
                } else {
                    stateHandler.handleEvent(event);
                }
            }
            if (event.get_typeOfEvent().equals("InfomanNotifyMessages") && this.config.getBoolean("notify.active")) {
                log.debug((Object)"handle notify event");
                NotifyHandler notifyHandler = NotifyHandler.getInstance();
                if (notifyHandler.isDiscardOldMessages()) {
                    log.debug((Object)("msgId = " + MessageHelper.getMessageId(msg)));
                    log.debug((Object)("lastSentMessageId = " + notifyHandler.getLastSentMessageId()));
                    if (MessageHelper.getMessageId(msg) > notifyHandler.getLastSentMessageId()) {
                        notifyHandler.handleEvent(event);
                        notifyHandler.setDiscardOldMessages(false);
                    } else {
                        log.debug((Object)("discard old message with id " + MessageHelper.getMessageId(msg)));
                    }
                } else {
                    notifyHandler.handleEvent(event);
                }
            }
        }
        catch (JMSException e) {
            log.error((Object)"sendMessage() runs into", (Throwable)e);
        }
    }

    public void shutDown() {
        try {
            while (this.onMessageRunning) {
                log.info((Object)"MessageSender - Wait for finishing JMS activity.");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    log.error((Object)"MessageSender - Waiting interrupted.");
                }
            }
            if (!this.stopped) {
                log.info((Object)"MessageSender - Stopping Connection.");
                this.queueConnection.stop();
                this.stopped = true;
            }
            log.info((Object)"MessageSender - Closing QueueConnection.");
            this.queueConnection.close();
            log.info((Object)"MessageSender - Closing Session.");
            this.queueSession.close();
            log.info((Object)"MessageSender - Shutdown finished.");
        }
        catch (Exception e) {
            log.error((Object)"MessageSender - Exception while shutdown.", (Throwable)e);
        }
    }

    public boolean isIgnoreMessages() {
        return this.ignoreMessages;
    }

    public void setIgnoreMessages(boolean ignoreMessages) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setIgnoreMessages('" + ignoreMessages + "')"));
        }
        this.ignoreMessages = ignoreMessages;
    }

    public static void undeploy() {
        instance.shutDown();
        instance = null;
    }

    private class ExceptionListenerImpl
    implements ExceptionListener {
        public static final int NUM_RETRIES = 3;

        private ExceptionListenerImpl() {
        }

        public void onException(JMSException e) {
            for (int i = 0; i < 3; ++i) {
                log.warn((Object)("Connection has problems, trying to re-create it, attempt " + (i + 1) + " ..."));
                try {
                    MessageDistributor.this.queueConnection.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                boolean setupOK = MessageDistributor.this.initialize();
                if (setupOK) {
                    log.info((Object)"Connection re-established");
                    return;
                }
                log.warn((Object)"Re-creating connection failed, retrying ...");
            }
            log.error((Object)"Cannot re-establish connection, giving up ...");
        }
    }
}

