/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.maintenance;

import de.proveo.eventbase.EventResponse;
import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeUtil;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeUtil;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.ClientConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.EngineUsage;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.Timestamp;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.exceptions.UnknownReasonException;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.response.MaintenanceRespone;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.response.ObjectFactory;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryFacadeLocal;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryFacadeUtil;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.io.StringWriter;
import java.io.Writer;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class MaintenanceSessionBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(MaintenanceSessionBean.class);
    private static ClientConfiguration config = ClientConfiguration.getInstance();
    private UnitFacadeLocal unitFacade;
    private EventFacadeLocal eventFacade;
    private StateSummaryFacadeLocal stateSummaryFacade;
    protected static final long STATEMODEL_ID = 2090L;
    private static final String MAINTENANCE = "maintenance";
    private static final String REPAIR = "repair";
    private static final String WAIT_FOR_REPAIR = "waitForRepair";
    private static final String BREAKDOWN = "breakdown";
    private static final String OTHER = "other";
    private static final long HOUR = 3600000L;
    private int decimals = config.getInt("engineHours.decimals");

    public void ejbCreate() throws CreateException {
        log.debug((Object)"ejbCreate()");
        try {
            this.unitFacade = UnitFacadeUtil.getLocalHome().create();
            this.eventFacade = EventFacadeUtil.getLocalHome().create();
            this.stateSummaryFacade = StateSummaryFacadeUtil.getLocalHome().create();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public String parseXML(String xml) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Long getUnitId(String unitName) throws FinderException {
        UnitDTO unitDTO = this.unitFacade.getUnitDTOByName(unitName);
        Long unitId = unitDTO.getUnitId();
        return unitId;
    }

    public boolean setServiceStatus(long unitId, boolean available, String reason, String remark) throws UnknownReasonException, UnitNotFoundException {
        if (this.unitFacade.getUnit(unitId) == null) {
            throw new UnitNotFoundException(unitId);
        }
        Properties event = new Properties();
        event.setProperty("t", Long.toString(System.currentTimeMillis()));
        log.debug((Object)("timestamp: " + System.currentTimeMillis()));
        event.setProperty("u", Long.toString(unitId));
        log.debug((Object)("unitId: " + unitId));
        event.setProperty("m", Long.toString(2090L));
        log.debug((Object)"stateModel: 2090");
        long stateId = this.getStateId(available, reason);
        log.debug((Object)("stateId: " + stateId));
        event.setProperty("s", Long.toString(stateId));
        log.debug((Object)("stateId: " + stateId));
        if (remark != null && !remark.trim().equals("")) {
            event.setProperty("c", remark);
        }
        try {
            EventResponse eventResponse = this.eventFacade.handleEvent(event);
            log.debug((Object)("event response: " + eventResponse));
            return eventResponse.isEventResponse();
        }
        catch (NoSuchElementException e) {
            log.error((Object)"runs into", (Throwable)e);
            return false;
        }
    }

    public boolean setServiceStatus(String unitName, boolean available, String reason, String remark) throws UnknownReasonException, UnitNotFoundException {
        try {
            UnitDTO unitDTO = this.unitFacade.getUnitDTOByName(unitName);
            long unitId = unitDTO.getUnitId();
            return this.setServiceStatus(unitId, available, reason, remark);
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
            throw new UnitNotFoundException(unitName);
        }
    }

    private long getStateId(boolean available, String reason) throws UnknownReasonException {
        if (available) {
            return 2091L;
        }
        if (reason.equals(MAINTENANCE)) {
            return 2092L;
        }
        if (reason.equals(REPAIR)) {
            return 2093L;
        }
        if (reason.equals(WAIT_FOR_REPAIR)) {
            return 2094L;
        }
        if (reason.equals(BREAKDOWN)) {
            return 2096L;
        }
        if (reason.equals(OTHER)) {
            return 2095L;
        }
        log.warn((Object)("reason (" + reason + ") is unknown."));
        throw new UnknownReasonException(reason);
    }

    private String createEngineHoursResponse(long msgId, Long unitId, Timestamp startTime, Timestamp endTime) {
        EngineUsage engineUsage;
        try {
            engineUsage = this.getEngineUsage(unitId, startTime, endTime);
        }
        catch (UnitNotFoundException e) {
            log.error((Object)"runs into", (Throwable)e);
            return this.createErrorMessage(msgId, ErrorCodes.UnitNotFound, Long.toString(unitId));
        }
        try {
            StringWriter writer = new StringWriter();
            MaintenanceRespone response = new MaintenanceRespone();
            ObjectFactory objectFactory = new ObjectFactory();
            MaintenanceRespone.EngineHourField engineHourField = objectFactory.createMaintenanceResponeEngineHourField();
            engineHourField.setEngineHours(engineUsage.getHours());
            engineHourField.setStartTime(engineUsage.getFrom().toString());
            engineHourField.setEndTime(engineUsage.getUntil().toString());
            engineHourField.setProveoUnitId(unitId);
            UnitDTO unitDTO = this.unitFacade.getUnit(unitId);
            String unitName = unitDTO.getUnitName();
            engineHourField.setUnitName(unitName);
            response.setEngineHourField(engineHourField);
            response.setId(msgId);
            response.setSuccessful(true);
            JAXBContext jc = JAXBContext.newInstance((String)"de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.response", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)config.getBoolean("xml.formatted"));
            marshaller.marshal((Object)response, (Writer)writer);
            writer.flush();
            return writer.toString();
        }
        catch (JAXBException e) {
            log.error((Object)"runs into", (Throwable)e);
            return this.createErrorMessage(msgId, ErrorCodes.XMLResponse, e.getCause().getMessage());
        }
    }

    private String createEmptyResponse(long msgId, boolean successful) {
        StringWriter writer = new StringWriter();
        MaintenanceRespone response = new MaintenanceRespone();
        response.setSuccessful(successful);
        response.setId(msgId);
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.response", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)config.getBoolean("xml.formatted"));
            marshaller.marshal((Object)response, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            log.error((Object)"runs into", (Throwable)e);
            return this.createErrorMessage(msgId, ErrorCodes.XMLResponse, "Could not create response: " + e.getMessage());
        }
    }

    private String createErrorMessage(long msgId, ErrorCodes errorCode, String detail) {
        try {
            StringWriter writer = new StringWriter();
            MaintenanceRespone response = new MaintenanceRespone();
            response.setSuccessful(false);
            response.setId(msgId);
            ObjectFactory objectFactory = new ObjectFactory();
            MaintenanceRespone.Error error = objectFactory.createMaintenanceResponeError();
            switch (errorCode) {
                case UnitNotFound: {
                    error.setCode("UnitNotFound");
                    error.setMessage("Could not find unit: " + detail);
                    break;
                }
                case UnknownReason: {
                    error.setCode("UnknownReason");
                    error.setMessage("Unknown reason: " + detail);
                    break;
                }
                case TimeFormat: {
                    error.setCode("TimeFormat");
                    error.setMessage("Incorrect time format: " + detail);
                    break;
                }
                case MissingMethod: {
                    error.setCode("MissingMethod");
                    error.setMessage("XML message doesn't contain a setServiceStatus or getEngineHours element");
                    break;
                }
                case MissingParameter: {
                    error.setCode("MissingParameter");
                    error.setMessage("Parameter is missing: " + detail);
                    break;
                }
                case XMLParse: {
                    error.setCode("XMLParse");
                    error.setMessage("Could not parse XML: " + detail);
                    break;
                }
                case XMLResponse: {
                    error.setCode("XMLResponse");
                    error.setMessage("Could not create response: " + detail);
                    break;
                }
                case Unknown: {
                    error.setCode("Unknown");
                    error.setMessage("An error has occurred:  " + detail);
                }
            }
            response.setError(error);
            JAXBContext jc = JAXBContext.newInstance((String)"de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.response", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)config.getBoolean("xml.formatted"));
            marshaller.marshal((Object)response, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            return this.createErrorMessageWithJDom(errorCode, detail);
        }
    }

    private String createErrorMessageWithJDom(ErrorCodes errorCode, String detail) {
        Document doc = new Document();
        Element respone = new Element("maintenanceRespone");
        Element error = new Element("error");
        respone.addContent((Content)error);
        Element code = new Element("code");
        Element message = new Element("message");
        switch (errorCode) {
            case UnitNotFound: {
                code.setText("UnitNotFound");
                message.setText("Could not find unit: " + detail);
                break;
            }
            case UnknownReason: {
                code.setText("UnknownReason");
                message.setText("Unknown reason: " + detail);
                break;
            }
            case TimeFormat: {
                code.setText("TimeFormat");
                message.setText("Incorrect time format: " + detail);
                break;
            }
            case MissingMethod: {
                code.setText("MissingMethod");
                message.setText("XML message doesn't contain a setServiceStatus or getEngineHours element");
                break;
            }
            case MissingParameter: {
                code.setText("MissingParameter");
                message.setText("Parameter is missing: " + detail);
                break;
            }
            case XMLParse: {
                code.setText("XMLParse");
                message.setText("Could not parse XML: " + detail);
                break;
            }
            case XMLResponse: {
                code.setText("XMLResponse");
                message.setText("Could not create response: " + detail);
                break;
            }
            case Unknown: {
                code.setText("Unknown");
                message.setText("An error has occurred:  " + detail);
            }
        }
        error.addContent((Content)code);
        error.addContent((Content)message);
        XMLOutputter xmlOut = new XMLOutputter();
        return xmlOut.outputString(doc);
    }

    private double round(double number, int decimals) {
        double factor = Math.pow(10.0, decimals);
        return (double)Math.round(number * factor) / factor;
    }

    public EngineUsage getEngineUsage(long unitId, Timestamp from, Timestamp until) throws UnitNotFoundException {
        if (this.unitFacade.getUnit(unitId) == null) {
            throw new UnitNotFoundException(unitId);
        }
        log.debug((Object)("getEngineUseage " + unitId));
        long minBeginTime = this.stateSummaryFacade.getMinBeginTime(unitId, 0);
        log.debug((Object)("minBeginTime: " + minBeginTime));
        if (from == null || from.getTimestamp() < minBeginTime) {
            from.setTimestamp(minBeginTime);
        }
        if (until == null || until.getTimestamp() > System.currentTimeMillis() || until.getTimestamp() == 0L) {
            until.setTimestamp(System.currentTimeMillis());
        }
        long durationNecesary = this.stateSummaryFacade.getStateSummaryDuration(unitId, 0, 2010L, 2012L, from.getTimestamp(), until.getTimestamp());
        log.debug((Object)("duration runs necessary: " + durationNecesary));
        long durationUnNecesary = this.stateSummaryFacade.getStateSummaryDuration(unitId, 0, 2010L, 2013L, from.getTimestamp(), until.getTimestamp());
        log.debug((Object)("duration runs unnecessary: " + durationUnNecesary));
        double hours = (double)(durationNecesary + durationUnNecesary) / 3600000.0;
        hours = this.round(hours, this.decimals);
        log.debug((Object)("end getEngineUseage " + unitId));
        return new EngineUsage(hours, from, until);
    }

    public EngineUsage getEngineUsage(String unitName, Timestamp from, Timestamp until) throws UnitNotFoundException {
        try {
            UnitDTO unitDTO = this.unitFacade.getUnitDTOByName(unitName);
            long unitId = unitDTO.getUnitId();
            return this.getEngineUsage(unitId, from, until);
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
            throw new UnitNotFoundException(unitName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ErrorCodes {
        UnitNotFound,
        UnknownReason,
        TimeFormat,
        MissingMethod,
        MissingParameter,
        XMLParse,
        XMLResponse,
        Unknown;

    }
}

