/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.accessControl;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.exception.GroupNameAlreadyExistsException;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeUtil;
import de.proveo.wwt.logic.ejb.general.unit.permission.UnitPermissionValue;
import de.proveo.wwt.logic.ejb.general.use.group.GroupNotFoundException;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupValue;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import de.proveo.wwt.logic.ejb.general.use.user.UserNotFoundException;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.commonData.dto.UnitDTOList;
import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlSessionBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(AccessControlSessionBean.class);
    private UseFacadeLocal useFacadeBean;
    private UnitFacadeLocal unitFacade;

    public void ejbCreate() throws CreateException {
        log.debug((Object)"ejbCreate()");
        try {
            this.useFacadeBean = UseFacadeUtil.getLocalHome().create();
            this.unitFacade = UnitFacadeUtil.getLocalHome().create();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public boolean addGroup(String name, String description) throws CreateException {
        this.useFacadeBean.addGroup(name, description);
        return true;
    }

    public boolean updateGroup(String name, String newName, String description) throws GroupNotFoundException, GroupNameAlreadyExistsException {
        this.useFacadeBean.updateGroup(name, newName, description);
        return true;
    }

    public boolean removeGroup(String name) throws GroupNotFoundException, RemoveException {
        ArrayList<UseUserValue> useUsers = this.useFacadeBean.getUsers(name);
        this.removeUnitPermissions(useUsers);
        this.removeUsers(useUsers);
        this.useFacadeBean.removeGroup(name);
        return true;
    }

    public ArrayList<UseGroupValue> getAllGroups() {
        return this.useFacadeBean.getAllGroups();
    }

    public boolean addOperator(String name, String description, String groupName, String key) throws CreateException, GroupNotFoundException {
        this.useFacadeBean.addUser(name, description, groupName, key);
        return true;
    }

    public boolean updateOperator(String name, String description, String groupName, String key) throws UserNotFoundException, GroupNotFoundException {
        this.useFacadeBean.updateUser(name, description, groupName, key, null);
        return true;
    }

    public boolean removeOperator(String key) throws RemoveException, UserNotFoundException {
        UseUserValue useUserValue = this.useFacadeBean.getUser(this.useFacadeBean.getUserIdByKey(key));
        ArrayList<UseUserValue> al = new ArrayList<UseUserValue>();
        al.add(useUserValue);
        this.removeUnitPermissions(al);
        this.useFacadeBean.removeUserByExactKey(key);
        return true;
    }

    public ArrayList<UseUserValue> getOperatorsInGroup(String groupName) throws GroupNotFoundException {
        return this.useFacadeBean.getUsers(groupName);
    }

    public UseUserValue getOperatorByKey(String key) throws UserNotFoundException {
        return this.useFacadeBean.getUser(key);
    }

    public boolean addUnitPermission(String operatorKey, long unitId) throws UserNotFoundException, UnitNotFoundException {
        try {
            long userId = this.useFacadeBean.getUserIdByKey(operatorKey);
            this.unitFacade.setUnitPermissionForUseUser(userId, unitId, false, true);
            return true;
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (UnitNotFoundException e) {
            throw e;
        }
    }

    public boolean removeUnitPermission(String operatorKey, long unitId) throws UserNotFoundException, UnitNotFoundException {
        long userId = this.useFacadeBean.getUserIdByKey(operatorKey);
        return this.unitFacade.removeUnitPermissionForUseUser(userId, unitId, false, true);
    }

    public ArrayList<UnitPermissionValue> getUnitPermissionsForOperator(String operatorKey) throws UserNotFoundException {
        long userId = this.useFacadeBean.getUserIdByKey(operatorKey);
        ArrayList<UnitPermissionValue> unitPermissions = this.unitFacade.getUnitPermissionsByUseUserId(userId);
        return unitPermissions;
    }

    public UnitDTOList getAllUnits() {
        return this.unitFacade.getAllActiveBasicUnits();
    }

    public String getGroupName(long groupId) throws GroupNotFoundException {
        UseGroupValue useGroup = this.useFacadeBean.getGroup(groupId);
        return useGroup.getName();
    }

    public String getOperatorName(long userId) throws UserNotFoundException {
        UseUserValue user = this.useFacadeBean.getUser(userId);
        return user.getName();
    }

    public String getOperatorKey(long userId) throws UserNotFoundException {
        UseUserValue user = this.useFacadeBean.getUser(userId);
        return user.getKey();
    }

    public String getUnitName(long unitId) throws UnitNotFoundException {
        UnitDTO unit = this.unitFacade.getUnit(unitId);
        if (unit != null) {
            return unit.getUnitName();
        }
        throw new UnitNotFoundException(unitId);
    }

    public long getUnitId(String unitName) throws UnitNotFoundException {
        try {
            UnitDTO unit = this.unitFacade.getUnitDTOByName(unitName);
            return unit.getUnitId();
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
            throw new UnitNotFoundException(unitName);
        }
    }

    private void removeUnitPermissions(ArrayList<UseUserValue> useUsers) {
        for (UseUserValue useUserValue : useUsers) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove UnitPermissions for UseUser " + useUserValue.getName()));
            }
            this.unitFacade.setPermissionsByUseUserId(useUserValue.getId(), new ArrayList<UnitPermissionValue>(), true, false, true);
        }
    }

    private void removeUsers(ArrayList<UseUserValue> useUsers) {
        for (UseUserValue user : useUsers) {
            long userId = user.getId();
            this.useFacadeBean.removeUser(userId);
        }
    }
}

