/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.geo;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataOut.raw.GeoStamp;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaPK;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import de.proveo.wwt.logic.ejb.geo.cache.CurrentGdataCacheLocal;
import de.proveo.wwt.logic.ejb.geo.cache.CurrentGdataCacheLocalHome;
import de.proveo.wwt.logic.ejb.geo.cache.CurrentGdataCachePK;
import de.proveo.wwt.logic.ejb.geo.cache.CurrentGdataCacheUtil;
import de.proveo.wwt.logic.ejb.geo.exception.NoGeoFoundException;
import de.proveo.wwt.logic.ejb.geo.history.GdataHistoryLocal;
import de.proveo.wwt.logic.ejb.geo.history.GdataHistoryLocalHome;
import de.proveo.wwt.logic.ejb.geo.history.GdataHistoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeoOutFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(GeoOutFacadeBean.class);
    private CurrentGdataCacheLocalHome gdataCacheHome;
    private GdataHistoryLocalHome gdataHistoryHome;
    private AreaLocalHome areaHome;
    private UnitIdentityLocalHome unitIdentityHome;

    public void ejbCreate() throws CreateException {
        try {
            this.gdataCacheHome = CurrentGdataCacheUtil.getLocalHome();
            this.gdataHistoryHome = GdataHistoryUtil.getLocalHome();
            this.areaHome = AreaUtil.getLocalHome();
            this.unitIdentityHome = UnitIdentityUtil.getLocalHome();
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    public ArrayList getAllUnitEventsFromCacheSortedByPreviousPk() {
        ArrayList<GeoStruct> values = new ArrayList<GeoStruct>();
        try {
            Collection col = this.gdataCacheHome.findAllSortedByPk();
            for (CurrentGdataCacheLocal cache : col) {
                GeoStruct value = cache.getStruct();
                values.add(value);
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return values;
    }

    public ArrayList<GeoStruct> getAllGeoEventsFromCacheSortedbyUnitID() {
        ArrayList<GeoStruct> values = new ArrayList<GeoStruct>();
        try {
            Collection col = this.gdataCacheHome.findAllSortedByUnitID();
            for (CurrentGdataCacheLocal currentGdataCache : col) {
                GeoStruct data = currentGdataCache.getStruct();
                values.add(data);
            }
        }
        catch (FinderException e) {
            log.error((Object)".", (Throwable)e);
        }
        return values;
    }

    public GeoStruct getNewestGeoEventFromCache(long unitID) {
        GeoStruct geoStruct = null;
        try {
            CurrentGdataCacheLocal geoCache = this.gdataCacheHome.findByPrimaryKey(new CurrentGdataCachePK(unitID));
            geoStruct = geoCache.getStruct();
        }
        catch (FinderException e) {
            log.error((Object)"Found no data in cache!", (Throwable)e);
        }
        return geoStruct;
    }

    protected GeoStamp getUnitEventsFromCache(long basicUnitId, long requestedBeginTime, long requestedEndTime) throws NoGeoFoundException {
        UnitIdentityValue unitIdentityData;
        AreaValue areaStruct;
        GeoStruct geoStruct;
        String sMethodName = "getUnitEventsFromCache()";
        try {
            CurrentGdataCacheLocal geoCache = this.gdataCacheHome.findByPrimaryKey(new CurrentGdataCachePK(basicUnitId));
            geoStruct = geoCache.getStruct();
            areaStruct = this.getArea(geoStruct.getAreaId());
            unitIdentityData = this.getUnitIdentity(geoStruct.getUnitId());
        }
        catch (FinderException ex) {
            throw new NoGeoFoundException(basicUnitId, "nothing found in cache");
        }
        return new GeoStamp(geoStruct, areaStruct, unitIdentityData, requestedBeginTime, requestedEndTime);
    }

    protected HashSet getUnitEventsFromHistory(long basicUnitId, long requestedBeginTime, long requestedEndTime) throws NoGeoFoundException {
        Collection entries;
        String sMethodName = "getUnitEventsFromHistory()";
        try {
            entries = this.gdataHistoryHome.findByUnit(requestedBeginTime, requestedEndTime, basicUnitId);
        }
        catch (FinderException ex) {
            throw new NoGeoFoundException(basicUnitId, "nothing found");
        }
        HashSet<GeoStamp> geoStamps = new HashSet<GeoStamp>();
        for (GdataHistoryLocal geoHistory : entries) {
            GeoStruct geoStruct = geoHistory.getStruct();
            AreaValue areaStruct = this.getArea(geoStruct.getAreaId());
            UnitIdentityValue unitIdentityData = this.getUnitIdentity(geoStruct.getUnitId());
            GeoStamp stamp = new GeoStamp(geoStruct, areaStruct, unitIdentityData, requestedBeginTime, requestedEndTime);
            geoStamps.add(stamp);
        }
        return geoStamps;
    }

    protected AreaValue getArea(int areaId) {
        if (areaId < 0) {
            return new AreaValue("", -1, "", false, 0, 0, 0, 0, 0, false);
        }
        try {
            AreaLocal areaLocal = this.areaHome.findByPrimaryKey(new AreaPK(areaId));
            return areaLocal.getAreaValue();
        }
        catch (Exception ex) {
            String msg = "getArea() for areaId '" + areaId + "' runs into '" + ex.getMessage() + "'";
            log.error((Object)msg, (Throwable)ex);
            return new AreaValue("[unknown]", areaId, "[unknown]", false, 0, 0, 0, 0, 0, false);
        }
    }

    protected UnitIdentityValue getUnitIdentity(long unitId) {
        UnitIdentityPK pk = new UnitIdentityPK(unitId);
        try {
            UnitIdentityLocal unit = this.unitIdentityHome.findByPrimaryKey(pk);
            return unit.getUnitIdentityValue();
        }
        catch (Exception ex) {
            log.error((Object)("getUnitIdentity(): unit for ID '" + unitId + "' not found !"));
            UnitIdentityValue value = new UnitIdentityValue();
            value.setUnitId(unitId);
            value.setName("(n/a)");
            value.setUnitKind("(n/a)");
            return value;
        }
    }
}

