/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.use.unituser;

import de.proveo.eventbase.EventPayload;
import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeUtil;
import de.proveo.wwt.logic.ejb.general.unit.permission.UnitPermissionLocal;
import de.proveo.wwt.logic.ejb.general.unit.permission.UnitPermissionLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.permission.UnitPermissionUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocalHome;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnitUserBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(UnitUserBean.class);
    private UnitModelLocalHome unitModelHome;
    private UnitFacadeLocal adminUnitFacade;
    private UnitPermissionLocalHome unitPermissionHome;
    private UseUserLocalHome useUserHome;
    private static final long DEFAULT_INFOMAN_REQUEST_TIMEOUT = 600000L;
    private long infomanRequestTimeout;

    public void ejbCreate() throws CreateException {
        try {
            this.unitModelHome = UnitModelUtil.getLocalHome();
            this.adminUnitFacade = UnitFacadeUtil.getLocalHome().create();
            this.unitPermissionHome = UnitPermissionUtil.getLocalHome();
            this.useUserHome = UseUserUtil.getLocalHome();
        }
        catch (Exception ex) {
            log.error((Object)"runs during ejb lookup into", (Throwable)ex);
            throw new CreateException("runs during ejb lookup into " + ex.getMessage());
        }
        this.configure();
    }

    public Set<String> getUserKeys(long unitId) throws UnitNotFoundException {
        HashSet<String> userKeys = new HashSet<String>();
        ArrayList<Long> unitIds = this.adminUnitFacade.collectParentFolders(unitId);
        unitIds.add(unitId);
        Iterator unitIdIt = unitIds.iterator();
        while (unitIdIt.hasNext()) {
            long uId = (Long)unitIdIt.next();
            try {
                Collection permissions = this.unitPermissionHome.findByUnitIdOrGroupId(uId);
                for (UnitPermissionLocal permission : permissions) {
                    if (permission.getUseUserId() > 0L) {
                        userKeys.add(permission.getUseUser().getKey());
                        continue;
                    }
                    if (permission.getUseGroupId() <= 0L) continue;
                    for (UseUserLocal user : this.useUserHome.findByGroupId(permission.getUseGroupId())) {
                        userKeys.add(user.getKey());
                    }
                }
            }
            catch (FinderException ex) {
                log.error((Object)"runs during find permissions into", (Throwable)ex);
            }
        }
        return userKeys;
    }

    public boolean isUnitUserDataModified(long unitId) throws UnitNotFoundException {
        try {
            UnitModelLocal unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            return unitModel.getUnitUserRefresh();
        }
        catch (ObjectNotFoundException ex) {
            log.error((Object)("isUnitUserDataModified: can't find unit (id:" + unitId + ")"), (Throwable)ex);
            throw new UnitNotFoundException(unitId, (Exception)((Object)ex));
        }
        catch (Exception ex) {
            log.error((Object)"isUnitUserDataModified runs into", (Throwable)ex);
            throw new EJBException("getUserKeysOfUnit runs into" + ex.getMessage());
        }
    }

    public void updateSuccessful(long unitId) throws UnitNotFoundException {
        try {
            this.updateUnitModel(unitId, false);
        }
        catch (ObjectNotFoundException ex) {
            log.error((Object)("updateSuccessful: can't find unit (id:" + unitId + ")"), (Throwable)ex);
            throw new UnitNotFoundException(unitId, (Exception)((Object)ex));
        }
        catch (Exception ex) {
            log.error((Object)"updateSuccessful runs into", (Throwable)ex);
            throw new EJBException("updateSuccessful runs into" + ex.getMessage());
        }
    }

    public void updateUnitModel(long unitId, boolean refresh) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("updateUnitModel() untiId: " + unitId + " refresh: " + refresh));
        }
        UnitModelLocal unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
        unitModel.setUnitUserRefresh(refresh);
        if (refresh) {
            unitModel.setUnitUserSyncStartTime(0L);
        }
    }

    protected void configure() {
        try {
            this.infomanRequestTimeout = Long.parseLong(new ConfigurationClient().getParameter("infoman.aclupdate.timeout", Long.toString(600000L)));
        }
        catch (Exception ex) {
            log.error((Object)"runs during configure infoman.update.timeout into", (Throwable)ex);
            this.infomanRequestTimeout = 600000L;
        }
    }

    public boolean isACLUpdateNecessary(UnitModelLocal unitModel) {
        if (!unitModel.getUnitUserRefresh()) {
            log.trace((Object)"isACLUpdateNecessary() unitUser (ACL) refresh flag not set, no update necessary");
            return false;
        }
        long delta = System.currentTimeMillis() - unitModel.getUnitUserSyncStartTime();
        if (delta <= this.infomanRequestTimeout) {
            log.trace((Object)"isACLUpdateNecessary() update is still within timeout, no new update necessary");
            return false;
        }
        log.trace((Object)"isACLUpdateNecessary() acl update necessary");
        return true;
    }

    public EventPayload startACLUpdate(UnitModelLocal unitModel) {
        unitModel.setUnitUserSyncStartTime(System.currentTimeMillis());
        unitModel.setUnitUserSyncDone(false);
        EventPayload payload = new EventPayload();
        payload.setName("ACLUpdate");
        payload.setPayload(Long.toString(unitModel.getUnitUserSyncStartTime()).getBytes());
        return payload;
    }

    public void updateReport(long unitId, long eventTime, String updateReport) {
        long activeToken;
        UnitModelLocal unitModel;
        boolean succesful;
        Long token = null;
        String errorMessage = null;
        if (updateReport.startsWith("error")) {
            StringTokenizer tokenizer = new StringTokenizer(updateReport, ";");
            tokenizer.nextToken();
            succesful = false;
            try {
                token = Long.valueOf(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    errorMessage = tokenizer.nextToken();
                }
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"token for acl update not available");
            }
        } else {
            succesful = true;
            try {
                token = Long.valueOf(updateReport);
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"token for acl update not available");
            }
        }
        try {
            unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
        }
        catch (ObjectNotFoundException ex) {
            throw new EJBException("acl update report for unkown unit", (Exception)((Object)ex));
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        if (!unitModel.getUnitUserRefresh() || unitModel.getUnitUserSyncDone()) {
            if (log.isErrorEnabled()) {
                log.error((Object)("no open acl update found for unitId " + unitId + " and token " + updateReport + " found. unitUserRefresh: " + unitModel.getUnitUserRefresh() + " unitUserSyncDone: " + unitModel.getUnitUserSyncDone()));
            }
            return;
        }
        if (token != null && (activeToken = unitModel.getUnitUserSyncStartTime()) != token) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("token no longer active, wait. unitId " + unitId + " infomanToken: " + token + " expectedToken: " + activeToken));
            }
            unitModel.setUnitUserSyncSuccessful(false);
            unitModel.setUnitUserSyncError("invalid token");
            unitModel.setUnitUserSyncEndTime(eventTime);
            return;
        }
        unitModel.setUnitUserRefresh(false);
        unitModel.setUnitUserSyncDone(true);
        unitModel.setUnitUserSyncSuccessful(succesful);
        unitModel.setUnitUserSyncError(errorMessage);
        unitModel.setUnitUserSyncEndTime(eventTime);
    }
}

