/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.pkgen;

import de.proveo.wwt.logic.ejb.general.pkgen.Sequence;
import de.proveo.wwt.logic.ejb.general.pkgen.SequenceHome;
import de.proveo.wwt.logic.ejb.general.pkgen.SequencePK;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class SequenceProxy {
    private static final String SEQUENCE_JNDI_NAME = "Sequence";
    private long sequenceId;
    private long[] keyBuffer;
    private int nextPKIndex = 0;

    public SequenceProxy(long sequenceId, int proxySize) throws Exception {
        this.sequenceId = sequenceId;
        this.keyBuffer = this.getKeys(proxySize);
    }

    public long getNext() throws Exception {
        if (this.isEmpty()) {
            this.keyBuffer = this.getKeys(this.keyBuffer.length);
        }
        long pk = this.keyBuffer[this.nextPKIndex];
        ++this.nextPKIndex;
        return pk;
    }

    public long[] getAll() {
        long[] unused = new long[this.keyBuffer.length - this.nextPKIndex];
        for (int i = 0; i < unused.length; ++i) {
            unused[i] = this.keyBuffer[i + this.nextPKIndex];
        }
        this.nextPKIndex = this.keyBuffer.length;
        return unused;
    }

    protected boolean isEmpty() {
        return this.nextPKIndex >= this.keyBuffer.length;
    }

    protected void clearBuffer() {
        this.nextPKIndex = this.keyBuffer.length;
    }

    protected long[] getKeys(int count) throws Exception {
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup(SEQUENCE_JNDI_NAME);
            SequenceHome home = (SequenceHome)PortableRemoteObject.narrow((Object)ref, SequenceHome.class);
            Sequence sequence = null;
            try {
                sequence = home.findByPrimaryKey(new SequencePK(this.sequenceId));
            }
            catch (Exception ex) {
                sequence = home.create(this.sequenceId);
            }
            this.nextPKIndex = 0;
            return sequence.getNext(count);
        }
        catch (Exception ex) {
            throw new Exception("Runs during getKeys() into " + ex.getMessage());
        }
    }

    public void setNextId(long nextSequenceId) throws Exception {
        InitialContext ctx = new InitialContext();
        Object ref = ctx.lookup(SEQUENCE_JNDI_NAME);
        SequenceHome home = (SequenceHome)PortableRemoteObject.narrow((Object)ref, SequenceHome.class);
        Sequence sequence = null;
        try {
            sequence = home.findByPrimaryKey(new SequencePK(this.sequenceId));
        }
        catch (Exception ex) {
            sequence = home.create(this.sequenceId);
        }
        sequence.setCounter(nextSequenceId);
        this.clearBuffer();
    }
}

