/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.notification;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.general.notification.NotificationLocal;
import de.proveo.wwt.logic.ejb.general.notification.NotificationLocalHome;
import de.proveo.wwt.logic.ejb.general.notification.NotificationPK;
import de.proveo.wwt.logic.ejb.general.notification.NotificationUtil;
import de.proveo.wwt.logic.ejb.general.notification.NotificationValue;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeUtil;
import de.proveo.wwt.logic.web.common.ParameterDetails;
import de.proveo.wwt.logic.web.common.ParameterInputType;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.commonData.dto.UnitDTOList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationAdministrationFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log logger = LogFactory.getLog(NotificationAdministrationFacadeBean.class);
    private NotificationLocalHome notificationLocalHome;
    private UnitFacadeLocal unitFacade;

    public void ejbCreate() throws CreateException {
        try {
            this.notificationLocalHome = NotificationUtil.getLocalHome();
            this.unitFacade = UnitFacadeUtil.getLocalHome().create();
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public List<NotificationValue> getAllNotifications() {
        ArrayList<NotificationValue> list = null;
        try {
            Collection coll = this.notificationLocalHome.findAll();
            NotificationLocal[] arr = coll.toArray(new NotificationLocal[0]);
            list = new ArrayList<NotificationValue>(arr.length);
            for (int i = 0; i != arr.length; ++i) {
                list.add(arr[i].getNotificationValue());
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public NotificationValue getNotificationById(long id) {
        NotificationValue value = null;
        try {
            value = this.notificationLocalHome.findByPrimaryKey(new NotificationPK(id)).getNotificationValue();
        }
        catch (FinderException e) {
            logger.error((Object)("no notify message found for notifyMessageID: " + id));
        }
        return value;
    }

    public boolean saveNotification(NotificationValue value) throws DuplicateKeyException {
        try {
            this.notificationLocalHome.create(value);
            return true;
        }
        catch (CreateException e) {
            if (e instanceof DuplicateKeyException) {
                throw (DuplicateKeyException)((Object)e);
            }
            return false;
        }
    }

    public boolean updateNotification(NotificationValue value) {
        try {
            NotificationLocal notifyLocal = this.notificationLocalHome.findByPrimaryKey(new NotificationPK(value.getId()));
            notifyLocal.setNotificationValue(value);
            return true;
        }
        catch (FinderException e) {
            logger.debug((Object)"runs into", (Throwable)e);
            return false;
        }
    }

    public boolean deleteNotification(long notificationId) {
        try {
            this.notificationLocalHome.remove(new NotificationPK(notificationId));
            return true;
        }
        catch (EJBException e) {
            logger.debug((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            logger.debug((Object)"runs into", (Throwable)e);
        }
        return false;
    }

    public String getNotifyRuleParameterValue(String key, String parameter) {
        String value;
        block17: {
            value = "unknown";
            if ("warning".equals(key)) {
                try {
                    int intParam = Integer.parseInt(parameter);
                    NotificationValue notificationValue = this.getNotificationById(intParam);
                    if (notificationValue != null) {
                        value = notificationValue.getDefaultName();
                        break block17;
                    }
                    value = key + "." + parameter;
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)("Integer.parseInt(parameter) runs into" + e.getMessage()));
                    value = key + "." + parameter;
                }
            } else if ("unit".equals(key)) {
                try {
                    int unitId = Integer.parseInt(parameter);
                    UnitDTO unitDTO = this.unitFacade.getUnit(unitId);
                    if (unitDTO != null) {
                        value = unitDTO.getUnitName();
                        break block17;
                    }
                    value = key + "." + parameter;
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)("Integer.parseInt(parameter) runs into" + e.getMessage()));
                    value = key + "." + parameter;
                }
            } else if ("unitGroup".equals(key)) {
                try {
                    int unitId = Integer.parseInt(parameter);
                    UnitDTO unitDTO = this.unitFacade.getUnit(unitId);
                    if (unitDTO != null) {
                        value = unitDTO.getUnitName();
                        break block17;
                    }
                    value = key + "." + parameter;
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)("Integer.parseInt(parameter) runs into" + e.getMessage()));
                    value = key + "." + parameter;
                }
            } else {
                if ("statusModelId".equals(key)) {
                    return "stateModel." + parameter;
                }
                if ("statusId".equals(key)) {
                    return "state." + parameter;
                }
                logger.warn((Object)("unknown key: '" + key + "'"));
                value = key + "." + parameter;
            }
        }
        return value;
    }

    public ParameterDetails getNotifyParameterDetails(String key, String initValue) {
        ParameterDetails parameterDetails = new ParameterDetails();
        if ("warning".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.DROPDOWN);
            List<NotificationValue> notificationValues = this.getAllNotifications();
            HashMap<String, Object> defaultValueMap = new HashMap<String, Object>(notificationValues.size());
            for (int i = 0; i < notificationValues.size(); ++i) {
                NotificationValue notificationValue = notificationValues.get(i);
                defaultValueMap.put(notificationValue.getDefaultName(), notificationValue.getId());
            }
            parameterDetails.setDefaultValueMap(defaultValueMap);
            parameterDetails.setUsesDefaultValueMap(true);
        } else if ("unit".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.DROPDOWN);
            UnitDTOList unitDTOList = this.unitFacade.getUnitsByIsBasic(true, true);
            HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
            for (int i = 0; i < unitDTOList.size(); ++i) {
                UnitDTO unitDTO = (UnitDTO)unitDTOList.get(i);
                defaultValueMap.put(unitDTO.getUnitName(), unitDTO.getUnitId());
            }
            parameterDetails.setDefaultValueMap(defaultValueMap);
            parameterDetails.setUsesDefaultValueMap(true);
        } else if ("unitGroup".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.DROPDOWN);
            UnitDTOList unitDTOList = this.unitFacade.getUnitsByIsBasic(false, true);
            HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
            for (int i = 0; i < unitDTOList.size(); ++i) {
                UnitDTO unitDTO = (UnitDTO)unitDTOList.get(i);
                defaultValueMap.put(unitDTO.getUnitName(), unitDTO.getUnitId());
            }
            parameterDetails.setDefaultValueMap(defaultValueMap);
            parameterDetails.setUsesDefaultValueMap(true);
        } else if ("email".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.TEXTBOX);
            parameterDetails.setUsesDefaultValue(true);
        } else if ("statusModelId".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.DROPDOWN);
            HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
            String stateIdPrefix = "stateModel.";
            defaultValueMap.put(stateIdPrefix + 2010, 2010L);
            defaultValueMap.put(stateIdPrefix + 2020, 2020L);
            defaultValueMap.put(stateIdPrefix + 2030, 2030L);
            defaultValueMap.put(stateIdPrefix + 2050, 2050L);
            defaultValueMap.put(stateIdPrefix + 2090, 2090L);
            defaultValueMap.put(stateIdPrefix + 2100, 2100L);
            defaultValueMap.put(stateIdPrefix + 2110, 2110L);
            defaultValueMap.put(stateIdPrefix + 2120, 2120L);
            defaultValueMap.put(stateIdPrefix + 2910, 2910L);
            defaultValueMap.put(stateIdPrefix + 2920, 2920L);
            defaultValueMap.put(stateIdPrefix + 2930, 2930L);
            parameterDetails.setDefaultValueMap(defaultValueMap);
            parameterDetails.setUsesDefaultValueMap(true);
            parameterDetails.setUseResourceBundle(true);
        } else if ("statusId".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.DROPDOWN);
            HashMap<String, Long> defaultValueMap = new HashMap<String, Long>();
            String stateIdPrefix = "state.";
            if ("2010".equals(initValue)) {
                defaultValueMap.put(stateIdPrefix + 2011, 2011L);
                defaultValueMap.put(stateIdPrefix + 2012, 2012L);
                defaultValueMap.put(stateIdPrefix + 2013, 2013L);
            } else if ("2020".equals(initValue)) {
                defaultValueMap.put(stateIdPrefix + 2021, 2021L);
                defaultValueMap.put(stateIdPrefix + 2022, 2022L);
            } else if ("2030".equals(initValue)) {
                defaultValueMap.put(stateIdPrefix + 2030, 2030L);
                defaultValueMap.put(stateIdPrefix + 2031, 2031L);
                defaultValueMap.put(stateIdPrefix + 2032, 2032L);
                defaultValueMap.put(stateIdPrefix + 2033, 2033L);
                defaultValueMap.put(stateIdPrefix + 2034, 2034L);
                defaultValueMap.put(stateIdPrefix + 2035, 2035L);
                defaultValueMap.put(stateIdPrefix + 2036, 2036L);
                defaultValueMap.put(stateIdPrefix + 2037, 2037L);
                defaultValueMap.put(stateIdPrefix + 2038, 2038L);
                defaultValueMap.put(stateIdPrefix + 2039, 2039L);
                defaultValueMap.put(stateIdPrefix + 9999, 9999L);
            } else if ("2050".equals(initValue)) {
                defaultValueMap.put(stateIdPrefix + 2051, 2051L);
                defaultValueMap.put(stateIdPrefix + 2052, 2052L);
                defaultValueMap.put(stateIdPrefix + 2053, 2053L);
                defaultValueMap.put(stateIdPrefix + 2054, 2054L);
                defaultValueMap.put(stateIdPrefix + 2055, 2055L);
            } else if ("2090".equals(initValue)) {
                defaultValueMap.put(stateIdPrefix + 2091, 2091L);
                defaultValueMap.put(stateIdPrefix + 2092, 2092L);
                defaultValueMap.put(stateIdPrefix + 2093, 2093L);
                defaultValueMap.put(stateIdPrefix + 2094, 2094L);
                defaultValueMap.put(stateIdPrefix + 2095, 2095L);
                defaultValueMap.put(stateIdPrefix + 2096, 2096L);
            } else if ("2100".equals(initValue)) {
                defaultValueMap.put(stateIdPrefix + 2101, 2101L);
                defaultValueMap.put(stateIdPrefix + 2102, 2102L);
            } else if ("2110".equals(initValue)) {
                defaultValueMap.put(stateIdPrefix + 2111, 2111L);
                defaultValueMap.put(stateIdPrefix + 2112, 2112L);
                defaultValueMap.put(stateIdPrefix + 2113, 2113L);
            } else if ("2120".equals(initValue)) {
                defaultValueMap.put(stateIdPrefix + 2121, 2121L);
                defaultValueMap.put(stateIdPrefix + 2122, 2122L);
                defaultValueMap.put(stateIdPrefix + 2123, 2123L);
                defaultValueMap.put(stateIdPrefix + 2124, 2124L);
            } else if ("2910".equals(initValue)) {
                defaultValueMap.put(stateIdPrefix + 9000, 9000L);
                defaultValueMap.put(stateIdPrefix + 9001, 9001L);
            } else if ("2920".equals(initValue)) {
                defaultValueMap.put(stateIdPrefix + 9000, 9000L);
                defaultValueMap.put(stateIdPrefix + 9001, 9001L);
            } else if ("2930".equals(initValue)) {
                defaultValueMap.put(stateIdPrefix + 9000, 9000L);
                defaultValueMap.put(stateIdPrefix + 9001, 9001L);
            }
            parameterDetails.setUsesDefaultValueMap(true);
            parameterDetails.setUseResourceBundle(true);
        } else {
            logger.debug((Object)("unknown key: '" + key + "'"));
            parameterDetails.setParameterInputType(ParameterInputType.TEXTBOX);
            parameterDetails.setUsesDefaultValue(true);
        }
        return parameterDetails;
    }
}

