/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.area;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.general.area.Area;
import de.proveo.wwt.logic.ejb.general.area.AreaData;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaPK;
import de.proveo.wwt.logic.ejb.general.area.AreaPoints;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsPK;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsValue;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AreaInFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(AreaInFacadeBean.class);
    private AreaLocalHome areaHome;
    private AreaPointsLocalHome areaPointsHome;
    private UnitModelLocalHome unitModelLocalHome;

    public void setAreaValue(AreaValue areaValue, Collection<AreaPointsValue> points, UnitModelLocal airportGroup) throws FinderException, CreateException {
        if (points.size() == 0) {
            throw new EJBException("cannot create an area with an empty point list");
        }
        log.debug((Object)("points size: " + points.size()));
        Iterator<AreaPointsValue> it = points.iterator();
        AreaPointsValue areaPointsStruct = null;
        int minLong = 0;
        int maxLong = 0;
        int minLat = 0;
        int maxLat = 0;
        if (it.hasNext()) {
            areaPointsStruct = it.next();
            minLong = areaPointsStruct.getLongMsec();
            maxLong = areaPointsStruct.getLongMsec();
            minLat = areaPointsStruct.getLatMsec();
            maxLat = areaPointsStruct.getLatMsec();
        }
        while (it.hasNext()) {
            areaPointsStruct = it.next();
            if (areaPointsStruct.getLongMsec() < minLong) {
                minLong = areaPointsStruct.getLongMsec();
            }
            if (areaPointsStruct.getLongMsec() > maxLong) {
                maxLong = areaPointsStruct.getLongMsec();
            }
            if (areaPointsStruct.getLatMsec() < minLat) {
                minLat = areaPointsStruct.getLatMsec();
            }
            if (areaPointsStruct.getLatMsec() <= maxLat) continue;
            maxLat = areaPointsStruct.getLatMsec();
        }
        areaValue.setMaxLongMsec(maxLong);
        areaValue.setMinLongMsec(minLong);
        areaValue.setMaxLatMsec(maxLat);
        areaValue.setMinLatMsec(minLat);
        if (log.isDebugEnabled()) {
            log.debug((Object)("MaxLong Value: " + areaValue.getMaxLongMsec()));
            log.debug((Object)("MinLong Value: " + areaValue.getMinLongMsec()));
            log.debug((Object)("MaxLat Value:  " + areaValue.getMaxLatMsec()));
            log.debug((Object)("MinLat Value:  " + areaValue.getMinLatMsec()));
            if (areaPointsStruct != null) {
                log.debug((Object)("GetLatitude Value:  " + areaPointsStruct.getLatMsec()));
            }
        }
        try {
            this.saveAreaDatas(areaValue, points, airportGroup);
        }
        catch (RemoteException ex) {
            log.error((Object)"runs during saveAreaDatas into", (Throwable)ex);
            throw new EJBException("runs during saveAreaDatas into " + ex.getMessage());
        }
    }

    public AreaValue getAreaValue(int areaId) {
        try {
            AreaLocal area = this.areaHome.findByPrimaryKey(new AreaPK(areaId));
            AreaValue areaValue = area.getAreaValue();
            return areaValue;
        }
        catch (Exception ex) {
            log.error((Object)("runs during getAreaValue(" + areaId + ") into"), (Throwable)ex);
            throw new EJBException(ex);
        }
    }

    public String getAreaDescription(int areaId) {
        try {
            AreaLocal area = this.areaHome.findByPrimaryKey(new AreaPK(areaId));
            AreaValue areaValue = area.getAreaValue();
            return areaValue.getDescription();
        }
        catch (Exception ex) {
            log.error((Object)("runs during getAreaDescription(" + areaId + ") into"), (Throwable)ex);
            throw new EJBException(ex);
        }
    }

    public Collection getAreaListData() {
        log.debug((Object)"getAreaListData() begin");
        ArrayList<AreaData> areaDatas = null;
        try {
            Collection remotes = this.areaHome.findAll();
            Iterator it = remotes.iterator();
            areaDatas = new ArrayList<AreaData>(remotes.size());
            while (it.hasNext()) {
                Area area = (Area)PortableRemoteObject.narrow(it.next(), Area.class);
                AreaValue areaValue = area.getAreaValue();
                AreaData areaData = new AreaData(areaValue);
                areaData.setAreaPointDatas(area.getPoints());
                areaDatas.add(areaData);
            }
        }
        catch (Exception ex) {
            log.error((Object)"getAreaListData() runs into", (Throwable)ex);
            throw new EJBException("getAreaListData() runs into " + ex.getClass().getName() + ": " + ex.getMessage());
        }
        return areaDatas;
    }

    public void ejbCreate() throws CreateException {
        try {
            this.areaHome = AreaUtil.getLocalHome();
            this.areaPointsHome = AreaPointsUtil.getLocalHome();
            this.unitModelLocalHome = UnitModelUtil.getLocalHome();
        }
        catch (Exception ex) {
            log.error((Object)"runs into", (Throwable)ex);
            throw new CreateException("ejbCreate during ejb ref lookup into " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public Collection getAreaList() {
        ArrayList<AreaValue> structs = null;
        try {
            Collection remotes = this.areaHome.findAll();
            Iterator it = remotes.iterator();
            structs = new ArrayList<AreaValue>(remotes.size());
            while (it.hasNext()) {
                Area remote = (Area)PortableRemoteObject.narrow(it.next(), Area.class);
                structs.add(remote.getAreaValue());
            }
        }
        catch (Exception ex) {
            log.error((Object)"getAreaList() runs into", (Throwable)ex);
            throw new EJBException("getAreaList() runs into " + ex.getClass().getName() + ": " + ex.getMessage());
        }
        return structs;
    }

    public void point(AreaLocal area, Collection<AreaPointsValue> points) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("point('" + area + "')"));
        }
        int areaId = area.getAreaId();
        String areaName = area.getArea();
        try {
            AreaPointsValue areaPointsStruct = null;
            Iterator<AreaPointsValue> it = points.iterator();
            log.debug((Object)("Size of collection  :" + points.size()));
            int i = 1;
            while (it.hasNext()) {
                areaPointsStruct = it.next();
                areaPointsStruct.setAreaId(areaId);
                areaPointsStruct.setPoint(i);
                AreaPointsLocal areaPoint = null;
                try {
                    areaPoint = this.areaPointsHome.findByPrimaryKey(new AreaPointsPK(areaId, areaPointsStruct.getPoint()));
                }
                catch (FinderException ex) {
                    log.debug((Object)"AreaPoints instance not found, create a new one");
                    areaPoint = this.areaPointsHome.create(areaPointsStruct);
                }
                areaPoint.setAreaPointsValue(areaPointsStruct);
                ++i;
            }
            try {
                Collection areaPoint = this.areaPointsHome.findByAreaMissingPoints(areaId, areaPointsStruct.getPoint());
                if (areaPoint != null) {
                    it = areaPoint.iterator();
                    while (it.hasNext()) {
                        AreaPoints areaPoints = (AreaPoints)PortableRemoteObject.narrow((Object)it.next(), AreaPoints.class);
                        areaPoints.remove();
                    }
                }
            }
            catch (FinderException ex) {
                log.debug((Object)("No deleted points found for area: " + areaName + " (" + areaId + ")"));
            }
            catch (IOException ex) {
                log.debug((Object)("Area is not yet in database, so there are no old points to delete: " + areaName + " (" + areaId + ")"));
            }
        }
        catch (Exception ex) {
            throw new EJBException("runs during point() into: " + ex.getMessage(), ex);
        }
    }

    public void saveAreaDatas(AreaValue areaValue, Collection<AreaPointsValue> points, UnitModelLocal airportGroup) throws RemoteException, CreateException {
        AreaLocal area;
        block5: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("saveAreaDatas('" + areaValue + "')"));
            }
            area = null;
            try {
                log.debug((Object)("searching for area with id '" + areaValue.getPrimaryKey() + "' ..."));
                area = this.areaHome.findByPrimaryKey(areaValue.getPrimaryKey());
                log.debug((Object)"area already exists, changing it ...");
                area.setAreaValue(areaValue);
            }
            catch (FinderException ex) {
                log.debug((Object)"area doesn't exist, create a new one ...");
                area = this.areaHome.create(areaValue);
                if (!log.isDebugEnabled()) break block5;
                AreaValue areaDataDebug = area.getAreaValue();
                log.debug((Object)("Area with ID '" + area.getAreaId() + "' created: " + areaDataDebug));
            }
        }
        area.setUnitModel(airportGroup);
        log.debug((Object)"area saved, trying to update points list");
        try {
            this.point(area, points);
        }
        catch (Exception e) {
            CreateException ce = new CreateException("Runs into: " + e.getMessage());
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
    }

    public void createArea(String areaId, String areaDescription, int prio) {
        AreaValue areaValue = new AreaValue();
        areaValue.setArea(areaId);
        areaValue.setDescription(areaDescription);
        areaValue.setDeleted(false);
        areaValue.setPriority(prio);
        try {
            AreaLocal area = this.areaHome.create(areaValue);
        }
        catch (CreateException ex) {
            log.error((Object)"runs into", (Throwable)ex);
        }
    }

    public void updateAllAreas(HashMap<Object, AreaValue> newAreas, HashMap<Object, ArrayList<AreaPointsValue>> newPoints, Long airportId) {
        boolean errorsHappenedWhileUpdating = false;
        try {
            log.info((Object)"Write new areas to database...");
            if (newAreas != null) {
                UnitModelLocal unitModelLocal = null;
                if (airportId != null) {
                    unitModelLocal = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(airportId));
                    if (unitModelLocal.getUnitModelValue().getDeleted()) {
                        throw new FinderException("unit with id = '" + airportId + "' is deleted, can not save areas to a deleted unit");
                    }
                    if (unitModelLocal.getUnitModelValue().getBasic()) {
                        throw new FinderException("unit with id = '" + airportId + "' is a basic unit, can not save areas to a basic unit");
                    }
                }
                for (Object key : newAreas.keySet()) {
                    AreaValue area = newAreas.get(key);
                    try {
                        this.setAreaValue(area, (Collection<AreaPointsValue>)newPoints.get(key), unitModelLocal);
                    }
                    catch (Throwable ex) {
                        errorsHappenedWhileUpdating = true;
                        String areaName = "UNKNOWN";
                        if (area != null) {
                            areaName = area.getArea();
                        }
                        log.error((Object)("Error while updating area: " + areaName), ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            errorsHappenedWhileUpdating = true;
            throw new EJBException("Error while updating areas", ex);
        }
        if (!errorsHappenedWhileUpdating) {
            log.info((Object)"New areas succussfully written to database.");
        }
    }
}

