/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.useradministration.facade;

import de.proveo.util.DataConverter;
import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.RoleAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.RoleAdminFacadeUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentPK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentValue;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RolePK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountPK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountValue;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeUtil;
import de.proveo.wwt.logic.web.admin.PermissionUpdateNotifyLocal;
import de.proveo.wwt.logic.web.admin.PermissionUpdateNotifyUtil;
import de.proveo.wwt.logic.web.admin.PermissionUpdateToolsLocal;
import de.proveo.wwt.logic.web.admin.PermissionUpdateToolsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserGroupAdminFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log logger = LogFactory.getLog(UserGroupAdminFacadeBean.class);
    private static final String auditAppl = "RTSWEB";
    private AccountLocalHome accountHome;
    private GroupIdentLocalHome groupIdentHome;
    private RoleLocalHome roleLocalHome;
    private AuditFacadeLocal auditFacadeLocal;
    private PermissionUpdateNotifyLocal permissionUpdateNotifyLocal;
    private RoleAdminFacadeLocal roleAdminFacadeLocal;
    private PermissionUpdateToolsLocal permissionUpdateToolsLocal;
    private UserAdminFacadeLocal userAdminFacadeLocal;
    private UnitFacadeLocal unitFacadeLocal;

    public void ejbCreate() throws CreateException {
        try {
            this.accountHome = AccountUtil.getLocalHome();
            this.groupIdentHome = GroupIdentUtil.getLocalHome();
            this.roleLocalHome = RoleUtil.getLocalHome();
            this.auditFacadeLocal = AuditFacadeUtil.getLocalHome().create();
            this.permissionUpdateNotifyLocal = PermissionUpdateNotifyUtil.getLocalHome().create();
            this.permissionUpdateToolsLocal = PermissionUpdateToolsUtil.getLocalHome().create();
            this.userAdminFacadeLocal = UserAdminFacadeUtil.getLocalHome().create();
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    private UnitFacadeLocal getUnitFacade() {
        if (this.unitFacadeLocal == null) {
            try {
                this.unitFacadeLocal = UnitFacadeUtil.getLocalHome().create();
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            catch (NamingException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        return this.unitFacadeLocal;
    }

    private RoleAdminFacadeLocal getRoleAdminFacade() {
        if (this.roleAdminFacadeLocal == null) {
            try {
                this.roleAdminFacadeLocal = RoleAdminFacadeUtil.getLocalHome().create();
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            catch (NamingException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        return this.roleAdminFacadeLocal;
    }

    public List<GroupIdentValue> getAllUserGroups() {
        ArrayList<GroupIdentValue> list = null;
        try {
            Collection collection = this.groupIdentHome.findAll();
            list = new ArrayList<GroupIdentValue>();
            for (GroupIdentLocal groupIdentLocal : collection) {
                GroupIdentValue value = groupIdentLocal.getGroupIdentValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public GroupIdentValue getGroupIdent(long seletedGroupIdent) {
        GroupIdentValue groupIdentValue = null;
        try {
            GroupIdentLocal groupIdentLocal = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(seletedGroupIdent));
            groupIdentValue = groupIdentLocal.getGroupIdentValue();
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return groupIdentValue;
    }

    public boolean deleteUserGroup(long groupIdent) {
        boolean success = false;
        try {
            GroupIdentLocal userGroup = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupIdent));
            try {
                String pk = userGroup.getPrimaryKey().toString() + " " + userGroup.getGroupname();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "", userGroup.getGroupIdentValue(), null);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            this.getRoleAdminFacade().sendRoleChangedJMSMessageDueToUserGroupDeleted(userGroup);
            userGroup.remove();
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public boolean duplicatedUserGroupName(String name, long Id) {
        boolean duplicated = false;
        List<GroupIdentValue> collection = this.getAllUserGroups();
        for (GroupIdentValue groupIdentValue : collection) {
            if (groupIdentValue.getID() == Id || !groupIdentValue.getGroupname().equals(name)) continue;
            duplicated = true;
            break;
        }
        return duplicated;
    }

    public Long insertUserGroup(GroupIdentValue value) throws CreateException {
        Long id = null;
        try {
            if (this.duplicatedUserGroupName(value.getGroupname(), -1L)) {
                throw new CreateException("No creation possible, Usergroup already exists");
            }
            GroupIdentLocal local = this.groupIdentHome.create(value);
            id = local.getGroupIdentValue().getID();
            try {
                String pk = local.getPrimaryKey().toString() + " " + local.getGroupname();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "", null, local.getGroupIdentValue());
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
            throw new CreateException("No creation possible, Usergroup already exists");
        }
        return id;
    }

    public boolean updateUserGroup(GroupIdentValue value) {
        boolean success;
        block6: {
            success = false;
            try {
                if (this.duplicatedUserGroupName(value.getGroupname(), value.getID())) {
                    success = false;
                    break block6;
                }
                GroupIdentLocal groupIdentLocal = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(value.getID()));
                GroupIdentValue oldValue = groupIdentLocal.getGroupIdentValue();
                if (oldValue.equals(value)) {
                    return true;
                }
                groupIdentLocal.setGroupIdentValue(value);
                try {
                    String pk = groupIdentLocal.getPrimaryKey().toString() + " " + oldValue.getGroupname();
                    this.auditFacadeLocal.createAuditData(auditAppl, pk, "", oldValue, value);
                }
                catch (CreateException e) {
                    logger.error((Object)"runs into", (Throwable)e);
                }
                success = true;
            }
            catch (FinderException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        return success;
    }

    public List<GroupIdentValue> getGroupsByUsername(String seletedUsername) {
        ArrayList<GroupIdentValue> list = new ArrayList<GroupIdentValue>();
        try {
            Collection accountRecords = this.accountHome.findByUsername(seletedUsername);
            AccountLocal account = null;
            Iterator it = accountRecords.iterator();
            if (it.hasNext()) {
                account = (AccountLocal)it.next();
                Collection groups = account.getUserGroups();
                GroupIdentLocal[] groupArr = groups.toArray(new GroupIdentLocal[0]);
                for (int i = 0; i != groupArr.length; ++i) {
                    list.add(groupArr[i].getGroupIdentValue());
                }
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public boolean setUsernamesByGroupId(long groupId, String[] usernames) {
        boolean success = false;
        try {
            HashMap<String, String[]> oldAccountPermissions = new HashMap();
            HashMap<String, String[]> newAccountPermissions = new HashMap();
            HashMap<String, HashSet<Long>> oldUnitPermissions = new HashMap();
            HashMap<String, HashSet<Long>> newUnitPermissions = new HashMap();
            String[] affectedUserNames = this.permissionUpdateToolsLocal.getDifferentUsers(this.userAdminFacadeLocal.getAccountsByUsername(groupId), usernames);
            oldAccountPermissions = this.getRoleAdminFacade().getAllSectionRolesForUsers(affectedUserNames);
            oldUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(affectedUserNames);
            AccountLocal account = null;
            GroupIdentLocal groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupId));
            ArrayList<AccountLocal> newUsers = new ArrayList<AccountLocal>();
            ArrayList<AccountValue> newUsersList = new ArrayList<AccountValue>();
            ArrayList<String> newAssignment = new ArrayList<String>();
            for (String username : usernames) {
                Collection accountRecords = this.accountHome.findByUsername(username);
                Iterator it = accountRecords.iterator();
                if (!it.hasNext()) continue;
                account = (AccountLocal)it.next();
                newUsers.add(account);
                newAssignment.add(account.getAccountValue().getUsername());
                newUsersList.add(account.getAccountValue());
            }
            Collection oldUsers = groupIdent.getUser();
            ArrayList<AccountValue> oldUsersList = new ArrayList<AccountValue>();
            ArrayList<String> oldAssignment = new ArrayList<String>();
            for (Object obj : oldUsers) {
                account = (AccountLocal)obj;
                oldAssignment.add(account.getAccountValue().getUsername());
                oldUsersList.add(account.getAccountValue());
            }
            Collections.sort(oldAssignment);
            Collections.sort(newAssignment);
            if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
                return true;
            }
            groupIdent.setUser(newUsers);
            newAccountPermissions = this.getRoleAdminFacade().getAllSectionRolesForUsers(affectedUserNames);
            newUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(affectedUserNames);
            List<String> affectedUsersByAirportmapRoleChanges = this.permissionUpdateToolsLocal.getAffectedUsersByRolesChanges(oldAccountPermissions, newAccountPermissions, affectedUserNames);
            List<String> affectedUsersByVisibleUnitChanges = this.permissionUpdateToolsLocal.getAffectedUsersByVisibleUnitChanges(oldUnitPermissions, newUnitPermissions, affectedUserNames);
            if (affectedUsersByAirportmapRoleChanges.size() != 0) {
                this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessageByUserNames(affectedUsersByAirportmapRoleChanges);
            }
            if (affectedUsersByVisibleUnitChanges.size() != 0) {
                this.permissionUpdateNotifyLocal.sendPermissionChangedJMSMessageByUserNames(affectedUsersByVisibleUnitChanges);
            }
            try {
                String pk = groupIdent.getPrimaryKey().toString() + " " + groupIdent.getGroupname();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "RelationUserGroupToUser", oldAssignment, newAssignment);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public boolean setGroupsByUsername(String username, long[] groupIds) {
        boolean success = false;
        try {
            AccountLocal account;
            Collection accountRecords = this.accountHome.findByUsername(username);
            Iterator it = accountRecords.iterator();
            if (it.hasNext() && (account = (AccountLocal)it.next()) != null) {
                success = this.setGroupsByUserId(account.getAccountValue().getId(), groupIds);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public boolean setGroupsByUserId(long accountId, long[] groupIds) {
        boolean success = false;
        try {
            ArrayList<AccountValue> accounts;
            GroupIdentLocal groupIdent = null;
            AccountLocal account = this.accountHome.findByPrimaryKey(new AccountPK(accountId));
            String userName = account.getAccountValue().getUsername();
            ArrayList currentRoles = new ArrayList(DataConverter.arrayAsList((String[])this.getRoleAdminFacade().getAllSectionRolesForUser(userName)));
            HashSet<Long> currentUnitIDs = this.getUnitFacade().getAllUnitIdsForUsername(userName);
            ArrayList<GroupIdentLocal> newGroups = new ArrayList<GroupIdentLocal>();
            ArrayList<String> newAssignment = new ArrayList<String>();
            for (long groupId : groupIds) {
                groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupId));
                newGroups.add(groupIdent);
                newAssignment.add(groupIdent.getGroupname());
            }
            Collection oldGroups = account.getUserGroups();
            ArrayList<String> oldAssignment = new ArrayList<String>();
            for (Object obj : oldGroups) {
                groupIdent = (GroupIdentLocal)obj;
                oldAssignment.add(groupIdent.getGroupname());
            }
            Collections.sort(oldAssignment);
            Collections.sort(newAssignment);
            if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
                return true;
            }
            account.setUserGroups(newGroups);
            ArrayList newRoles = new ArrayList(DataConverter.arrayAsList((String[])this.getRoleAdminFacade().getAllSectionRolesForUser(userName)));
            HashSet<Long> newUnitIDs = this.getUnitFacade().getAllUnitIdsForUsername(userName);
            if (this.permissionUpdateToolsLocal.getDiffOfCollection(currentRoles, newRoles).toString().contains("section.airportmap")) {
                accounts = new ArrayList<AccountValue>();
                accounts.add(account.getAccountValue());
                this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessage(accounts);
            }
            if (this.permissionUpdateToolsLocal.getDiffOfCollection(currentUnitIDs, newUnitIDs).size() != 0) {
                accounts = new ArrayList();
                accounts.add(account.getAccountValue());
                this.permissionUpdateNotifyLocal.sendPermissionChangedJMSMessage(accounts);
            }
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getAccountValue().getUsername();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "RelationUserToUserGroup", oldAssignment, newAssignment);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into ", (Throwable)e);
        }
        return success;
    }

    public List<GroupIdentValue> getGroupsByUserId(long accountId) {
        ArrayList<GroupIdentValue> list = new ArrayList<GroupIdentValue>();
        try {
            AccountLocal account = this.accountHome.findByPrimaryKey(new AccountPK(accountId));
            Collection groups = account.getUserGroups();
            for (Object obj : groups) {
                GroupIdentLocal local = (GroupIdentLocal)obj;
                GroupIdentValue value = local.getGroupIdentValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<GroupIdentValue> getGroupsByRoleId(long roleId) {
        ArrayList<GroupIdentValue> list = null;
        try {
            RoleLocal role = this.roleLocalHome.findByPrimaryKey(new RolePK(roleId));
            Collection groups = role.getUserGroups();
            list = new ArrayList<GroupIdentValue>();
            for (Object obj : groups) {
                GroupIdentLocal local = (GroupIdentLocal)obj;
                GroupIdentValue value = local.getGroupIdentValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<AccountValue> getAccountsByGroupID(long groupID) {
        try {
            GroupIdentLocal groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupID));
            Collection accounts = groupIdent.getUser();
            ArrayList<AccountValue> list = new ArrayList<AccountValue>();
            for (Object obj : accounts) {
                AccountLocal local = (AccountLocal)obj;
                AccountValue value = local.getAccountValue();
                list.add(value);
            }
            return list;
        }
        catch (FinderException e) {
            logger.error((Object)"getUsersByGroupID runs into : ", (Throwable)e);
            return null;
        }
    }

    public List<AccountValue> getAccountsByGroupIDs(List<Long> groupIDs) {
        ArrayList<AccountValue> accounts = new ArrayList<AccountValue>();
        for (Long id : groupIDs) {
            List<AccountValue> accountList = this.getAccountsByGroupID(id);
            accounts.addAll(accountList);
        }
        return accounts;
    }

    public List<AccountValue> getAccountsByGroupIDs(long[] groupIDs) {
        ArrayList<Long> groupIDList = new ArrayList<Long>(groupIDs.length);
        for (int i = 0; i < groupIDs.length; ++i) {
            groupIDList.add(groupIDs[i]);
        }
        return this.getAccountsByGroupIDs(groupIDList);
    }
}

