/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.useradministration.facade;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeUtil;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocalHome;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserPK;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseUserAdminFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log logger = LogFactory.getLog(UseUserAdminFacadeBean.class);
    private static final String auditAppl = "RTSWEB";
    private UseUserLocalHome useUserHome;
    private AuditFacadeLocal auditFacadeLocal;

    public void ejbCreate() throws CreateException {
        try {
            this.useUserHome = UseUserUtil.getLocalHome();
            this.auditFacadeLocal = AuditFacadeUtil.getLocalHome().create();
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public String duplicatedUseUserKeyAndName(String key, String name, long id) {
        boolean duplicated = false;
        List<UseUserValue> collection = this.getAllDeletedUseUsers();
        for (UseUserValue value : collection) {
            if (value.getId() == id) continue;
            String valueKey = value.getKey();
            String valueKeyName = value.getKey() + "#" + value.getName();
            if (!value.getDeleted() || valueKey == null || key.equals("") || !valueKeyName.equals(key + "#" + name)) continue;
            duplicated = true;
            if (value.getDeleted()) {
                return "keyNameDeleted";
            }
            return "keyName";
        }
        return null;
    }

    public String duplicatedUseUserKey(String key, long id) {
        boolean duplicated = false;
        List<UseUserValue> collection = this.getAllUseUsers();
        for (UseUserValue value : collection) {
            String valueKey;
            if (value.getId() == id || (valueKey = value.getKey()) == null || key.equals("") || !valueKey.equals(key)) continue;
            duplicated = true;
            if (value.getDeleted()) {
                return "keyDeleted";
            }
            return "key";
        }
        return null;
    }

    public String duplicatedUseUserPersonalNumber(String personalNumber, long id) {
        boolean duplicated = false;
        List<UseUserValue> collection = this.getAllUseUsersIncludeDeleted();
        for (UseUserValue value : collection) {
            String valuePersonalNumber;
            if (value.getId() == id || (valuePersonalNumber = value.getPersonalNumber()) == null || personalNumber.equals("") || !valuePersonalNumber.equals(personalNumber)) continue;
            duplicated = true;
            if (value.getDeleted()) {
                return "personalNumberDeleted";
            }
            return "personalNumber";
        }
        return null;
    }

    public String validateUseUser(UseUserValue value, long id) {
        String validation = "";
        validation = this.duplicatedUseUserPersonalNumber(value.getPersonalNumber(), id);
        if (validation != null) {
            return validation;
        }
        validation = this.duplicatedUseUserKey(value.getKey(), id);
        if (validation != null) {
            return validation;
        }
        validation = this.duplicatedUseUserKeyAndName(value.getKey(), value.getName(), id);
        if (validation != null) {
            return validation;
        }
        return null;
    }

    public Long insertUseUser(UseUserValue value) throws DuplicateKeyException, CreateException {
        UseUserLocal local = null;
        String validation = this.validateUseUser(value, -1L);
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        try {
            local = this.useUserHome.create(value);
            try {
                UnitFacadeLocal adminUnitFacade = UnitFacadeUtil.getLocalHome().create();
                adminUnitFacade.updateUnitUserRefreshForUseGroup(value.getGroupId());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(" ---- unituserrefresh for operatorgroup : " + value.getGroupId()));
                }
            }
            catch (NamingException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        catch (CreateException e1) {
            logger.error((Object)"runs into", (Throwable)e1);
        }
        try {
            if (local != null) {
                String pk = local.getPrimaryKey().toString() + " " + local.getUseUserValue().getName();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "", null, local.getUseUserValue());
            }
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        if (local != null) {
            return local.getUseUserValue().getId();
        }
        return null;
    }

    public boolean updateUseUser(UseUserValue userUserValue) throws DuplicateKeyException {
        boolean success = false;
        String validation = this.validateUseUser(userUserValue, userUserValue.getId());
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        try {
            UseUserLocal useUserLocal = this.useUserHome.findByPrimaryKey(new UseUserPK(userUserValue.getId()));
            UseUserValue oldValue = useUserLocal.getUseUserValue();
            long oldGroupId = oldValue.getGroupId();
            if (oldValue.equals(userUserValue)) {
                return true;
            }
            useUserLocal.setUseUserValue(userUserValue);
            if (oldValue.getGroupId() != userUserValue.getGroupId() || oldValue.getKey() != userUserValue.getKey()) {
                try {
                    UnitFacadeLocal adminUnitFacade = UnitFacadeUtil.getLocalHome().create();
                    if (oldValue.getGroupId() != userUserValue.getGroupId()) {
                        adminUnitFacade.updateUnitUserRefreshForUseGroup(userUserValue.getGroupId());
                        adminUnitFacade.updateUnitUserRefreshForUseGroup(oldGroupId);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(" ---- unituserrefresh for operatorgroup : " + userUserValue.getGroupId()));
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(" ---- unituserrefresh for operatorgroup : " + oldGroupId));
                        }
                    }
                    if (!oldValue.getKey().equals(userUserValue.getKey())) {
                        adminUnitFacade.updateUnitUserRefreshForUseUser(userUserValue.getId());
                        adminUnitFacade.updateUnitUserRefreshForUseGroup(userUserValue.getGroupId());
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(" ---- unituserrefresh for key change : " + userUserValue.getKey()));
                        }
                    }
                }
                catch (CreateException e) {
                    logger.error((Object)"runs into", (Throwable)e);
                }
                catch (NamingException e) {
                    logger.error((Object)"runs into", (Throwable)e);
                }
            }
            try {
                String pk = useUserLocal.getPrimaryKey().toString() + " " + useUserLocal.getUseUserValue().getName();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "", oldValue, userUserValue);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public boolean deleteUseUser(long id) {
        boolean success = false;
        try {
            UseUserLocal useUserLocal = this.useUserHome.findByPrimaryKey(new UseUserPK(id));
            try {
                String pk = useUserLocal.getPrimaryKey().toString() + " " + useUserLocal.getUseUserValue().getName();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "", useUserLocal.getUseUserValue(), "Marked as deleted");
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            UseUserValue value = useUserLocal.getUseUserValue();
            value.setDeleted(true);
            useUserLocal.setUseUserValue(value);
            UnitFacadeLocal adminUnitFacade = UnitFacadeUtil.getLocalHome().create();
            adminUnitFacade.updateUnitUserRefreshForUseUser(value.getId());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" ---- unituserrefresh for : " + value.getKey()));
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public List<UseUserValue> getAllUseUsers() {
        ArrayList<UseUserValue> list = null;
        try {
            Collection collection = this.useUserHome.findAll();
            list = new ArrayList<UseUserValue>();
            for (UseUserLocal useUserLocal : collection) {
                UseUserValue value = useUserLocal.getUseUserValue();
                if (this.filterOutUnknown(value)) continue;
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<UseUserValue> getAllDeletedUseUsers() {
        ArrayList<UseUserValue> list = null;
        try {
            Collection collection = this.useUserHome.findAllDeleted();
            list = new ArrayList<UseUserValue>();
            for (UseUserLocal useUserLocal : collection) {
                UseUserValue value = useUserLocal.getUseUserValue();
                if (this.filterOutUnknown(value)) continue;
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<UseUserValue> getAllUseUsersIncludeDeleted() {
        ArrayList<UseUserValue> list = null;
        try {
            Collection collection = this.useUserHome.findAllIncludeDeleted();
            list = new ArrayList<UseUserValue>();
            for (UseUserLocal account : collection) {
                UseUserValue value = account.getUseUserValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<UseUserValue> getUseUsersByUseGroupId(long groupId) {
        ArrayList<UseUserValue> list = null;
        try {
            Collection collection = this.useUserHome.findByGroupId(groupId);
            list = new ArrayList<UseUserValue>();
            for (UseUserLocal useUserLocal : collection) {
                UseUserValue value = useUserLocal.getUseUserValue();
                if (this.filterOutUnknown(value)) continue;
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    private boolean filterOutUnknown(UseUserValue value) {
        return !this.sessionContext.isCallerInRole("superadmin") && (value.getName().equals("unknown") || value.getKey().equals("0000000000000000"));
    }
}

