/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.use;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCachePK;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.use.exception.NoUseFoundException;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryValue;
import de.proveo.wwt.logic.ejb.dataOut.raw.UseStamp;
import de.proveo.wwt.logic.ejb.general.use.group.GroupNotFoundException;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocal;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocalHome;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupPK;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupUtil;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupValue;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocalHome;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserPK;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import de.proveo.wwt.logic.ejb.general.use.user.UserNotFoundException;
import java.util.Collection;
import java.util.HashSet;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UseOutFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(UseOutFacadeBean.class);
    private UseCacheLocalHome useCacheHome;
    private UseHistoryLocalHome useHistoryHome;
    private UseUserLocalHome useUserHome;
    private UseGroupLocalHome useGroupHome;

    public void ejbCreate() throws CreateException {
        try {
            this.useCacheHome = UseCacheUtil.getLocalHome();
            this.useHistoryHome = UseHistoryUtil.getLocalHome();
            this.useGroupHome = UseGroupUtil.getLocalHome();
            this.useUserHome = UseUserUtil.getLocalHome();
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    protected UseStamp getUnitEventsFromCache(long basicUnitId, long requestedBeginTime, long requestedEndTime) throws NoUseFoundException {
        UseGroupValue useGroupStruct;
        UseUserValue useUserStruct;
        UseCacheValue useCacheStruct;
        String sMethodName = "getUnitEventsFromCache()";
        try {
            UseCacheLocal useCache = this.useCacheHome.findByPrimaryKey(new UseCachePK(basicUnitId));
            useCacheStruct = useCache.getUseCacheValue();
            useUserStruct = this.getUser(useCacheStruct.getUserId());
            useGroupStruct = this.getGroup(useCacheStruct.getGroupId());
        }
        catch (FinderException ex) {
            throw new NoUseFoundException(basicUnitId, "nothing found in cache");
        }
        catch (UserNotFoundException ex) {
            log.error((Object)(sMethodName + " runs into a user problem"), (Throwable)ex);
            throw new NoUseFoundException(basicUnitId, sMethodName + " runs into a user problem", ex);
        }
        catch (GroupNotFoundException ex) {
            log.error((Object)(sMethodName + " runs into a group problem"), (Throwable)ex);
            throw new NoUseFoundException(basicUnitId, sMethodName + " runs into a group problem", ex);
        }
        return new UseStamp(useCacheStruct, useUserStruct, useGroupStruct, requestedBeginTime, requestedEndTime);
    }

    protected HashSet getUnitEventsFromHistory(long basicUnitId, long requestedBeginTime, long requestedEndTime) throws NoUseFoundException {
        Collection entries;
        String sMethodName = "getUnitEventsFromHistory()";
        try {
            entries = this.useHistoryHome.findByUnit(requestedBeginTime, requestedEndTime, basicUnitId);
        }
        catch (FinderException ex) {
            throw new NoUseFoundException(basicUnitId, "nothing found");
        }
        HashSet<UseStamp> useStamps = new HashSet<UseStamp>();
        for (UseHistoryLocal useHistory : entries) {
            UseGroupValue useGroupStruct;
            UseUserValue useUserStruct;
            UseHistoryValue useHistoryStruct;
            try {
                useHistoryStruct = useHistory.getUseHistoryValue();
                useUserStruct = this.getUser(useHistoryStruct.getUserId());
                useGroupStruct = this.getGroup(useHistoryStruct.getGroupId());
            }
            catch (UserNotFoundException ex) {
                log.error((Object)(sMethodName + " runs into a user problem"), (Throwable)ex);
                throw new NoUseFoundException(basicUnitId, sMethodName + " runs into a user problem", ex);
            }
            catch (GroupNotFoundException ex) {
                log.error((Object)(sMethodName + " runs into a group problem"), (Throwable)ex);
                throw new NoUseFoundException(basicUnitId, sMethodName + " runs into a group problem", ex);
            }
            UseStamp stamp = new UseStamp(useHistoryStruct, useUserStruct, useGroupStruct, requestedBeginTime, requestedEndTime);
            useStamps.add(stamp);
        }
        return useStamps;
    }

    protected UseUserValue getUser(long userId) throws UserNotFoundException {
        UseUserPK pk = new UseUserPK(userId);
        try {
            UseUserLocal user = this.useUserHome.findByPrimaryKey(pk);
            return user.getUseUserValue();
        }
        catch (Exception ex) {
            throw new UserNotFoundException("getUser for ID '" + userId + "' runs into " + ex.getMessage());
        }
    }

    protected UseGroupValue getGroup(long groupId) throws GroupNotFoundException {
        UseGroupPK pk = new UseGroupPK(groupId);
        try {
            UseGroupLocal group = this.useGroupHome.findByPrimaryKey(pk);
            return group.getUseGroupValue();
        }
        catch (Exception ex) {
            throw new GroupNotFoundException("getGroup for " + groupId + " runs into " + ex.getMessage());
        }
    }
}

