/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.replay;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.observable.stands.StandsDataFactory;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeUtil;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.ReplayFastLaneReader;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeLocal;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeUtil;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocal;
import de.proveo.wwt.logic.web.security.PermissionCheckerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayDataFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final long serialVersionUID = -981298534634801580L;
    private static final Log log = LogFactory.getLog(ReplayDataFacadeBean.class);
    private UnitIdentityLocalHome unitIdentityLocalHome;
    private AreaLocalHome areaLocalHome;
    private PermissionCheckerLocal permissionCheckerLocal;
    private ConfigurationLocal configurationLocal;
    private UnitFacadeLocal unitFacade;
    private UnitTreeFacadeLocal unitTreeFacade;
    private ReplayFastLaneReader replayFastLane;

    public void ejbCreate() throws CreateException {
        try {
            this.unitIdentityLocalHome = UnitIdentityUtil.getLocalHome();
            this.areaLocalHome = AreaUtil.getLocalHome();
            this.permissionCheckerLocal = PermissionCheckerUtil.getLocalHome().create();
            this.configurationLocal = ConfigurationUtil.getLocalHome().create();
            this.unitFacade = UnitFacadeUtil.getLocalHome().create();
            this.unitTreeFacade = UnitTreeFacadeUtil.getLocalHome().create();
            this.replayFastLane = new ReplayFastLaneReader();
            if (log.isDebugEnabled()) {
                log.debug((Object)"LocalHomes created...");
            }
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    public HashMap<String, Map> getReplayData(long unitGroupId, long fromTime, long toTime, boolean admin, boolean sendUnitsData, boolean sendNotifiesData, boolean sendUseMsgsData, boolean sendInfomanMsgsData, boolean sendStandsData) {
        Stopwatch stopwatch = new Stopwatch(ReplayDataFacadeBean.class, "getReplayData");
        stopwatch.start("overall");
        String method = "getReplayData(): ";
        boolean replayActive = this.configurationLocal.getBoolean("airportmap.replay.active", false);
        if (!replayActive) {
            if (!admin) {
                log.warn((Object)(method + "Replay not available on this server."));
                stopwatch.stop("overall", true);
                return null;
            }
            log.debug((Object)(method + "Replay not available on this server, but user is admin."));
        }
        int maximumNotifiesPerDay = 0;
        if (this.configurationLocal.isConfigured("observable.notifies.maximumPerUnitPerDay")) {
            try {
                maximumNotifiesPerDay = this.configurationLocal.getInteger("observable.notifies.maximumPerUnitPerDay");
            }
            catch (Throwable ex) {
                log.error((Object)(method + "Could not get property \"observable.notifies.maximumPerUnitPerDay\""), ex);
            }
        }
        if (!sendUnitsData) {
            if (sendNotifiesData) {
                log.warn((Object)(method + "Missing selector for units: can not send notifies without units data!"));
            }
            if (sendUseMsgsData) {
                log.warn((Object)(method + "Missing selector for units: can not send use messages without units data!"));
            }
            if (sendInfomanMsgsData) {
                log.warn((Object)(method + "Missing selector for units: can not send Infoman messages without units data!"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "start."));
        }
        HashMap<String, Map> completeMap = new HashMap<String, Map>();
        int initialUnitsDataSize = 0;
        HashMap initialUnitsCollector = new HashMap();
        TreeMap<Long, HashMap> replayDataMap = new TreeMap<Long, HashMap>();
        if (sendUnitsData) {
            HashSet<Long> unitPermissions = this.permissionCheckerLocal.getUnitPermissions();
            HashMap unitIdents = new HashMap();
            if (unitPermissions != null && unitPermissions.size() > 0) {
                long unitId;
                if (unitGroupId > -1L) {
                    UnitTreeNode unitGroupNode = null;
                    try {
                        UnitTreeNode unitTree = this.unitTreeFacade.getAirportMapTreeModel();
                        if (unitTree != null) {
                            unitGroupNode = this.findUnitGroupNode((UnitTreeNode)unitTree.getRoot(), unitGroupId);
                        }
                    }
                    catch (Exception ex) {
                        log.error((Object)"getAirportMapTreeModel() runs into", (Throwable)ex);
                    }
                    if (unitGroupNode != null) {
                        HashSet<Long> tmpUnitPermissions = new HashSet<Long>(unitPermissions);
                        for (Long next : unitPermissions) {
                            unitId = Long.valueOf(((Object)next).toString());
                            if (this.isUnitIdInGroup(unitGroupNode, unitId)) continue;
                            tmpUnitPermissions.remove(next);
                        }
                        unitPermissions = new HashSet<Long>(tmpUnitPermissions);
                    }
                }
                Collection colUnitIdentity = null;
                try {
                    colUnitIdentity = this.unitIdentityLocalHome.findAll();
                }
                catch (FinderException ex) {
                    log.error((Object)(method + "runs into"), (Throwable)ex);
                }
                if (colUnitIdentity != null && colUnitIdentity.size() > 0) {
                    for (UnitIdentityLocal local : colUnitIdentity) {
                        UnitIdentityValue value;
                        if (local == null || (value = local.getUnitIdentityValue()) == null || !unitPermissions.contains(value.getUnitId())) continue;
                        unitId = value.getUnitId();
                        UnitModelLocal unitModelLocal = local.getUnitModel();
                        UnitModelValue unitModelValue = unitModelLocal.getUnitModelValue();
                        boolean airportMapVisible = unitModelValue.getAirportMapVisible();
                        boolean basicUnit = unitModelValue.getBasic();
                        if (!airportMapVisible || !basicUnit) {
                            unitPermissions.remove(unitId);
                            continue;
                        }
                        String unitType = null;
                        try {
                            UnitTypeIdentityValue unitTypeIdentityValue = this.unitFacade.getUnit(unitId).getUnitTypeIdentityValue();
                            String tmp = unitTypeIdentityValue.getName();
                            if (tmp.trim().length() > 0) {
                                unitType = tmp;
                            }
                        }
                        catch (Throwable ex) {
                            log.error((Object)(method + "Could not get unitType for unit " + unitId), ex);
                        }
                        HashMap<String, String> values = new HashMap<String, String>();
                        values.put("UnitName", value.getName());
                        values.put("UnitKind", unitType);
                        values.put("UnitType", unitType);
                        unitIdents.put(unitId, values);
                    }
                }
            }
            if (unitPermissions != null && unitPermissions.size() > 0) {
                initialUnitsCollector.put("unitIdentityValues", unitIdents);
                Collection colArea = null;
                try {
                    if (unitGroupId != -1L) {
                        colArea = this.areaLocalHome.findOrderedByPriorityByAirport(unitGroupId);
                    }
                    if (colArea == null || colArea.size() <= 0) {
                        colArea = this.areaLocalHome.findOrderedByPriority();
                    }
                }
                catch (FinderException ex) {
                    log.error((Object)"runs into", (Throwable)ex);
                }
                if (colArea != null && colArea.size() > 0) {
                    HashMap areas = new HashMap();
                    for (AreaLocal local : colArea) {
                        AreaValue value = local.getAreaValue();
                        if (value == null) continue;
                        HashMap<String, String> values = new HashMap<String, String>();
                        values.put("Area", value.getArea());
                        values.put("AreaName", value.getDescription());
                        areas.put(value.getAreaId(), values);
                    }
                    initialUnitsCollector.put("areaValues", areas);
                } else {
                    initialUnitsCollector.put("areaValues", new HashMap());
                }
                HashMap<Long, HashMap> gdataInitialCacheMap = this.replayFastLane.getInitialGeoCache(unitPermissions, fromTime);
                HashMap<Long, HashMap<Long, HashMap>> stateInitialCacheCol = this.replayFastLane.getInitialStateCache(unitPermissions, fromTime);
                TreeMap<Long, HashMap> tmpGeoReplayMap = this.replayFastLane.getGeoHistory(replayDataMap, fromTime, toTime);
                HashMap<Long, HashMap> gdataInitialHistoryMap = new HashMap<Long, HashMap>();
                TreeMap<Long, HashMap> clonedTmpGeoReplayMap = new TreeMap<Long, HashMap>((SortedMap<Long, HashMap>)tmpGeoReplayMap);
                Object[] geoBeginTimes = clonedTmpGeoReplayMap.keySet().toArray();
                int geoBeginTimesLength = geoBeginTimes.length;
                for (int i = 0; i < geoBeginTimesLength; ++i) {
                    long beginTime = (Long)geoBeginTimes[i];
                    HashMap event = clonedTmpGeoReplayMap.get(beginTime);
                    long unitId = (Long)event.get("UnitId");
                    if (!unitPermissions.contains(unitId)) {
                        replayDataMap.remove(beginTime);
                        tmpGeoReplayMap.remove(beginTime);
                        continue;
                    }
                    if (beginTime > fromTime || gdataInitialHistoryMap.containsKey(unitId)) continue;
                    gdataInitialHistoryMap.put(unitId, replayDataMap.remove(beginTime));
                }
                TreeMap<Long, HashMap> tmpStateReplayMap = this.replayFastLane.getStateHistory(replayDataMap, fromTime, toTime);
                HashMap<Long, HashMap> stateInitialHistoryMap = new HashMap<Long, HashMap>();
                TreeMap<Long, HashMap> clonedTmpStateReplayMap = new TreeMap<Long, HashMap>((SortedMap<Long, HashMap>)tmpStateReplayMap);
                Object[] stateBeginTimes = clonedTmpStateReplayMap.keySet().toArray();
                int stateBeginTimesLength = stateBeginTimes.length;
                for (int i = 0; i < stateBeginTimesLength; ++i) {
                    HashMap stateMap;
                    long beginTime = (Long)stateBeginTimes[i];
                    HashMap event = clonedTmpStateReplayMap.get(beginTime);
                    long unitId = (Long)event.get("UnitId");
                    long stateModelId = (Long)event.get("StateModelID");
                    if (!unitPermissions.contains(unitId)) {
                        replayDataMap.remove(beginTime);
                        tmpStateReplayMap.remove(beginTime);
                        continue;
                    }
                    if (beginTime > fromTime) continue;
                    if (!stateInitialHistoryMap.containsKey(unitId)) {
                        stateMap = new HashMap();
                        stateMap.put(stateModelId, replayDataMap.remove(beginTime));
                        stateInitialHistoryMap.put(unitId, stateMap);
                        continue;
                    }
                    stateMap = (HashMap)stateInitialHistoryMap.get(unitId);
                    if (stateMap.containsKey(stateModelId)) continue;
                    stateMap.put(stateModelId, replayDataMap.remove(beginTime));
                    stateInitialHistoryMap.put(unitId, stateMap);
                }
                TreeMap<Long, HashMap> geoCacheReplayMap = this.replayFastLane.getGeoCache(unitPermissions, replayDataMap, fromTime, toTime);
                TreeMap<Long, HashMap> stateCacheReplayMap = this.replayFastLane.getStateCache(unitPermissions, replayDataMap, fromTime, toTime);
                TreeMap<Long, HashMap> keepAliveCacheReplayMap = this.replayFastLane.getKeepAliveCache(unitPermissions, replayDataMap, fromTime, toTime);
                TreeMap<Long, HashMap> keepAliveHistoryReplayMap = this.replayFastLane.getKeepAliveHistory(unitPermissions, replayDataMap, fromTime, toTime);
                HashMap<Long, HashMap> keepAliveCacheInitMap = this.replayFastLane.getInitialKeepAliveCache(unitPermissions, fromTime);
                HashSet<Long> keepAliveHistoryUnitIds = new HashSet<Long>(unitPermissions);
                keepAliveHistoryUnitIds.removeAll(keepAliveCacheInitMap.keySet());
                HashMap<Long, HashMap> keepAliveHistoryInitMap = this.replayFastLane.getInitialKeepAliveHistory(keepAliveHistoryUnitIds, fromTime);
                TreeMap<Long, HashMap> notifyCacheReplayMap = null;
                TreeMap<Long, HashMap> notifyHistoryReplayMap = null;
                HashMap<Long, TreeMap> notifyInitMap = null;
                if (sendNotifiesData) {
                    notifyCacheReplayMap = this.replayFastLane.getNotifyCache(unitPermissions, replayDataMap, fromTime, toTime);
                    notifyHistoryReplayMap = this.replayFastLane.getNotifyHistory(unitPermissions, replayDataMap, fromTime, toTime);
                    notifyInitMap = this.replayFastLane.getInitialNotifyCache(unitPermissions, fromTime, maximumNotifiesPerDay);
                    notifyInitMap = this.replayFastLane.getInitialNotifyHistory(unitPermissions, fromTime, notifyInitMap, maximumNotifiesPerDay);
                }
                TreeMap<Long, HashMap> useCacheReplayMap = null;
                TreeMap<Long, HashMap> useHistoryReplayMap = null;
                HashMap<Long, HashMap> useCacheInitMap = null;
                HashMap<Long, HashMap> useHistoryInitMap = null;
                if (sendUseMsgsData) {
                    useCacheReplayMap = this.replayFastLane.getUseCache(unitPermissions, replayDataMap, fromTime, toTime);
                    useHistoryReplayMap = this.replayFastLane.getUseHistory(unitPermissions, replayDataMap, fromTime, toTime);
                    useCacheInitMap = this.replayFastLane.getInitialUseCache(unitPermissions, fromTime);
                    useHistoryInitMap = this.replayFastLane.getInitialUseHistory(unitPermissions, fromTime);
                }
                TreeMap<Long, HashMap> infomanMsgCacheReplayMap = null;
                TreeMap<Long, HashMap> infomanMsgHistoryReplayMap = null;
                HashMap<Long, HashMap> infomanMsgCacheInitMap = null;
                HashMap<Long, HashMap> infomanMsgHistoryInitMap = null;
                if (sendInfomanMsgsData) {
                    infomanMsgCacheReplayMap = this.replayFastLane.getInfomanMsgCache(unitPermissions, replayDataMap, fromTime, toTime);
                    infomanMsgHistoryReplayMap = this.replayFastLane.getInfomanMsgHistory(unitPermissions, replayDataMap, fromTime, toTime);
                    infomanMsgCacheInitMap = this.replayFastLane.getInitialInfomanMsgCache(unitPermissions, fromTime);
                    HashSet<Long> infomanMsgHistoryUnitIds = new HashSet<Long>(unitPermissions);
                    infomanMsgHistoryUnitIds.removeAll(infomanMsgCacheInitMap.keySet());
                    infomanMsgHistoryInitMap = this.replayFastLane.getInitialInfomanMsgHistory(infomanMsgHistoryUnitIds, fromTime);
                }
                if (log.isDebugEnabled()) {
                    if (unitGroupId > -1L) {
                        log.debug((Object)(method + "Replay data overview for airport id '" + unitGroupId + "':"));
                    }
                    initialUnitsDataSize = unitPermissions.size() + unitIdents.size() + colArea.size() + gdataInitialCacheMap.size() + stateInitialCacheCol.size() + keepAliveCacheInitMap.size() + gdataInitialHistoryMap.size() + stateInitialHistoryMap.size() + keepAliveHistoryInitMap.size();
                    log.debug((Object)(method + "Collection size unitPermissions: " + unitPermissions.size()));
                    log.debug((Object)(method + "Collection size UnitIdentity: " + unitIdents.size()));
                    log.debug((Object)(method + "Collection size Area: " + colArea.size()));
                    log.debug((Object)(method + "Size for initial GdataCache: " + gdataInitialCacheMap.size()));
                    log.debug((Object)(method + "Size for initial StateCache: " + stateInitialCacheCol.size()));
                    log.debug((Object)(method + "Size for initial KeepAliveCache: " + keepAliveCacheInitMap.size()));
                    log.debug((Object)(method + "Size for initial GdataHistory: " + gdataInitialHistoryMap.size()));
                    log.debug((Object)(method + "Size for initial StateHistory: " + stateInitialHistoryMap.size()));
                    log.debug((Object)(method + "Size for initial KeepAliveHistory: " + keepAliveHistoryInitMap.size()));
                    if (sendNotifiesData) {
                        log.debug((Object)(method + "Size for initial Notify (cache and history): " + notifyInitMap.size()));
                        initialUnitsDataSize += notifyInitMap.size();
                    }
                    if (sendUseMsgsData) {
                        log.debug((Object)(method + "Size for initial UseCache: " + useCacheInitMap.size()));
                        log.debug((Object)(method + "Size for initial UseHistory: " + useHistoryInitMap.size()));
                        initialUnitsDataSize = initialUnitsDataSize + useCacheInitMap.size() + useHistoryInitMap.size();
                    }
                    if (sendInfomanMsgsData) {
                        log.debug((Object)(method + "Size for initial InfomanMsgCache: " + infomanMsgCacheInitMap.size()));
                        log.debug((Object)(method + "Size for initial InfomanMsgHistory: " + infomanMsgHistoryInitMap.size()));
                        initialUnitsDataSize = initialUnitsDataSize + infomanMsgCacheInitMap.size() + infomanMsgHistoryInitMap.size();
                    }
                    log.debug((Object)(method + "Size of complete initial units data: " + initialUnitsDataSize));
                    log.debug((Object)(method + "Size for replay data of GdataCache: " + geoCacheReplayMap.size()));
                    log.debug((Object)(method + "Size for replay data of StateCache: " + stateCacheReplayMap.size()));
                    log.debug((Object)(method + "Size for replay data of KeepAliveCache: " + keepAliveCacheReplayMap.size()));
                    log.debug((Object)(method + "Size for replay data of GdataHistory: " + tmpGeoReplayMap.size()));
                    log.debug((Object)(method + "Size for replay data of StateHistory: " + tmpStateReplayMap.size()));
                    log.debug((Object)(method + "Size for replay data of KeepAliveHistory: " + keepAliveHistoryReplayMap.size()));
                    if (sendNotifiesData) {
                        log.debug((Object)(method + "Size for replay data of NotifyCache: " + notifyCacheReplayMap.size()));
                        log.debug((Object)(method + "Size for replay data of NotifyHistory: " + notifyHistoryReplayMap.size()));
                    }
                    if (sendUseMsgsData) {
                        log.debug((Object)(method + "Size for replay data of UseCache: " + useCacheReplayMap.size()));
                        log.debug((Object)(method + "Size for replay data of UseHistory: " + useHistoryReplayMap.size()));
                    }
                    if (sendInfomanMsgsData) {
                        log.debug((Object)(method + "Size for replay data of InfomanMsgCache: " + infomanMsgCacheReplayMap.size()));
                        log.debug((Object)(method + "Size for replay data of InfomanMsgHistory: " + infomanMsgHistoryReplayMap.size()));
                    }
                }
                initialUnitsCollector.put("initGdataCache", gdataInitialCacheMap);
                initialUnitsCollector.put("initGdataHistory", gdataInitialHistoryMap);
                initialUnitsCollector.put("initStateCache", stateInitialCacheCol);
                initialUnitsCollector.put("initStateHistory", stateInitialHistoryMap);
                initialUnitsCollector.put("initKeepAliveCache", keepAliveCacheInitMap);
                initialUnitsCollector.put("initKeepAliveHistory", keepAliveHistoryInitMap);
                if (sendNotifiesData) {
                    initialUnitsCollector.put("initNotify", notifyInitMap);
                }
                if (sendUseMsgsData) {
                    initialUnitsCollector.put("initUseCache", useCacheInitMap);
                    initialUnitsCollector.put("initUseHistory", useHistoryInitMap);
                }
                if (sendInfomanMsgsData) {
                    initialUnitsCollector.put("initInfomanMsgCache", infomanMsgCacheInitMap);
                    initialUnitsCollector.put("initInfomanMsgHistory", infomanMsgHistoryInitMap);
                }
            } else {
                log.warn((Object)"User has no unit permissions! Replay for units not possible without unit permissions!");
            }
            completeMap.put("InitialContext", initialUnitsCollector);
        }
        int initialStandsDataSize = 0;
        HashMap initialStandsCollector = new HashMap();
        if (sendStandsData) {
            log.warn((Object)"***** TEMPORARY IMPLEMENTATION OF REPLAY FOR STANDS! *****");
            StandsDataFactory initialStandsData = new StandsDataFactory();
            TreeMap<Long, HashMap> tmpFisFlightCacheReplayMap = this.replayFastLane.getFisFlightCache(replayDataMap, fromTime, toTime);
            TreeMap<Long, HashMap> fisGseCacheReplayMap = this.replayFastLane.getFisGseCache(replayDataMap, fromTime, toTime);
            TreeMap<Long, HashMap> fisStaffCacheReplayMap = this.replayFastLane.getFisStaffCache(replayDataMap, fromTime, toTime);
            TreeMap<Long, HashMap> tmpFisFlightHistoryReplayMap = this.replayFastLane.getFisFlightHistory(replayDataMap, fromTime, toTime);
            TreeMap<Long, HashMap> fisGseHistoryReplayMap = this.replayFastLane.getFisGseHistory(replayDataMap, fromTime, toTime);
            TreeMap<Long, HashMap> fisStaffHistoryReplayMap = this.replayFastLane.getFisStaffHistory(replayDataMap, fromTime, toTime);
            TreeMap<Long, HashMap> completeFisReplayMap = new TreeMap<Long, HashMap>((SortedMap<Long, HashMap>)tmpFisFlightCacheReplayMap);
            completeFisReplayMap.putAll(tmpFisFlightHistoryReplayMap);
            Object[] fisFlightBeginTimes = completeFisReplayMap.keySet().toArray();
            int fisFlightBeginTimesLength = fisFlightBeginTimes.length;
            for (int i = 0; i < fisFlightBeginTimesLength; ++i) {
                long beginTime = (Long)fisFlightBeginTimes[i];
                HashMap event = completeFisReplayMap.get(beginTime);
                String uaft = (String)event.get("oid");
                if (event.containsKey("onbl")) {
                    long onbl = (Long)event.get("onbl");
                    if (onbl > toTime) {
                        replayDataMap.remove(beginTime);
                        completeFisReplayMap.remove(beginTime);
                        continue;
                    }
                    if (onbl > fromTime) {
                        continue;
                    }
                } else if (event.containsKey("ofbl")) {
                    long ofbl = (Long)event.get("ofbl");
                    if (ofbl > toTime) {
                        replayDataMap.remove(beginTime);
                        completeFisReplayMap.remove(beginTime);
                        continue;
                    }
                    if (ofbl > fromTime) continue;
                }
                replayDataMap.remove(beginTime);
                completeFisReplayMap.remove(beginTime);
                Map flightEvent = initialStandsData.getSpecificFlightEvent(uaft);
                if (flightEvent != null) {
                    flightEvent.putAll(event);
                    initialStandsData.addADFlight(uaft, flightEvent);
                    continue;
                }
                initialStandsData.addADFlight(uaft, (Map)event);
            }
            initialStandsData.updateOnOffStateOfStands();
            Map allAdFlights = initialStandsData.getAllADFlights();
            Set<String> uafts = allAdFlights.keySet();
            List<HashMap> initialFisGseCacheMap = this.replayFastLane.getInitialFisGseCache(uafts, fromTime);
            List<HashMap> initialFisGseHistoryMap = this.replayFastLane.getInitialFisGseHistory(uafts, fromTime);
            ArrayList<HashMap> initialGseList = new ArrayList<HashMap>(initialFisGseCacheMap);
            initialGseList.addAll(initialFisGseHistoryMap);
            int initialGseListSize = initialGseList.size();
            for (int i = 0; i < initialGseListSize; ++i) {
                HashMap map = (HashMap)initialGseList.get(i);
                String uaft = (String)map.remove("oid");
                initialStandsData.addGSEAllocationEvent(uaft, (Map)map);
            }
            List<HashMap> initialFisStaffCacheMap = this.replayFastLane.getInitialFisStaffCache(uafts, fromTime);
            List<HashMap> initialFisStaffHistoryMap = this.replayFastLane.getInitialFisStaffHistory(uafts, fromTime);
            ArrayList<HashMap> initialStaffList = new ArrayList<HashMap>(initialFisStaffCacheMap);
            initialStaffList.addAll(initialFisStaffHistoryMap);
            int initialStaffListSize = initialStaffList.size();
            for (int i = 0; i < initialStaffListSize; ++i) {
                HashMap map = (HashMap)initialStaffList.get(i);
                String uaft = (String)map.remove("oid");
                initialStandsData.addStaffAllocationEvent(uaft, (Map)map);
            }
            initialStandsData.addGeneralValue("ServerTime", (Object)System.currentTimeMillis());
            initialStandsData.addGeneralValue("ServerTimeZone", (Object)TimeZone.getDefault().getID());
            initialStandsData.addGeneralValue("DataType", (Object)"data_type_stands");
            initialStandsCollector = (HashMap)initialStandsData.getTransferData();
            if (log.isDebugEnabled()) {
                initialStandsDataSize = uafts.size() + initialFisGseCacheMap.size() + initialFisGseHistoryMap.size() + initialFisStaffCacheMap.size() + initialFisStaffHistoryMap.size();
                log.debug((Object)(method + "Size for initial FIS flights: " + uafts.size()));
                log.debug((Object)(method + "Size for initial FIS GSE cache: " + initialFisGseCacheMap.size()));
                log.debug((Object)(method + "Size for initial FIS staff cache: " + initialFisStaffCacheMap.size()));
                log.debug((Object)(method + "Size for initial FIS GSE history: " + initialFisGseHistoryMap.size()));
                log.debug((Object)(method + "Size for initial FIS staff history: " + initialFisStaffHistoryMap.size()));
                log.debug((Object)(method + "Size of complete initial stands data: " + initialStandsDataSize));
                log.debug((Object)(method + "Size for replay data of FIS flights: " + completeFisReplayMap.size()));
                log.debug((Object)(method + "Size for replay data of FIS GSE cache: " + fisGseCacheReplayMap.size()));
                log.debug((Object)(method + "Size for replay data of FIS staff cache: " + fisStaffCacheReplayMap.size()));
                log.debug((Object)(method + "Size for replay data of FIS GSE history: " + fisGseHistoryReplayMap.size()));
                log.debug((Object)(method + "Size for replay data of FIS staff history: " + fisStaffHistoryReplayMap.size()));
            }
            completeMap.put("InitialStandsContext", initialStandsCollector);
        }
        completeMap.put("ReplayData", replayDataMap);
        if (log.isDebugEnabled()) {
            if (sendUnitsData && sendStandsData) {
                log.debug((Object)(method + "Size of complete replay data (units and stands): " + replayDataMap.size()));
            } else if (sendUnitsData) {
                log.debug((Object)(method + "Size of complete unit replay data: " + replayDataMap.size()));
            } else if (sendStandsData) {
                log.debug((Object)(method + "Size of complete stands replay data: " + replayDataMap.size()));
            } else {
                log.debug((Object)(method + "Size of complete replay data: " + replayDataMap.size()));
            }
        }
        stopwatch.stop("overall", true, initialStandsDataSize + initialUnitsDataSize + replayDataMap.size());
        return completeMap;
    }

    private UnitTreeNode findUnitGroupNode(UnitTreeNode unitNode, long unitGroupId) {
        List children;
        if (unitNode == null) {
            return null;
        }
        UnitTreeNode ret = null;
        UnitModelValue unitModelValue = ((UnitDTO)unitNode.getData()).getUnitModelValue();
        long unitId = unitModelValue.getUnitId();
        if (unitId == unitGroupId) {
            return unitNode;
        }
        if (unitNode.hasChildren() && (children = unitNode.getChildren()) != null) {
            for (UnitTreeNode childUnitNode : children) {
                ret = this.findUnitGroupNode(childUnitNode, unitGroupId);
                if (ret == null) continue;
                return ret;
            }
        }
        return ret;
    }

    private boolean isUnitIdInGroup(UnitTreeNode unitNode, long unitId) {
        List children;
        boolean ret = false;
        if (unitNode == null) {
            return ret;
        }
        UnitModelValue unitModelValue = ((UnitDTO)unitNode.getData()).getUnitModelValue();
        long thisUnitId = unitModelValue.getUnitId();
        if (thisUnitId == unitId) {
            ret = true;
            return ret;
        }
        if (!unitModelValue.getBasic() && (children = unitNode.getChildren()) != null) {
            for (UnitTreeNode childUnitNode : children) {
                ret = this.isUnitIdInGroup(childUnitNode, unitId);
                if (!ret) continue;
                return ret;
            }
        }
        return ret;
    }
}

