/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.raw;

import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryValue;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupValue;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import java.io.Serializable;

public class UseStamp
implements Serializable {
    protected long requestedBeginTime;
    protected long requestedEndTime;
    protected long eventEntryTime;
    protected long eventDuration;
    protected long begin;
    protected long end;
    protected long duration;
    protected long unitId;
    protected long userId;
    protected long groupId;
    protected String userName;
    protected String groupName;

    public UseStamp(UseCacheValue ucs, UseUserValue uus, UseGroupValue ugs, long reqBeginTime, long reqEndTime) {
        this.requestedBeginTime = reqBeginTime;
        this.requestedEndTime = reqEndTime;
        this.eventEntryTime = ucs.getBeginTime();
        this.eventDuration = this.requestedEndTime - this.eventEntryTime;
        this.initFromCache(ucs);
        this.addUserDetails(uus);
        this.addGroupDetails(ugs);
    }

    public UseStamp(UseHistoryValue uhs, UseUserValue uus, UseGroupValue ugs, long reqBeginTime, long reqEndTime) {
        this.requestedBeginTime = reqBeginTime;
        this.requestedEndTime = reqEndTime;
        this.eventEntryTime = uhs.getBeginTime();
        this.eventDuration = uhs.getEndTime() - this.eventEntryTime;
        this.initFromHistory(uhs);
        this.addUserDetails(uus);
        this.addGroupDetails(ugs);
    }

    protected void initFromCache(UseCacheValue ucs) {
        this.userId = ucs.getUserId();
        this.groupId = ucs.getGroupId();
        this.unitId = ucs.getUnitId();
        this.begin = this.eventEntryTime < this.requestedBeginTime ? this.requestedBeginTime : this.eventEntryTime;
        this.end = this.requestedEndTime;
        this.duration = this.end - this.begin;
    }

    protected void initFromHistory(UseHistoryValue uhs) {
        this.userId = uhs.getUserId();
        this.groupId = uhs.getGroupId();
        this.unitId = uhs.getUnitId();
        this.begin = this.eventEntryTime < this.requestedBeginTime ? this.requestedBeginTime : this.eventEntryTime;
        long eventExitTime = uhs.getEndTime();
        this.end = eventExitTime > this.requestedEndTime ? this.requestedEndTime : eventExitTime;
        this.duration = this.end - this.begin;
    }

    protected void addUserDetails(UseUserValue uus) {
        this.userName = uus.getName();
    }

    protected void addGroupDetails(UseGroupValue ugs) {
        this.groupName = ugs.getName();
    }

    public String toString() {
        String dump = UseStamp.class.getName() + " ( ";
        dump = dump + "begin:'" + this.begin + "' ";
        dump = dump + "/ end:'" + this.end + "' ";
        dump = dump + "/ duration:'" + this.duration + "' ";
        return dump;
    }

    public long getBegin() {
        return this.begin;
    }

    public long getEnd() {
        return this.end;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getEventDuration() {
        return this.eventDuration;
    }

    public long getEventEntryTime() {
        return this.eventEntryTime;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public long getUnitId() {
        return this.unitId;
    }

    public long getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }
}

