/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.stands.parser;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.observable.stands.StandsDataFactory;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeUtil;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleStandEventXMLParserFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final long serialVersionUID = 2048271580751276663L;
    private static final Log log = LogFactory.getLog(SingleStandEventXMLParserFacadeBean.class);
    private StandsDataFactory _standsDataFactory = null;
    private InformantFacadeLocal informantFacadeLocal = null;

    public void ejbCreate() {
        this._standsDataFactory = new StandsDataFactory();
        try {
            this.informantFacadeLocal = InformantFacadeUtil.getLocalHome().create();
        }
        catch (CreateException e) {
            log.error((Object)"ejbCreate() runs into CreateException: ", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"ejbCreate() runs into NamingException: ", (Throwable)e);
        }
    }

    public StandsDataFactory parseXMLDocument(String xmlDocument) {
        if (xmlDocument.indexOf("MErrL=\"Error\"") != -1) {
            log.error((Object)"parseXMLDocument(): Incoming document contains error! Data isn't available!");
            return null;
        }
        this._standsDataFactory = new StandsDataFactory();
        try {
            StringReader inStream = new StringReader(xmlDocument);
            InputSource inSource = new InputSource(inStream);
            Document doc = new SAXBuilder().build(inSource);
            Element mbOs = doc.getRootElement();
            List mboChilds = mbOs.getChildren();
            this.handleEVEs(mboChilds);
        }
        catch (JDOMException e) {
            log.error((Object)"parseXMLDocument() runs into JDOMException: ", (Throwable)e);
            this.informantFacadeLocal.notify("Parser() runs into JDOMException: " + (Object)((Object)e), "StandErrorEvent");
        }
        catch (IOException e) {
            log.error((Object)"parseXMLDocument() runs into IOException: ", (Throwable)e);
            this.informantFacadeLocal.notify("Parser() runs into IOException: " + e, "StandErrorEvent");
        }
        return this._standsDataFactory;
    }

    private void handleEVEs(List mboChilds) {
        for (Element mboChild : mboChilds) {
            Map<String, Object> itemMap;
            if (!mboChild.getName().equals("Eve")) continue;
            List eveItemsList = mboChild.getChildren();
            if (mboChild.getAttributeValue("K").equals("1")) {
                itemMap = this.createItemMapForUpdate(eveItemsList);
                this._standsDataFactory.addFlightEvent((String)itemMap.get("oid"), itemMap);
                continue;
            }
            if (mboChild.getAttributeValue("K").equals("2") && mboChild.getAttributeValue("N").equals("StandAllocation")) {
                itemMap = this.createItemMapForUpdate(eveItemsList);
                this._standsDataFactory.addFlightEvent((String)itemMap.get("oid"), itemMap);
                continue;
            }
            if (!mboChild.getAttributeValue("K").equals("3")) continue;
            this._standsDataFactory.addGeneralValue("UPDATE_ALL_DATA_FLAG", (Object)"");
        }
    }

    private Map<String, Object> createItemMapForUpdate(List eveItemsList) {
        Iterator it2 = eveItemsList.iterator();
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        while (it2.hasNext()) {
            Element item = (Element)it2.next();
            String value = item.getAttributeValue("V");
            if (value == null) {
                value = "";
            }
            if (value.equals("planii") && item.getAttributeValue("N").equals("10001")) continue;
            if ((item.getAttributeValue("N").equals("st") || item.getAttributeValue("N").equals("et")) && value.indexOf("T") != -1) {
                itemMap.put(item.getAttributeValue("N"), this.parseTime(item.getAttributeValue("V")));
                continue;
            }
            itemMap.put(item.getAttributeValue("N"), item.getAttributeValue("V"));
        }
        return itemMap;
    }

    private Long parseTime(String time) {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            date = simpleDateFormat.parse(time);
        }
        catch (ParseException e) {
            log.error((Object)("parseTime() runs into ParseException: " + e));
            this.informantFacadeLocal.notify("parseTime() runs into ParseException: " + e, "StandErrorEvent");
        }
        return new Long(date.getTime());
    }
}

