/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.stands.parser;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.observable.stands.StandsDataFactory;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.stands.GSRealTimeObjectServerConnectorFacadeBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllStandsXMLParserFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final long serialVersionUID = -956774349983952720L;
    private static final Log log = LogFactory.getLog(AllStandsXMLParserFacadeBean.class);
    private static final String XML_FILE = "allStates.xml";
    private StandsDataFactory _standsDataFactory = null;
    private InformantFacadeLocal informantFacadeLocal = null;

    public void ejbCreate() {
        this._standsDataFactory = new StandsDataFactory();
        try {
            this.informantFacadeLocal = InformantFacadeUtil.getLocalHome().create();
        }
        catch (CreateException e) {
            log.error((Object)"ejbCreate() runs into CreateException: ", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"ejbCreate() runs into NamingException: ", (Throwable)e);
        }
    }

    public String readTestDocument() {
        log.debug((Object)"Reading test document...");
        String file = "";
        String getterXMLPath = "/de/proveo/util/stands/ressource/example/";
        InputStream inputStream = GSRealTimeObjectServerConnectorFacadeBean.class.getResourceAsStream("/de/proveo/util/stands/ressource/example/allStates.xml");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String line = "";
        try {
            while ((line = bufferedReader.readLine()) != null) {
                file = file + line;
            }
        }
        catch (IOException e) {
            log.error((Object)"readFile runs into IOException: ", (Throwable)e);
            this.informantFacadeLocal.notify("readFile runs into IOException: " + e, "StandErrorEvent");
        }
        log.debug((Object)"File read!");
        return file;
    }

    public StandsDataFactory parseXMLDocument(String xmlDocument) {
        if (xmlDocument.indexOf("MErrL=\"Error\"") != -1) {
            log.error((Object)"parseXMLDocument(): Incoming document contains error! Data isn't available!");
            return null;
        }
        this._standsDataFactory = new StandsDataFactory();
        try {
            StringReader inStream = new StringReader(xmlDocument);
            InputSource inSource = new InputSource(inStream);
            Document doc = new SAXBuilder().build(inSource);
            Element mbOs = doc.getRootElement();
            Element ros = mbOs.getChild("Res").getChild("ROs");
            List rosList = ros.getChildren();
            this.handleROs(rosList);
        }
        catch (JDOMException e) {
            log.error((Object)"Parser() runs into JDOMException: ", (Throwable)e);
            this.informantFacadeLocal.notify("Parser() runs into JDOMException: " + (Object)((Object)e), "StandErrorEvent");
        }
        catch (IOException e) {
            log.error((Object)"Parser() runs into IOException: ", (Throwable)e);
            this.informantFacadeLocal.notify("Parser() runs into IOException: " + e, "StandErrorEvent");
        }
        return this._standsDataFactory;
    }

    private void handleROs(List rosList) {
        for (Element ro : rosList) {
            List roList = ro.getChildren();
            Map<String, Object> itemMap = this.createItemMap(roList);
            if (itemMap.get("oid") == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"No flight id (oid) available! Flight won't be insert!");
                continue;
            }
            this._standsDataFactory.addFlightEvent((String)itemMap.get("oid"), itemMap);
        }
    }

    private Map<String, Object> createItemMap(List roList) {
        Iterator it2 = roList.iterator();
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        while (it2.hasNext()) {
            Element item = (Element)it2.next();
            String value = item.getAttributeValue("V");
            if (value.equals("planii") && item.getAttributeValue("N").equals("10001")) continue;
            if ((item.getAttributeValue("N").equals("st") || item.getAttributeValue("N").equals("et")) && value.indexOf("T") != -1) {
                itemMap.put(item.getAttributeValue("N"), this.parseTime(item.getAttributeValue("V")));
                continue;
            }
            itemMap.put(item.getAttributeValue("N"), item.getAttributeValue("V"));
        }
        return itemMap;
    }

    private Long parseTime(String time) {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            date = simpleDateFormat.parse(time);
        }
        catch (ParseException e) {
            log.error((Object)("parseTime runs into ParseException: " + e));
            this.informantFacadeLocal.notify("parseTime() runs into ParseException: " + e, "StandErrorEvent");
        }
        return new Long(date.getTime());
    }
}

